/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentracing;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.concurrent.CountDownLatch;
import org.eclipse.microprofile.rest.client.ext.AsyncInvocationInterceptor;

public class OpenTracingAsyncInterceptor
implements AsyncInvocationInterceptor {
    private final Tracer tracer;
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private Span span;
    private Scope scope;

    public OpenTracingAsyncInterceptor(Tracer tracer) {
        this.tracer = tracer;
    }

    public void prepareContext() {
        this.span = this.tracer.activeSpan();
        this.countDownLatch.countDown();
    }

    public void applyContext() {
        try {
            this.countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.scope = this.tracer.scopeManager().activate(this.span, false);
    }

    public void removeContext() {
        this.scope.close();
    }
}

