/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.parsing.Element;

public class GlobalMetricsConfiguration
implements ConfigurationInfo {
    public static final AttributeDefinition<Boolean> GAUGES = AttributeDefinition.builder((String)"gauges", (Object)true).immutable().build();
    public static final AttributeDefinition<Boolean> HISTOGRAMS = AttributeDefinition.builder((String)"histograms", (Object)false).immutable().build();
    public static final AttributeDefinition<String> PREFIX = AttributeDefinition.builder((String)"prefix", (Object)"").immutable().build();
    public static final AttributeDefinition<Boolean> NAMES_AS_TAGS = AttributeDefinition.builder((String)"namesAsTags", (Object)false).immutable().build();
    private static final ElementDefinition<GlobalMetricsConfiguration> ELEMENT_DEFINITION = new DefaultElementDefinition(Element.METRICS.getLocalName());
    private final AttributeSet attributes;
    private final Attribute<Boolean> gauges;
    private final Attribute<Boolean> histograms;
    private final Attribute<String> prefix;
    private final Attribute<Boolean> namesAsTags;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalMetricsConfiguration.class, new AttributeDefinition[]{GAUGES, HISTOGRAMS, PREFIX, NAMES_AS_TAGS});
    }

    GlobalMetricsConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
        this.gauges = attributes.attribute(GAUGES);
        this.histograms = attributes.attribute(HISTOGRAMS);
        this.prefix = attributes.attribute(PREFIX);
        this.namesAsTags = attributes.attribute(NAMES_AS_TAGS);
    }

    public ElementDefinition<GlobalMetricsConfiguration> getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public boolean enabled() {
        return this.gauges() || this.histograms();
    }

    public boolean gauges() {
        return (Boolean)this.gauges.get();
    }

    public boolean histograms() {
        return (Boolean)this.histograms.get();
    }

    public String prefix() {
        return (String)this.prefix.get();
    }

    public boolean namesAsTags() {
        return (Boolean)this.namesAsTags.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalMetricsConfiguration that = (GlobalMetricsConfiguration)o;
        return this.attributes != null ? this.attributes.equals((Object)that.attributes) : that.attributes == null;
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }

    public String toString() {
        return "GlobalMetricsConfiguration{attributes=" + this.attributes + '}';
    }
}

