/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;

public final class TokenizerChain
extends Analyzer {
    private final CharFilterFactory[] charFilters;
    private final TokenizerFactory tokenizer;
    private final TokenFilterFactory[] filters;

    public TokenizerChain(CharFilterFactory[] charFilters, TokenizerFactory tokenizer, TokenFilterFactory[] filters) {
        this.charFilters = charFilters != null ? charFilters : new CharFilterFactory[]{};
        this.tokenizer = tokenizer;
        this.filters = filters != null ? filters : new TokenFilterFactory[]{};
    }

    public Reader initReader(String fieldName, Reader reader) {
        if (this.charFilters.length > 0) {
            Reader cs = reader;
            for (CharFilterFactory charFilter : this.charFilters) {
                cs = charFilter.create(cs);
            }
            return cs;
        }
        return reader;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader aReader) {
        Tokenizer tk;
        Tokenizer ts = tk = this.tokenizer.create(aReader);
        for (TokenFilterFactory filter : this.filters) {
            ts = filter.create((TokenStream)ts);
        }
        return new Analyzer.TokenStreamComponents(tk, (TokenStream)ts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TokenizerChain(");
        for (CharFilterFactory charFilterFactory : this.charFilters) {
            sb.append(charFilterFactory);
            sb.append(", ");
        }
        sb.append(this.tokenizer);
        for (CharFilterFactory charFilterFactory : this.filters) {
            sb.append(", ");
            sb.append(charFilterFactory);
        }
        sb.append(')');
        return sb.toString();
    }
}

