/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.transformers;

import java.util.Map;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ModelVersionRange;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.TransformersSubRegistration;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.domain.controller.transformers.ManagementTransformers;
import org.jboss.as.domain.controller.transformers.ServerGroupTransformers;

public class DomainTransformers {
    static final ModelVersion IGNORED_SUBSYSTEMS = ModelVersion.create((int)-1);
    private static final PathElement JSF_EXTENSION = PathElement.pathElement((String)"extension", (String)"org.jboss.as.jsf");
    static final ModelVersion VERSION_1_5 = ModelVersion.create((int)1, (int)5, (int)0);
    static final ModelVersion VERSION_1_6 = ModelVersion.create((int)1, (int)6, (int)0);
    static final ModelVersion VERSION_1_7 = ModelVersion.create((int)1, (int)7, (int)0);
    static final ModelVersion VERSION_2_0 = ModelVersion.create((int)2, (int)0, (int)0);
    static final ModelVersion VERSION_2_1 = ModelVersion.create((int)2, (int)1, (int)0);

    public static void initializeDomainRegistry(TransformerRegistry registry) {
        DomainTransformers.initializeChainedDomainRegistry(registry);
    }

    private static void initializeChainedDomainRegistry(TransformerRegistry registry) {
        ModelVersion currentVersion = ModelVersion.create((int)4, (int)0, (int)0);
        DomainTransformers.registerChainedManagementTransformers(registry, currentVersion);
        DomainTransformers.registerChainedServerGroupTransformers(registry, currentVersion);
    }

    private static void registerChainedManagementTransformers(TransformerRegistry registry, ModelVersion currentVersion) {
        ChainedTransformationDescriptionBuilder builder = ManagementTransformers.buildTransformerChain(currentVersion);
        DomainTransformers.registerChainedTransformer(registry, builder, VERSION_1_5, VERSION_1_6, VERSION_1_7);
    }

    private static void registerChainedServerGroupTransformers(TransformerRegistry registry, ModelVersion currentVersion) {
        ChainedTransformationDescriptionBuilder builder = ServerGroupTransformers.buildTransformerChain(currentVersion);
        DomainTransformers.registerChainedTransformer(registry, builder, VERSION_1_5, VERSION_1_6, VERSION_1_7);
        DomainTransformers.registerChainedTransformer(registry, builder, VERSION_2_0, VERSION_2_1);
    }

    private static void registerChainedTransformer(TransformerRegistry registry, ChainedTransformationDescriptionBuilder builder, ModelVersion ... versions) {
        for (Map.Entry entry : builder.build(versions).entrySet()) {
            TransformersSubRegistration domain = registry.getDomainRegistration((ModelVersionRange)entry.getKey());
            TransformationDescription.Tools.register((TransformationDescription)((TransformationDescription)entry.getValue()), (TransformersSubRegistration)domain);
        }
    }

    private static class IgnoreExtensionResourceTransformer
    implements ResourceTransformer {
        private final String[] subsystems;

        private IgnoreExtensionResourceTransformer(String ... subsystems) {
            this.subsystems = subsystems;
        }

        public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
            TransformationTarget target = context.getTarget();
            if (this.subsystems != null) {
                for (String name : this.subsystems) {
                    target.addSubsystemVersion(name, IGNORED_SUBSYSTEMS);
                }
            }
        }
    }
}

