/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jdbc;

import com.arjuna.ats.internal.jdbc.ConnectionControl;
import com.arjuna.ats.internal.jdbc.ConnectionImple;
import com.arjuna.ats.jta.TransactionManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class ConnectionManager {
    private static Set<ConnectionImple> _connections = new HashSet<ConnectionImple>();

    public static synchronized Connection create(String dbUrl, Properties info) throws SQLException {
        boolean poolingEnabled;
        String user = info.getProperty("user");
        String passwd = info.getProperty("password");
        String dynamic = info.getProperty("DYNAMIC_CLASS");
        String poolConnections = info.getProperty("POOL_CONNECTIONS", "true");
        if (dynamic == null) {
            dynamic = "";
        }
        if (poolingEnabled = "true".equalsIgnoreCase(poolConnections)) {
            Iterator<ConnectionImple> iterator = _connections.iterator();
            while (iterator.hasNext()) {
                ConnectionImple conn = iterator.next();
                ConnectionControl connControl = conn.connectionControl();
                javax.transaction.TransactionManager tm = TransactionManager.transactionManager();
                Transaction tx2 = null;
                Transaction tx1 = connControl.transaction();
                try {
                    tx2 = tm.getTransaction();
                }
                catch (SystemException se) {
                    // empty catch block
                }
                if (tx1 != null && tx1.equals(tx2) && connControl.url().equals(dbUrl) && connControl.user().equals(user) && connControl.password().equals(passwd) && connControl.dynamicClass().equals(dynamic)) {
                    try {
                        if (conn.isClosed()) continue;
                        return conn;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        SQLException sqlException = new SQLException(ex.getMessage());
                        sqlException.initCause(ex);
                        throw sqlException;
                    }
                }
                if (tx1 != null) continue;
                iterator.remove();
            }
        }
        ConnectionImple conn = new ConnectionImple(dbUrl, info);
        if (poolingEnabled) {
            _connections.add(conn);
        }
        return conn;
    }

    public static synchronized void remove(ConnectionImple conn) {
        _connections.remove(conn);
    }
}

