/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.permission;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import org.wildfly.security.permission.PermissionActions;

public final class SecurityDomainPermission
extends Permission {
    private static final long serialVersionUID = 8533735187740371169L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", String.class)};
    private transient String actionString;
    private transient int actions;

    public SecurityDomainPermission(String name) {
        super(name);
        this.actions = 0;
    }

    public SecurityDomainPermission(String name, String actions) {
        super(name);
        this.actions = PermissionActions.parseActionStringToInt(Action.class, actions);
    }

    @Override
    public boolean implies(Permission permission) {
        return permission instanceof SecurityDomainPermission && this.implies((SecurityDomainPermission)permission);
    }

    public boolean implies(SecurityDomainPermission permission) {
        return (this.actions & permission.actions) == permission.actions && this.getName().equals(permission.getName());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SecurityDomainPermission && this.equals((SecurityDomainPermission)obj);
    }

    public boolean equals(SecurityDomainPermission permission) {
        return this.actions == permission.actions && this.getName().equals(permission.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode() * 4 + this.actions;
    }

    @Override
    public String getActions() {
        String actionString = this.actionString;
        if (actionString == null) {
            actionString = this.actionString = PermissionActions.getCanonicalActionString(Action.class, this.actions);
        }
        return actionString;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = ois.readFields();
        this.actions = PermissionActions.parseActionStringToInt(Action.class, (String)getField.get("actions", ""));
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField putField = oos.putFields();
        putField.put("actions", this.getActions());
        oos.writeFields();
    }

    static enum Action {
        create,
        access;

    }
}

