/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.writers;

import java.util.HashSet;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.ws.wss.secext.AttributedString;
import org.picketlink.identity.federation.ws.wss.secext.KeyIdentifierType;
import org.picketlink.identity.federation.ws.wss.secext.SecurityTokenReferenceType;
import org.picketlink.identity.federation.ws.wss.secext.UsernameTokenType;

public class WSSecurityWriter {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final XMLStreamWriter writer;

    public WSSecurityWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public void write(UsernameTokenType usernameToken) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wsse", (String)"UsernameToken", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"wsse", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        String id = usernameToken.getId();
        if (StringUtil.isNullOrEmpty((String)id)) {
            throw logger.nullValueError("Id on the UsernameToken");
        }
        QName wsuIDQName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id", "wsu");
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"wsu", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)wsuIDQName, (String)id);
        AttributedString userNameAttr = usernameToken.getUsername();
        if (userNameAttr == null) {
            throw logger.nullValueError("User Name is null on the UsernameToken");
        }
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wsse", (String)"Username", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)userNameAttr.getValue());
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void writeLifetime(XMLGregorianCalendar created, XMLGregorianCalendar expires) throws ProcessingException {
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wsu", (String)"Created", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"wsu", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)created.toXMLFormat());
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wsu", (String)"Expires", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"wsu", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)expires.toXMLFormat());
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }

    public void writeSecurityTokenReference(SecurityTokenReferenceType secRef) throws ProcessingException {
        HashSet<String> usedNamespaces = new HashSet<String>();
        usedNamespaces.add("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wsse", (String)"SecurityTokenReference", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"wsse", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (StringUtil.isNotNull((String)secRef.getId())) {
            QName wsuIDQName = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id", "wsu");
            StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)"wsu", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)wsuIDQName, (String)secRef.getId());
            usedNamespaces.add("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        }
        for (Map.Entry<QName, String> entry : secRef.getOtherAttributes().entrySet()) {
            QName key = entry.getKey();
            if (!usedNamespaces.contains(key.getNamespaceURI())) {
                StaxUtil.writeNameSpace((XMLStreamWriter)this.writer, (String)key.getPrefix(), (String)key.getNamespaceURI());
                usedNamespaces.add(key.getNamespaceURI());
            }
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (QName)key, (String)entry.getValue());
        }
        for (Object obj : secRef.getAny()) {
            if (!(obj instanceof KeyIdentifierType)) continue;
            KeyIdentifierType keyId = (KeyIdentifierType)obj;
            StaxUtil.writeStartElement((XMLStreamWriter)this.writer, (String)"wsse", (String)"KeyIdentifier", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
            StaxUtil.writeAttribute((XMLStreamWriter)this.writer, (String)"ValueType", (String)keyId.getValueType());
            StaxUtil.writeCharacters((XMLStreamWriter)this.writer, (String)keyId.getValue());
            StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        }
        StaxUtil.writeEndElement((XMLStreamWriter)this.writer);
        StaxUtil.flush((XMLStreamWriter)this.writer);
    }
}

