/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.http;

import java.lang.annotation.Annotation;
import javax.enterprise.context.RequestScoped;
import javax.servlet.http.HttpServletRequest;
import org.jboss.weld.context.AbstractBoundContext;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.context.beanstore.SimpleNamingScheme;
import org.jboss.weld.context.beanstore.http.RequestBeanStore;
import org.jboss.weld.context.cache.RequestScopedCache;
import org.jboss.weld.context.http.HttpRequestContext;
import org.jboss.weld.logging.ContextLogger;
import org.jboss.weld.util.reflection.Reflections;

public class HttpRequestContextImpl
extends AbstractBoundContext<HttpServletRequest>
implements HttpRequestContext {
    private final NamingScheme namingScheme = new SimpleNamingScheme(HttpRequestContext.class.getName());

    public HttpRequestContextImpl(String contextId) {
        super(contextId, false);
    }

    public boolean associate(HttpServletRequest request) {
        if (this.getBeanStore() != null) {
            ContextLogger.LOG.beanStoreLeakDuringAssociation(this.getClass().getName(), request);
        }
        RequestBeanStore beanStore = new RequestBeanStore(request, this.namingScheme);
        this.setBeanStore(beanStore);
        beanStore.attach();
        return true;
    }

    @Override
    public void activate() {
        super.activate();
        RequestScopedCache.beginRequest();
    }

    @Override
    public void deactivate() {
        try {
            RequestScopedCache.endRequest();
        }
        finally {
            super.deactivate();
        }
    }

    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    public HttpServletRequest getHttpServletRequest() {
        if (this.getBeanStore() instanceof RequestBeanStore) {
            return ((RequestBeanStore)Reflections.cast(this.getBeanStore())).getRequest();
        }
        return null;
    }
}

