/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.AbstractKeyValueFilterConverter;
import org.infinispan.metadata.Metadata;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.FilterResultImpl;
import org.infinispan.query.dsl.embedded.impl.QueryCache;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.util.KeyValuePair;

public final class JPAFilterAndConverter<K, V>
extends AbstractKeyValueFilterConverter<K, V, ObjectFilter.FilterResult> {
    private QueryCache queryCache;
    private final String jpaQuery;
    private final Class<? extends Matcher> matcherImplClass;
    private Matcher matcher;
    private ObjectFilter objectFilter;

    public JPAFilterAndConverter(String jpaQuery, Class<? extends Matcher> matcherImplClass) {
        if (jpaQuery == null || matcherImplClass == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.jpaQuery = jpaQuery;
        this.matcherImplClass = matcherImplClass;
    }

    @Inject
    void injectDependencies(Cache cache) {
        this.queryCache = (QueryCache)cache.getCacheManager().getGlobalComponentRegistry().getComponent(QueryCache.class);
        this.matcher = (Matcher)cache.getAdvancedCache().getComponentRegistry().getComponent(this.matcherImplClass);
        if (this.matcher == null) {
            throw new CacheException("Expected component not found in registry: " + this.matcherImplClass.getName());
        }
    }

    public ObjectFilter getObjectFilter() {
        if (this.objectFilter == null) {
            if (this.queryCache != null) {
                KeyValuePair queryCacheKey = new KeyValuePair((Object)this.jpaQuery, this.matcherImplClass);
                ObjectFilter objectFilter = (ObjectFilter)this.queryCache.get((KeyValuePair<String, Class>)queryCacheKey);
                if (objectFilter == null) {
                    objectFilter = this.matcher.getObjectFilter(this.jpaQuery);
                    this.queryCache.put((KeyValuePair<String, Class>)queryCacheKey, objectFilter);
                }
                this.objectFilter = objectFilter;
            } else {
                this.objectFilter = this.matcher.getObjectFilter(this.jpaQuery);
            }
        }
        return this.objectFilter;
    }

    public String getJPAQuery() {
        return this.jpaQuery;
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    public ObjectFilter.FilterResult filterAndConvert(K key, V value, Metadata metadata) {
        if (value == null) {
            return null;
        }
        return this.getObjectFilter().filter(value);
    }

    public String toString() {
        return "FilterAndConverter{jpaQuery='" + this.jpaQuery + '\'' + '}';
    }

    public static final class FilterResultExternalizer
    extends AbstractExternalizer<FilterResultImpl> {
        public void writeObject(ObjectOutput output, FilterResultImpl filterResult) throws IOException {
            if (filterResult.getProjection() != null) {
                output.writeObject(null);
            } else {
                output.writeObject(filterResult.getInstance());
            }
            output.writeObject(filterResult.getProjection());
            output.writeObject(filterResult.getSortProjection());
        }

        public FilterResultImpl readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object instance = input.readObject();
            Object[] projection = (Object[])input.readObject();
            Comparable[] sortProjection = (Comparable[])input.readObject();
            return new FilterResultImpl(instance, projection, sortProjection);
        }

        public Integer getId() {
            return ExternalizerIds.JPA_FILTER_RESULT;
        }

        public Set<Class<? extends FilterResultImpl>> getTypeClasses() {
            return Collections.singleton(FilterResultImpl.class);
        }
    }

    public static final class FilterAndConverterExternalizer
    extends AbstractExternalizer<JPAFilterAndConverter> {
        public void writeObject(ObjectOutput output, JPAFilterAndConverter filterAndConverter) throws IOException {
            output.writeUTF(filterAndConverter.jpaQuery);
            output.writeObject(filterAndConverter.matcherImplClass);
        }

        public JPAFilterAndConverter readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            String jpaQuery = input.readUTF();
            Class matcherImplClass = (Class)input.readObject();
            return new JPAFilterAndConverter(jpaQuery, matcherImplClass);
        }

        public Integer getId() {
            return ExternalizerIds.JPA_FILTER_AND_CONVERTER;
        }

        public Set<Class<? extends JPAFilterAndConverter>> getTypeClasses() {
            return Collections.singleton(JPAFilterAndConverter.class);
        }
    }
}

