/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.parsing;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.parsing.WriteUtils;
import org.jboss.as.controller.resource.AbstractSocketBindingResourceDefinition;
import org.jboss.as.controller.resource.SocketBindingGroupResourceDefinition;
import org.jboss.as.server.services.net.LocalDestinationOutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.OutboundSocketBindingResourceDefinition;
import org.jboss.as.server.services.net.RemoteDestinationOutboundSocketBindingResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class SocketBindingsXml {
    SocketBindingsXml() {
    }

    void parseSocketBindingGroupRef(XMLExtendedStreamReader reader, ModelNode addOperation, SimpleAttributeDefinition socketBindingGroup, SimpleAttributeDefinition portOffset, SimpleAttributeDefinition defaultInterface) throws XMLStreamException {
        boolean gotRef = false;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case REF: {
                    socketBindingGroup.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    gotRef = true;
                    continue block5;
                }
                case PORT_OFFSET: {
                    portOffset.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                case DEFAULT_INTERFACE: {
                    if (defaultInterface == null) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    defaultInterface.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!gotRef) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.REF));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    String parseSocketBinding(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        String name = null;
        ModelNode binding = new ModelNode();
        binding.get("address");
        binding.get("operation").set("add");
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    binding.get("address").set(address).add("socket-binding", name);
                    continue block11;
                }
                case INTERFACE: {
                    AbstractSocketBindingResourceDefinition.INTERFACE.parseAndSetParameter(value, binding, (XMLStreamReader)reader);
                    if (binding.get(AbstractSocketBindingResourceDefinition.INTERFACE.getName()).getType() != ModelType.EXPRESSION && !interfaces.contains(value)) {
                        throw ControllerLogger.ROOT_LOGGER.unknownInterface(value, attribute.getLocalName(), Element.INTERFACES.getLocalName(), reader.getLocation());
                    }
                    binding.get("interface").set(value);
                    continue block11;
                }
                case PORT: {
                    AbstractSocketBindingResourceDefinition.PORT.parseAndSetParameter(value, binding, (XMLStreamReader)reader);
                    continue block11;
                }
                case FIXED_PORT: {
                    AbstractSocketBindingResourceDefinition.FIXED_PORT.parseAndSetParameter(value, binding, (XMLStreamReader)reader);
                    continue block11;
                }
                case MULTICAST_ADDRESS: {
                    AbstractSocketBindingResourceDefinition.MULTICAST_ADDRESS.parseAndSetParameter(value, binding, (XMLStreamReader)reader);
                    continue block11;
                }
                case MULTICAST_PORT: {
                    AbstractSocketBindingResourceDefinition.MULTICAST_PORT.parseAndSetParameter(value, binding, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        block12: while (reader.nextTag() != 2) {
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case CLIENT_MAPPING: {
                    binding.get("client-mappings").add(this.parseClientMapping(reader));
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        updates.add(binding);
        return name;
    }

    private ModelNode parseClientMapping(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode mapping = new ModelNode();
        boolean hasDestinationAddress = false;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case SOURCE_NETWORK: {
                    AbstractSocketBindingResourceDefinition.CLIENT_MAPPING_SOURCE_NETWORK.parseAndSetParameter(value, mapping, (XMLStreamReader)reader);
                    continue block5;
                }
                case DESTINATION_ADDRESS: {
                    AbstractSocketBindingResourceDefinition.CLIENT_MAPPING_DESTINATION_ADDRESS.parseAndSetParameter(value, mapping, (XMLStreamReader)reader);
                    hasDestinationAddress = true;
                    continue block5;
                }
                case DESTINATION_PORT: {
                    AbstractSocketBindingResourceDefinition.CLIENT_MAPPING_DESTINATION_PORT.parseAndSetParameter(value, mapping, (XMLStreamReader)reader);
                }
            }
        }
        if (!hasDestinationAddress) {
            throw ControllerLogger.ROOT_LOGGER.missingRequiredAttributes(new StringBuilder("destination-address"), reader.getLocation());
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return mapping;
    }

    String parseOutboundSocketBinding(XMLExtendedStreamReader reader, Set<String> interfaces, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        String outboundSocketBindingName = null;
        ModelNode outboundSocketBindingAddOperation = new ModelNode();
        outboundSocketBindingAddOperation.get("operation").set("add");
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    outboundSocketBindingName = value;
                    continue block10;
                }
                case SOURCE_INTERFACE: {
                    OutboundSocketBindingResourceDefinition.SOURCE_INTERFACE.parseAndSetParameter(value, outboundSocketBindingAddOperation, (XMLStreamReader)reader);
                    if (interfaces.contains(value) || outboundSocketBindingAddOperation.get(OutboundSocketBindingResourceDefinition.SOURCE_INTERFACE.getName()).getType() == ModelType.EXPRESSION) continue block10;
                    throw ControllerLogger.ROOT_LOGGER.unknownValueForElement(Attribute.SOURCE_INTERFACE.getLocalName(), value, Element.INTERFACE.getLocalName(), Element.INTERFACES.getLocalName(), reader.getLocation());
                }
                case SOURCE_PORT: {
                    OutboundSocketBindingResourceDefinition.SOURCE_PORT.parseAndSetParameter(value, outboundSocketBindingAddOperation, (XMLStreamReader)reader);
                    continue block10;
                }
                case FIXED_SOURCE_PORT: {
                    OutboundSocketBindingResourceDefinition.FIXED_SOURCE_PORT.parseAndSetParameter(value, outboundSocketBindingAddOperation, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        boolean mutuallyExclusiveElementAlreadyFound = false;
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Element.forName((String)reader.getLocalName())) {
                case LOCAL_DESTINATION: {
                    if (mutuallyExclusiveElementAlreadyFound) {
                        throw ControllerLogger.ROOT_LOGGER.invalidOutboundSocketBinding(outboundSocketBindingName, Element.LOCAL_DESTINATION.getLocalName(), Element.REMOTE_DESTINATION.getLocalName(), reader.getLocation());
                    }
                    mutuallyExclusiveElementAlreadyFound = true;
                    this.parseLocalDestinationOutboundSocketBinding(reader, outboundSocketBindingAddOperation);
                    ModelNode addr = address.clone().add("local-destination-outbound-socket-binding", outboundSocketBindingName);
                    outboundSocketBindingAddOperation.get("address").set(addr);
                    continue block11;
                }
                case REMOTE_DESTINATION: {
                    if (mutuallyExclusiveElementAlreadyFound) {
                        throw ControllerLogger.ROOT_LOGGER.invalidOutboundSocketBinding(outboundSocketBindingName, Element.LOCAL_DESTINATION.getLocalName(), Element.REMOTE_DESTINATION.getLocalName(), reader.getLocation());
                    }
                    mutuallyExclusiveElementAlreadyFound = true;
                    this.parseRemoteDestinationOutboundSocketBinding(reader, outboundSocketBindingAddOperation);
                    ModelNode addr = address.clone().add("remote-destination-outbound-socket-binding", outboundSocketBindingName);
                    outboundSocketBindingAddOperation.get("address").set(addr);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        updates.add(outboundSocketBindingAddOperation);
        return outboundSocketBindingName;
    }

    private void parseLocalDestinationOutboundSocketBinding(XMLExtendedStreamReader reader, ModelNode outboundSocketBindingAddOperation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.SOCKET_BINDING_REF);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case SOCKET_BINDING_REF: {
                    LocalDestinationOutboundSocketBindingResourceDefinition.SOCKET_BINDING_REF.parseAndSetParameter(value, outboundSocketBindingAddOperation, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseRemoteDestinationOutboundSocketBinding(XMLExtendedStreamReader reader, ModelNode outboundSocketBindingAddOperation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.HOST, Attribute.PORT);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case HOST: {
                    RemoteDestinationOutboundSocketBindingResourceDefinition.HOST.parseAndSetParameter(value, outboundSocketBindingAddOperation, (XMLStreamReader)reader);
                    continue block4;
                }
                case PORT: {
                    RemoteDestinationOutboundSocketBindingResourceDefinition.PORT.parseAndSetParameter(value, outboundSocketBindingAddOperation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    void writeSocketBindingGroup(XMLExtendedStreamWriter writer, ModelNode bindingGroup, boolean fromServer) throws XMLStreamException {
        ModelNode outboundSocketBinding;
        writer.writeStartElement(Element.SOCKET_BINDING_GROUP.getLocalName());
        SocketBindingGroupResourceDefinition.NAME.marshallAsAttribute(bindingGroup, (XMLStreamWriter)writer);
        SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.marshallAsAttribute(bindingGroup, (XMLStreamWriter)writer);
        if (fromServer) {
            SocketBindingGroupResourceDefinition.PORT_OFFSET.marshallAsAttribute(bindingGroup, (XMLStreamWriter)writer);
        }
        if (!fromServer) {
            SocketBindingGroupResourceDefinition.INCLUDES.marshallAsElement(bindingGroup, (XMLStreamWriter)writer);
        }
        if (bindingGroup.hasDefined("socket-binding")) {
            ModelNode bindings = bindingGroup.get("socket-binding");
            for (String bindingName : bindings.keys()) {
                ModelNode binding = bindings.get(bindingName);
                writer.writeStartElement(Element.SOCKET_BINDING.getLocalName());
                WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)bindingName);
                AbstractSocketBindingResourceDefinition.INTERFACE.marshallAsAttribute(binding, (XMLStreamWriter)writer);
                AbstractSocketBindingResourceDefinition.PORT.marshallAsAttribute(binding, (XMLStreamWriter)writer);
                AbstractSocketBindingResourceDefinition.FIXED_PORT.marshallAsAttribute(binding, (XMLStreamWriter)writer);
                AbstractSocketBindingResourceDefinition.MULTICAST_ADDRESS.marshallAsAttribute(binding, (XMLStreamWriter)writer);
                AbstractSocketBindingResourceDefinition.MULTICAST_PORT.marshallAsAttribute(binding, (XMLStreamWriter)writer);
                ModelNode attr = binding.get("client-mappings");
                if (attr.isDefined()) {
                    for (ModelNode mapping : attr.asList()) {
                        writer.writeEmptyElement(Element.CLIENT_MAPPING.getLocalName());
                        AbstractSocketBindingResourceDefinition.CLIENT_MAPPING_SOURCE_NETWORK.marshallAsAttribute(mapping, (XMLStreamWriter)writer);
                        AbstractSocketBindingResourceDefinition.CLIENT_MAPPING_DESTINATION_ADDRESS.marshallAsAttribute(mapping, (XMLStreamWriter)writer);
                        AbstractSocketBindingResourceDefinition.CLIENT_MAPPING_DESTINATION_PORT.marshallAsAttribute(mapping, (XMLStreamWriter)writer);
                    }
                }
                writer.writeEndElement();
            }
        }
        if (bindingGroup.hasDefined("local-destination-outbound-socket-binding")) {
            ModelNode localDestinationOutboundSocketBindings = bindingGroup.get("local-destination-outbound-socket-binding");
            for (String outboundSocketBindingName : localDestinationOutboundSocketBindings.keys()) {
                outboundSocketBinding = localDestinationOutboundSocketBindings.get(outboundSocketBindingName);
                writer.writeStartElement(Element.OUTBOUND_SOCKET_BINDING.getLocalName());
                WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)outboundSocketBindingName);
                OutboundSocketBindingResourceDefinition.SOURCE_INTERFACE.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                OutboundSocketBindingResourceDefinition.SOURCE_PORT.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                OutboundSocketBindingResourceDefinition.FIXED_SOURCE_PORT.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                writer.writeEmptyElement(Element.LOCAL_DESTINATION.getLocalName());
                LocalDestinationOutboundSocketBindingResourceDefinition.SOCKET_BINDING_REF.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
        if (bindingGroup.hasDefined("remote-destination-outbound-socket-binding")) {
            ModelNode remoteDestinationOutboundSocketBindings = bindingGroup.get("remote-destination-outbound-socket-binding");
            for (String outboundSocketBindingName : remoteDestinationOutboundSocketBindings.keys()) {
                outboundSocketBinding = remoteDestinationOutboundSocketBindings.get(outboundSocketBindingName);
                writer.writeStartElement(Element.OUTBOUND_SOCKET_BINDING.getLocalName());
                WriteUtils.writeAttribute((XMLExtendedStreamWriter)writer, (Attribute)Attribute.NAME, (String)outboundSocketBindingName);
                OutboundSocketBindingResourceDefinition.SOURCE_INTERFACE.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                OutboundSocketBindingResourceDefinition.SOURCE_PORT.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                OutboundSocketBindingResourceDefinition.FIXED_SOURCE_PORT.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                writer.writeEmptyElement(Element.REMOTE_DESTINATION.getLocalName());
                RemoteDestinationOutboundSocketBindingResourceDefinition.HOST.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                RemoteDestinationOutboundSocketBindingResourceDefinition.PORT.marshallAsAttribute(outboundSocketBinding, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }
}

