/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.component.pool.PoolConfig;
import org.jboss.as.ejb3.component.pool.PoolConfigService;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ValueInjectionService;

public class EJB3SubsystemDefaultPoolWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final EJB3SubsystemDefaultPoolWriteHandler MDB_POOL = new EJB3SubsystemDefaultPoolWriteHandler(PoolConfigService.DEFAULT_MDB_POOL_CONFIG_SERVICE_NAME, (AttributeDefinition)EJB3SubsystemRootResourceDefinition.DEFAULT_MDB_INSTANCE_POOL);
    public static final EJB3SubsystemDefaultPoolWriteHandler SLSB_POOL = new EJB3SubsystemDefaultPoolWriteHandler(PoolConfigService.DEFAULT_SLSB_POOL_CONFIG_SERVICE_NAME, (AttributeDefinition)EJB3SubsystemRootResourceDefinition.DEFAULT_SLSB_INSTANCE_POOL);
    public static final EJB3SubsystemDefaultPoolWriteHandler ENTITY_BEAN_POOL = new EJB3SubsystemDefaultPoolWriteHandler(PoolConfigService.DEFAULT_ENTITY_POOL_CONFIG_SERVICE_NAME, (AttributeDefinition)EJB3SubsystemRootResourceDefinition.DEFAULT_ENTITY_BEAN_INSTANCE_POOL);
    private final ServiceName poolConfigServiceName;
    private final AttributeDefinition poolAttribute;

    public EJB3SubsystemDefaultPoolWriteHandler(ServiceName poolConfigServiceName, AttributeDefinition poolAttribute) {
        super(new AttributeDefinition[]{poolAttribute});
        this.poolConfigServiceName = poolConfigServiceName;
        this.poolAttribute = poolAttribute;
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.updatePoolService(context, model);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.updatePoolService(context, restored);
    }

    void updatePoolService(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode poolName = this.poolAttribute.resolveModelAttribute(context, model);
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController existingDefaultPoolConfigService = serviceRegistry.getService(this.poolConfigServiceName);
        if (existingDefaultPoolConfigService != null) {
            context.removeService(existingDefaultPoolConfigService);
        }
        if (poolName.isDefined()) {
            ValueInjectionService newDefaultPoolConfigService = new ValueInjectionService();
            ServiceController serviceController = context.getServiceTarget().addService(this.poolConfigServiceName, (Service)newDefaultPoolConfigService).addDependency(PoolConfigService.EJB_POOL_CONFIG_BASE_SERVICE_NAME.append(new String[]{poolName.asString()}), PoolConfig.class, newDefaultPoolConfigService.getInjector()).install();
        }
    }
}

