/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.validation;

import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.validation.PatchHistoryValidations;
import org.jboss.as.patching.validation.PatchingArtifact;
import org.jboss.as.patching.validation.PatchingArtifactProcessor;
import org.jboss.as.patching.validation.PatchingArtifactStateHandler;
import org.jboss.as.patching.validation.PatchingArtifactValidationContext;
import org.jboss.as.patching.validation.PatchingValidationErrorHandler;

class BasicArtifactProcessor
implements PatchingArtifactProcessor {
    private InstalledIdentity currentIdentity;
    private InstalledIdentity next;
    private final PatchHistoryValidations.PatchingArtifactStateHandlers handlers;
    private final PatchingArtifactValidationContext context;
    private Node current;

    public BasicArtifactProcessor(InstalledIdentity installedIdentity, final PatchingValidationErrorHandler errorHandler, PatchHistoryValidations.PatchingArtifactStateHandlers handlers) {
        assert (installedIdentity != null);
        assert (errorHandler != null);
        assert (handlers != null);
        this.context = new PatchingArtifactValidationContext(){

            @Override
            public PatchingValidationErrorHandler getErrorHandler() {
                if (BasicArtifactProcessor.this.current.context != null) {
                    return BasicArtifactProcessor.this.current.context;
                }
                return errorHandler;
            }

            @Override
            public InstalledIdentity getInstalledIdentity() {
                return BasicArtifactProcessor.this.currentIdentity;
            }

            @Override
            public void setCurrentPatchIdentity(InstalledIdentity currentPatchIdentity) {
                if (currentPatchIdentity == null) {
                    throw new IllegalArgumentException();
                }
                BasicArtifactProcessor.this.next = currentPatchIdentity;
            }
        };
        this.handlers = handlers;
        this.currentIdentity = this.next = installedIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <P extends PatchingArtifact.ArtifactState, S extends PatchingArtifact.ArtifactState> boolean processRoot(PatchingArtifact<P, S> artifact, S state, PatchingValidationErrorHandler context) {
        assert (this.current == null);
        this.current = new Node<P, S>(null, artifact, state, context);
        try {
            boolean bl = this.doProcess(artifact, state);
            return bl;
        }
        finally {
            this.currentIdentity = this.next;
            this.current = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P extends PatchingArtifact.ArtifactState, S extends PatchingArtifact.ArtifactState> boolean process(PatchingArtifact<P, S> artifact, S state) {
        Node old = this.current;
        this.current = new Node<P, S>(old, artifact, state, old.context);
        try {
            boolean bl = this.doProcess(artifact, state);
            return bl;
        }
        finally {
            this.current = old;
        }
    }

    public <P extends PatchingArtifact.ArtifactState, S extends PatchingArtifact.ArtifactState> boolean doProcess(PatchingArtifact<P, S> artifact, S state) {
        PatchingArtifactStateHandler<S> handler = this.getHandlerForArtifact(artifact);
        if (!state.isValid(this.getValidationContext())) {
            return false;
        }
        boolean valid = true;
        for (PatchingArtifact<S, PatchingArtifact.ArtifactState> child : artifact.getArtifacts()) {
            if (child.process(state, this)) continue;
            valid = false;
        }
        if (valid && handler != null) {
            handler.handleValidatedState(state);
        }
        return valid;
    }

    <P extends PatchingArtifact.ArtifactState, S extends PatchingArtifact.ArtifactState> PatchingArtifactStateHandler<S> getHandlerForArtifact(PatchingArtifact<P, S> artifact) {
        return this.handlers.get(artifact);
    }

    @Override
    public <P extends PatchingArtifact.ArtifactState, S extends PatchingArtifact.ArtifactState> S getParentArtifact(PatchingArtifact<P, S> artifact) {
        Node node = this.current;
        while (node != null) {
            if (node.artifact == artifact) {
                return (S)node.state;
            }
            node = node.parent;
        }
        return null;
    }

    @Override
    public PatchingArtifactValidationContext getValidationContext() {
        return this.context;
    }

    static class Node<P extends PatchingArtifact.ArtifactState, S extends PatchingArtifact.ArtifactState> {
        private final S state;
        private final Node parent;
        private final PatchingArtifact<P, S> artifact;
        private final PatchingValidationErrorHandler context;

        Node(Node parent, PatchingArtifact<P, S> artifact, S state, PatchingValidationErrorHandler context) {
            this.state = state;
            this.parent = parent;
            this.artifact = artifact;
            this.context = context;
        }
    }
}

