/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Collection;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.security.auth.AuthenticationConfiguration;
import org.wildfly.security.auth.AuthenticationContext;
import org.wildfly.security.manager.StackInspector;
import org.wildfly.security.permission.ElytronPermission;

public final class AuthenticationContextConfigurationClient {
    private static final ElytronPermission CREATE_PERMISSION = new ElytronPermission("createAuthenticationContextConfigurationClient");
    public static final PrivilegedAction<AuthenticationContextConfigurationClient> ACTION = new PrivilegedAction<AuthenticationContextConfigurationClient>(){

        @Override
        public AuthenticationContextConfigurationClient run() {
            return new AuthenticationContextConfigurationClient();
        }
    };
    static final StackInspector STACK_INSPECTOR = StackInspector.getInstance();

    public AuthenticationContextConfigurationClient() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_PERMISSION);
        }
    }

    public AuthenticationConfiguration getAuthenticationConfiguration(URI uri, AuthenticationContext authenticationContext) {
        int idx = authenticationContext.ruleMatching(uri);
        if (idx == -1) {
            return AuthenticationConfiguration.EMPTY;
        }
        return authenticationContext.getAuthenticationConfiguration(idx);
    }

    public CallbackHandler getCallbackHandler(AuthenticationConfiguration configuration) {
        return configuration.getCallbackHandler();
    }

    public String getRealHost(URI uri, AuthenticationConfiguration configuration) {
        return configuration.getHost(uri);
    }

    public int getRealPort(URI uri, AuthenticationConfiguration configuration) {
        return configuration.getPort(uri);
    }

    public Principal getPrincipal(AuthenticationConfiguration configuration) {
        return configuration.getPrincipal();
    }

    public SaslClient createSaslClient(URI uri, AuthenticationConfiguration configuration, SaslClientFactory clientFactory, Collection<String> offeredMechanisms) throws SaslException {
        return configuration.createSaslClient(uri, clientFactory, offeredMechanisms);
    }

    public InetSocketAddress getDestinationInetSocketAddress(URI uri, AuthenticationConfiguration configuration, int protocolDefaultPort) {
        return configuration.getDestinationInetAddress(uri, protocolDefaultPort);
    }
}

