/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.entity;

public final class Entity {
    public static final String ENTITY_UNILATERAL_RSA_SHA1_ENC = "9798-U-RSA-SHA1-ENC";
    public static final String ENTITY_MUTUAL_RSA_SHA1_ENC = "9798-M-RSA-SHA1-ENC";
    public static final String ENTITY_UNILATERAL_DSA_SHA1 = "9798-U-DSA-SHA1";
    public static final String ENTITY_MUTUAL_DSA_SHA1 = "9798-M-DSA-SHA1";
    public static final String ENTITY_UNILATERAL_ECDSA_SHA1 = "9798-U-ECDSA-SHA1";
    public static final String ENTITY_MUTUAL_ECDSA_SHA1 = "9798-M-ECDSA-SHA1";
    public static final String SHA1_WITH_RSA = "SHA1withRSA";
    public static final String SHA1_WITH_DSA = "SHA1withDSA";
    public static final String SHA1_WITH_ECDSA = "SHA1withECDSA";

    public static String algorithmOid(String signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case "SHA1withRSA": {
                return "1.2.840.113549.1.1.5";
            }
            case "SHA1withDSA": {
                return "1.2.840.10040.4.3";
            }
            case "SHA1withECDSA": {
                return "1.2.840.10045.4.1";
            }
        }
        return null;
    }

    public static String keyType(String signatureAlgorithm) {
        switch (signatureAlgorithm) {
            case "SHA1withRSA": {
                return "RSA";
            }
            case "SHA1withDSA": {
                return "DSA";
            }
            case "SHA1withECDSA": {
                return "EC_EC";
            }
        }
        return null;
    }
}

