/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.wildfly.security.ssl.AbstractDelegatingSSLServerSocketFactory;
import org.wildfly.security.ssl.ConfiguredSSLContextSpi;
import org.wildfly.security.ssl.ConfiguredSSLServerSocket;

final class ConfiguredSSLServerSocketFactory
extends AbstractDelegatingSSLServerSocketFactory {
    private final ConfiguredSSLContextSpi contextSpi;

    ConfiguredSSLServerSocketFactory(SSLServerSocketFactory delegate, ConfiguredSSLContextSpi contextSpi) {
        super(delegate);
        this.contextSpi = contextSpi;
    }

    @Override
    public ServerSocket createServerSocket() throws IOException {
        return this.wrap(super.createServerSocket());
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return this.wrap(super.createServerSocket(port));
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        return this.wrap(super.createServerSocket(port, backlog));
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        return this.wrap(super.createServerSocket(port, backlog, ifAddress));
    }

    private ServerSocket wrap(ServerSocket original) throws IOException {
        return original instanceof SSLServerSocket ? new ConfiguredSSLServerSocket((SSLServerSocket)original, this.contextSpi.getProtocolSelector(), this.contextSpi.getCipherSuiteSelector()) : original;
    }
}

