/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.List;
import javax.sql.DataSource;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.ConnectionPropertiesService;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.DataSourceModelNodeUtil;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.connector.subsystems.datasources.DataSourceStatisticsListener;
import org.jboss.as.connector.subsystems.datasources.ModifiableDataSource;
import org.jboss.as.connector.subsystems.datasources.ModifiableXaDataSource;
import org.jboss.as.connector.subsystems.datasources.XADataSourceConfigService;
import org.jboss.as.connector.subsystems.datasources.XaDataSourcePropertiesService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.ds.DsSecurity;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class DataSourceEnable
implements OperationStepHandler {
    static final DataSourceEnable LOCAL_INSTANCE = new DataSourceEnable(false);
    static final DataSourceEnable XA_INSTANCE = new DataSourceEnable(true);
    private final boolean xa;

    public DataSourceEnable(boolean xa) {
        this.xa = xa;
    }

    public void execute(OperationContext context, ModelNode operation) {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        final ModelNode model = resource.getModel();
        if (!context.isBooting()) {
            model.get("enabled").set(true);
        }
        if (context.isNormalServer()) {
            DataSourceStatisticsListener.registerStatisticsResources(resource);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ManagementResourceRegistration registration = context.getResourceRegistrationForUpdate();
                    DataSourceEnable.addServices(context, operation, registration, model, DataSourceEnable.this.isXa());
                    context.completeStep(new OperationContext.RollbackHandler(){

                        public void handleRollback(OperationContext context, ModelNode operation) {
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }

    static void addServices(OperationContext context, ModelNode operation, ManagementResourceRegistration datasourceRegistration, ModelNode model, boolean isXa) throws OperationFailedException {
        DsSecurity dsSecurityConfig;
        ServiceBuilder builder;
        Object dataSourceConfig;
        ServiceTarget serviceTarget = context.getServiceTarget();
        ModelNode address = operation.require("address");
        String dsName = PathAddress.pathAddress((ModelNode)address).getLastElement().getValue();
        final String jndiName = model.get(Constants.JNDI_NAME.getName()).asString();
        ServiceRegistry registry = context.getServiceRegistry(true);
        List serviceNames = registry.getServiceNames();
        if (isXa) {
            Object securityDomainName;
            Credential credential;
            String securityDomainName2;
            try {
                dataSourceConfig = DataSourceModelNodeUtil.xaFrom(context, model, dsName);
            }
            catch (ValidateException e) {
                throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.failedToCreate("XaDataSource", operation, e.getLocalizedMessage()));
            }
            ServiceName xaDataSourceConfigServiceName = XADataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName});
            XADataSourceConfigService xaDataSourceConfigService = new XADataSourceConfigService((ModifiableXaDataSource)((Object)dataSourceConfig));
            builder = serviceTarget.addService(xaDataSourceConfigServiceName, (Service)xaDataSourceConfigService);
            dsSecurityConfig = dataSourceConfig.getSecurity();
            if (dsSecurityConfig != null && (securityDomainName2 = dsSecurityConfig.getSecurityDomain()) != null) {
                builder.addDependency(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomainName2}));
            }
            if (dataSourceConfig.getRecovery() != null && (credential = dataSourceConfig.getRecovery().getCredential()) != null && (securityDomainName = credential.getSecurityDomain()) != null) {
                builder.addDependency(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomainName}));
            }
            int propertiesCount = 0;
            for (ServiceName name : serviceNames) {
                if (!xaDataSourceConfigServiceName.append(new String[]{"xa-datasource-properties"}).isParentOf(name)) continue;
                ServiceController xaConfigPropertyController = registry.getService(name);
                XaDataSourcePropertiesService xaPropService = (XaDataSourcePropertiesService)xaConfigPropertyController.getService();
                if (!ServiceController.State.UP.equals((Object)xaConfigPropertyController.getState())) {
                    ++propertiesCount;
                    xaConfigPropertyController.setMode(ServiceController.Mode.ACTIVE);
                    builder.addDependency(name, String.class, xaDataSourceConfigService.getXaDataSourcePropertyInjector(xaPropService.getName()));
                    continue;
                }
                throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.serviceAlreadyStarted("Data-source.xa-config-property", name));
            }
            if (propertiesCount == 0) {
                throw ConnectorLogger.ROOT_LOGGER.xaDataSourcePropertiesNotPresent();
            }
            builder.install();
        } else {
            Object securityDomainName;
            try {
                dataSourceConfig = DataSourceModelNodeUtil.from(context, model, dsName);
            }
            catch (ValidateException e) {
                throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.failedToCreate("DataSource", operation, e.getLocalizedMessage()));
            }
            ServiceName dataSourceCongServiceName = DataSourceConfigService.SERVICE_NAME_BASE.append(new String[]{dsName});
            DataSourceConfigService configService = new DataSourceConfigService((ModifiableDataSource)((Object)dataSourceConfig));
            builder = serviceTarget.addService(dataSourceCongServiceName, (Service)configService);
            dsSecurityConfig = dataSourceConfig.getSecurity();
            if (dsSecurityConfig != null && (securityDomainName = dsSecurityConfig.getSecurityDomain()) != null) {
                builder.addDependency(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomainName}));
            }
            for (ServiceName name : serviceNames) {
                if (!dataSourceCongServiceName.append(new String[]{"connection-properties"}).isParentOf(name)) continue;
                ServiceController dataSourceController = registry.getService(name);
                ConnectionPropertiesService connPropService = (ConnectionPropertiesService)dataSourceController.getService();
                if (!ServiceController.State.UP.equals((Object)dataSourceController.getState())) {
                    dataSourceController.setMode(ServiceController.Mode.ACTIVE);
                    builder.addDependency(name, String.class, configService.getConnectionPropertyInjector(connPropService.getName()));
                    continue;
                }
                throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.serviceAlreadyStarted("Data-source.connectionProperty", name));
            }
            builder.install();
        }
        ServiceName dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName});
        ServiceController dataSourceController = registry.getService(dataSourceServiceName);
        if (dataSourceController != null) {
            if (ServiceController.State.UP.equals((Object)dataSourceController.getState())) {
                throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.serviceAlreadyStarted("Data-source", dsName));
            }
        } else {
            throw new OperationFailedException(ConnectorLogger.ROOT_LOGGER.serviceNotAvailable("Data-source", dsName));
        }
        boolean statsEnabled = Constants.STATISTICS_ENABLED.resolveModelAttribute(context, model).asBoolean();
        dataSourceController.addListener((ServiceListener)new DataSourceStatisticsListener(datasourceRegistration, statsEnabled));
        dataSourceController.setMode(ServiceController.Mode.ACTIVE);
        DataSourceReferenceFactoryService referenceFactoryService = new DataSourceReferenceFactoryService();
        ServiceName referenceFactoryServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{dsName});
        ServiceBuilder referenceBuilder = serviceTarget.addService(referenceFactoryServiceName, (Service)referenceFactoryService).addDependency(dataSourceServiceName, DataSource.class, referenceFactoryService.getDataSourceInjector());
        referenceBuilder.install();
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, (Injector)binderService.getManagedObjectInjector()).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case STARTING_to_UP: {
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.boundDataSource(jndiName);
                        break;
                    }
                    case STOPPING_to_DOWN: {
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.unboundDataSource(jndiName);
                        break;
                    }
                    case REMOVING_to_REMOVED: {
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.debugf("Removed JDBC Data-source [%s]", jndiName);
                    }
                }
            }
        });
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        binderBuilder.install();
    }

    public static DataSourceEnable getLocalInstance() {
        return LOCAL_INSTANCE;
    }

    public boolean isXa() {
        return this.xa;
    }
}

