/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl;

import org.jboss.aesh.cl.CommandLineParser;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.cl.Parameter;
import org.jboss.aesh.cl.ParserBuilder;
import org.jboss.aesh.cl.internal.OptionInt;
import org.jboss.aesh.cl.internal.ParameterInt;

public class ParserGenerator {
    public static CommandLineParser generateParser(Class<?> ... clazzes) {
        ParserBuilder builder = new ParserBuilder();
        for (Class<?> clazz : clazzes) {
            Parameter param = clazz.getAnnotation(Parameter.class);
            if (param == null) {
                throw new RuntimeException("Can only create parser from class thats annotated with Parameter");
            }
            builder.addParameter(ParserGenerator.generateParameter(param));
        }
        return builder.generateParser();
    }

    private static ParameterInt generateParameter(Parameter param) {
        if (param.name() == null || param.name().length() < 1) {
            throw new RuntimeException("The parameter name must be defined");
        }
        if (param.options() != null) {
            OptionInt[] options = new OptionInt[param.options().length];
            for (int i = 0; i < param.options().length; ++i) {
                Option o = param.options()[i];
                options[i] = new OptionInt(o.name(), o.longName(), o.description(), o.hasValue(), o.argument(), o.required(), o.valueSeparator(), o.isProperty(), o.hasMultipleValues(), o.type());
            }
            return new ParameterInt(param.name(), param.usage(), param.argumentType(), options);
        }
        return new ParameterInt(param.name(), param.usage(), param.argumentType(), new OptionInt[0]);
    }
}

