/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.terminal;

import java.io.IOException;
import org.jboss.aesh.terminal.Color;
import org.jboss.aesh.terminal.CursorPosition;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.util.ANSI;

public class TerminalHandler {
    private Terminal terminal;
    private CursorPosition position;
    private Color backgroundColor;
    private Color foregroundColor;

    public TerminalHandler(Terminal terminal) {
        this.terminal = terminal;
        this.position = new CursorPosition(0, 0);
        this.backgroundColor = Color.DEFAULT_BG;
        this.foregroundColor = Color.DEFAULT_TEXT;
    }

    public Terminal getTerminal() {
        return this.terminal;
    }

    public void clearScreen() throws IOException {
        this.terminal.writeToStdOut(ANSI.clearScreen());
    }

    public void enableAlternateScreen() throws IOException {
        this.terminal.writeToStdOut(ANSI.getAlternateBufferScreen());
    }

    public void enableMainScreen() throws IOException {
        this.terminal.writeToStdOut(ANSI.getMainBufferScreen());
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public CursorPosition getPosition() {
        return this.position;
    }

    public void setPosition(CursorPosition position) {
        this.position = position;
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }
}

