/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.spi;

import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.spi.CacheGroupServiceNameFactory;
import org.wildfly.clustering.spi.GroupServiceName;
import org.wildfly.clustering.spi.GroupServiceNameFactory;

public enum CacheGroupServiceName implements CacheGroupServiceNameFactory
{
    NODE_FACTORY{

        @Override
        public ServiceName getServiceName(String container, String cache) {
            return GroupServiceName.NODE_FACTORY.getServiceName(container).append(new String[]{cache});
        }
    }
    ,
    GROUP{

        @Override
        public ServiceName getServiceName(String container, String cache) {
            return GroupServiceName.GROUP.getServiceName(container).append(new String[]{cache});
        }
    }
    ,
    REGISTRY{

        @Override
        public ServiceName getServiceName(String container, String cache) {
            return GroupServiceNameFactory.BASE_SERVICE_NAME.append(new String[]{this.toString(), container, cache});
        }

        public String toString() {
            return "registry";
        }
    }
    ,
    REGISTRY_ENTRY{

        @Override
        public ServiceName getServiceName(String container, String cache) {
            return REGISTRY.getServiceName(container, cache).append(new String[]{"entry"});
        }
    }
    ,
    REGISTRY_FACTORY{

        @Override
        public ServiceName getServiceName(String container, String cache) {
            return REGISTRY.getServiceName(container, cache).append(new String[]{"factory"});
        }
    }
    ,
    SERVICE_PROVIDER_REGISTRATION{

        @Override
        public ServiceName getServiceName(String container, String cache) {
            return GroupServiceNameFactory.BASE_SERVICE_NAME.append(new String[]{this.toString(), container, cache});
        }

        public String toString() {
            return "providers";
        }
    }
    ,
    SINGLETON_SERVICE_BUILDER{

        @Override
        public ServiceName getServiceName(String container, String cache) {
            return GroupServiceNameFactory.BASE_SERVICE_NAME.append(new String[]{"singleton", "builder", container, cache});
        }
    };


    @Override
    public ServiceName getServiceName(String group) {
        return this.getServiceName(group, "default");
    }
}

