/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.envers.configuration.spi.AuditConfiguration;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.internal.entities.mapper.relation.lazy.initializor.AbstractCollectionInitializor;
import org.hibernate.envers.internal.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;

public class ListCollectionInitializor
extends AbstractCollectionInitializor<List> {
    private final MiddleComponentData elementComponentData;
    private final MiddleComponentData indexComponentData;

    public ListCollectionInitializor(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, RelationQueryGenerator queryGenerator, Object primaryKey, Number revision, boolean removed, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData) {
        super(verCfg, versionsReader, queryGenerator, primaryKey, revision, removed);
        this.elementComponentData = elementComponentData;
        this.indexComponentData = indexComponentData;
    }

    @Override
    protected List initializeCollection(int size) {
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            list.add(null);
        }
        return list;
    }

    @Override
    protected void addToCollection(List collection, Object collectionRow) {
        Object elementData = collectionRow;
        Object indexData = collectionRow;
        if (collectionRow instanceof List) {
            elementData = ((List)collectionRow).get(this.elementComponentData.getComponentIndex());
            indexData = ((List)collectionRow).get(this.indexComponentData.getComponentIndex());
        }
        Object element = elementData instanceof Map ? this.elementComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)elementData, null, this.revision) : elementData;
        Object indexObj = this.indexComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)indexData, element, this.revision);
        int index = ((Number)indexObj).intValue();
        collection.set(index, element);
    }
}

