/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ReferralException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.negotiation.common.CommonLoginModule;
import org.jboss.security.negotiation.prototype.DecodeAction;
import org.jboss.security.vault.SecurityVaultException;
import org.jboss.security.vault.SecurityVaultUtil;

public class AdvancedLdapLoginModule
extends CommonLoginModule {
    private static final String BIND_AUTHENTICATION = "bindAuthentication";
    private static final String BIND_DN = "bindDN";
    private static final String BIND_CREDENTIAL = "bindCredential";
    private static final String SECURITY_DOMAIN = "jaasSecurityDomain";
    private static final String BASE_CTX_DN = "baseCtxDN";
    private static final String BASE_FILTER = "baseFilter";
    private static final String SEARCH_TIME_LIMIT = "searchTimeLimit";
    private static final String ROLES_CTS_DN = "rolesCtxDN";
    private static final String ROLE_FILTER = "roleFilter";
    private static final String RECURSE_ROLES = "recurseRoles";
    private static final String ROLE_ATTRIBUTE_ID = "roleAttributeID";
    private static final String ROLE_ATTRIBUTE_IS_DN = "roleAttributeIsDN";
    private static final String ROLE_NAME_ATTRIBUTE_ID = "roleNameAttributeID";
    private static final String ROLE_SEARCH_SCOPE = "searchScope";
    private static final String REFERRAL_USER_ATTRIBUTE_ID_TO_CHECK = "referralUserAttributeIDToCheck";
    private static final String ALLOW_EMPTY_PASSWORD = "allowEmptyPassword";
    private static final String AUTH_TYPE_GSSAPI = "GSSAPI";
    private static final String AUTH_TYPE_SIMPLE = "simple";
    private static final String DEFAULT_LDAP_CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String DEFAULT_URL = "ldap://localhost:389";
    private static final String DEFAULT_SSL_URL = "ldap://localhost:686";
    private static final String PROTOCOL_SSL = "SSL";
    private static final String OBJECT_SCOPE = "OBJECT_SCOPE";
    private static final String ONELEVEL_SCOPE = "ONELEVEL_SCOPE";
    private static final String SUBTREE_SCOPE = "SUBTREE_SCOPE";
    private static final String[] ALL_VALID_OPTIONS = new String[]{"bindAuthentication", "bindDN", "bindCredential", "jaasSecurityDomain", "baseCtxDN", "baseFilter", "searchTimeLimit", "rolesCtxDN", "roleFilter", "recurseRoles", "roleAttributeID", "roleAttributeIsDN", "roleNameAttributeID", "searchScope", "allowEmptyPassword", "referralUserAttributeIDToCheck", "java.naming.factory.initial", "java.naming.factory.object", "java.naming.factory.state", "java.naming.factory.url.pkgs", "java.naming.provider.url", "java.naming.dns.url", "java.naming.authoritative", "java.naming.batchsize", "java.naming.referral", "java.naming.security.protocol", "java.naming.security.authentication", "java.naming.security.principal", "java.naming.security.credentials", "java.naming.language", "java.naming.applet"};
    protected String bindAuthentication;
    protected String bindDn;
    protected String bindCredential;
    protected String jaasSecurityDomain;
    protected String baseCtxDN;
    protected String baseFilter;
    protected int searchTimeLimit = 10000;
    protected SearchControls userSearchControls;
    protected String rolesCtxDN;
    protected String roleFilter;
    protected boolean recurseRoles;
    protected SearchControls roleSearchControls;
    protected String roleAttributeID;
    protected boolean roleAttributeIsDN;
    protected String roleNameAttributeID;
    protected String referralUserAttributeIDToCheck = null;
    protected boolean allowEmptyPassword;
    private String referralUserDNToCheck;
    private SimpleGroup userRoles = new SimpleGroup("Roles");
    private Set<String> processedRoleDNs = new HashSet<String>();
    private boolean trace;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        this.addValidOptions(ALL_VALID_OPTIONS);
        super.initialize(subject, handler, sharedState, options);
        this.trace = this.log.isTraceEnabled();
        this.bindAuthentication = (String)options.get(BIND_AUTHENTICATION);
        this.bindDn = (String)options.get(BIND_DN);
        this.bindCredential = (String)options.get(BIND_CREDENTIAL);
        try {
            if (this.bindCredential != null && SecurityVaultUtil.isVaultFormat((String)this.bindCredential)) {
                this.bindCredential = SecurityVaultUtil.getValueAsString((String)this.bindCredential);
            }
        }
        catch (SecurityVaultException e) {
            this.log.warn((Object)"Unable to obtain bindCredentials from Vault: ", (Throwable)e);
        }
        this.jaasSecurityDomain = (String)options.get(SECURITY_DOMAIN);
        this.baseCtxDN = (String)options.get(BASE_CTX_DN);
        this.baseFilter = (String)options.get(BASE_FILTER);
        String temp = (String)options.get(SEARCH_TIME_LIMIT);
        if (temp != null) {
            try {
                this.searchTimeLimit = Integer.parseInt(temp);
            }
            catch (NumberFormatException e) {
                this.log.warn((Object)("Failed to parse: " + temp + ", using searchTimeLimit=" + this.searchTimeLimit));
            }
        }
        this.userSearchControls = new SearchControls();
        this.userSearchControls.setSearchScope(2);
        this.userSearchControls.setReturningAttributes(new String[0]);
        this.userSearchControls.setTimeLimit(this.searchTimeLimit);
        this.rolesCtxDN = (String)options.get(ROLES_CTS_DN);
        this.roleFilter = (String)options.get(ROLE_FILTER);
        this.referralUserAttributeIDToCheck = (String)options.get(REFERRAL_USER_ATTRIBUTE_ID_TO_CHECK);
        temp = (String)options.get(RECURSE_ROLES);
        this.recurseRoles = Boolean.parseBoolean(temp);
        int searchScope = 2;
        temp = (String)options.get(ROLE_SEARCH_SCOPE);
        if (OBJECT_SCOPE.equalsIgnoreCase(temp)) {
            searchScope = 0;
        } else if (ONELEVEL_SCOPE.equalsIgnoreCase(temp)) {
            searchScope = 1;
        }
        if (SUBTREE_SCOPE.equalsIgnoreCase(temp)) {
            searchScope = 2;
        }
        this.roleSearchControls = new SearchControls();
        this.roleSearchControls.setSearchScope(searchScope);
        this.roleSearchControls.setTimeLimit(this.searchTimeLimit);
        this.roleAttributeID = (String)options.get(ROLE_ATTRIBUTE_ID);
        temp = (String)options.get(ROLE_ATTRIBUTE_IS_DN);
        this.roleAttributeIsDN = Boolean.parseBoolean(temp);
        this.roleNameAttributeID = (String)options.get(ROLE_NAME_ATTRIBUTE_ID);
        ArrayList<String> roleSearchAttributeList = new ArrayList<String>(3);
        if (this.roleAttributeID != null) {
            roleSearchAttributeList.add(this.roleAttributeID);
        }
        if (this.roleNameAttributeID != null) {
            roleSearchAttributeList.add(this.roleNameAttributeID);
        }
        if (this.referralUserAttributeIDToCheck != null) {
            roleSearchAttributeList.add(this.referralUserAttributeIDToCheck);
        }
        this.roleSearchControls.setReturningAttributes(roleSearchAttributeList.toArray(new String[0]));
        temp = (String)options.get(ALLOW_EMPTY_PASSWORD);
        this.allowEmptyPassword = Boolean.parseBoolean(temp);
    }

    public boolean login() throws LoginException {
        Object result = null;
        AuthorizeAction action = new AuthorizeAction();
        if (AUTH_TYPE_GSSAPI.equals(this.bindAuthentication)) {
            this.log.trace((Object)"Using GSSAPI to connect to LDAP");
            LoginContext lc = new LoginContext(this.jaasSecurityDomain);
            lc.login();
            Subject serverSubject = lc.getSubject();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Subject = " + serverSubject));
                this.log.debug((Object)("Logged in '" + lc + "' LoginContext"));
            }
            result = Subject.doAs(serverSubject, action);
            lc.logout();
        } else {
            result = action.run();
        }
        if (result instanceof LoginException) {
            throw (LoginException)result;
        }
        return (Boolean)result;
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] roleSets = new Group[]{this.userRoles};
        return roleSets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean innerLogin() throws LoginException {
        this.processIdentityAndCredential();
        if (this.trace) {
            this.log.trace((Object)("Identity - " + this.getIdentity().getName()));
        }
        String bindCredential = this.bindCredential;
        if (!AUTH_TYPE_GSSAPI.equals(this.bindAuthentication) && this.jaasSecurityDomain != null && this.jaasSecurityDomain.length() > 0) {
            try {
                ObjectName serviceName = new ObjectName(this.jaasSecurityDomain);
                char[] tmp = DecodeAction.decode(bindCredential, serviceName);
                bindCredential = new String(tmp);
            }
            catch (Exception e) {
                LoginException le = new LoginException("Unable to decode bindCredential");
                le.initCause(e);
                throw le;
            }
        }
        Context searchContext = null;
        try {
            searchContext = this.constructLdapContext(null, this.bindDn, bindCredential, this.bindAuthentication);
            this.log.debug((Object)"Obtained LdapContext");
            String userDN = this.findUserDN((LdapContext)searchContext);
            if (this.referralUserAttributeIDToCheck != null) {
                this.referralUserDNToCheck = this.isUserDnAbsolute(userDN) != false ? this.localUserDN(userDN) : userDN;
            }
            if (!this.loginOk) {
                this.authenticate(userDN);
            }
            if (this.loginOk) {
                this.rolesSearch((LdapContext)searchContext, userDN);
            }
        }
        finally {
            if (searchContext != null) {
                try {
                    searchContext.close();
                }
                catch (NamingException e) {
                    this.log.warn((Object)"Error closing context", (Throwable)e);
                }
            }
        }
        return this.loginOk;
    }

    private Properties constructLdapContextEnvironment(String namingProviderURL, String principalDN, Object credential, String authentication) {
        Properties env = this.createBaseProperties();
        String factoryName = env.getProperty("java.naming.factory.initial");
        if (factoryName == null) {
            factoryName = DEFAULT_LDAP_CTX_FACTORY;
            env.setProperty("java.naming.factory.initial", factoryName);
        }
        if (authentication != null && authentication.length() > 0) {
            env.setProperty("java.naming.security.authentication", authentication);
        } else {
            String authType = env.getProperty("java.naming.security.authentication");
            if (authType == null) {
                env.setProperty("java.naming.security.authentication", AUTH_TYPE_SIMPLE);
            }
        }
        String providerURL = null;
        providerURL = namingProviderURL != null ? namingProviderURL : (String)this.options.get("java.naming.provider.url");
        String protocol = env.getProperty("java.naming.security.protocol");
        if (providerURL == null) {
            providerURL = PROTOCOL_SSL.equals(protocol) ? DEFAULT_SSL_URL : DEFAULT_URL;
        }
        env.setProperty("java.naming.provider.url", providerURL);
        if (principalDN != null) {
            env.setProperty("java.naming.security.principal", principalDN);
        }
        if (credential != null) {
            env.put("java.naming.security.credentials", credential);
        }
        this.traceLdapEnv(env);
        return env;
    }

    protected LdapContext constructLdapContext(String namingProviderURL, String dn, Object credential, String authentication) throws LoginException {
        try {
            Properties env = this.constructLdapContextEnvironment(namingProviderURL, dn, credential, authentication);
            return new InitialLdapContext(env, null);
        }
        catch (NamingException e) {
            LoginException le = new LoginException("Unable to create new InitialLdapContext");
            le.initCause(e);
            throw le;
        }
    }

    protected Properties createBaseProperties() {
        Properties env = new Properties();
        for (Map.Entry entry : this.options.entrySet()) {
            env.put(entry.getKey(), entry.getValue());
        }
        return env;
    }

    protected String findUserDN(LdapContext ctx) throws LoginException {
        if (this.baseCtxDN == null) {
            return this.getIdentity().getName();
        }
        try {
            NamingEnumeration<SearchResult> results = null;
            Object[] filterArgs = new Object[]{this.getIdentity().getName()};
            LdapContext ldapCtx = ctx;
            boolean referralsLeft = true;
            NameClassPair sr = null;
            while (referralsLeft) {
                try {
                    results = ldapCtx.search(this.baseCtxDN, this.baseFilter, filterArgs, this.userSearchControls);
                    if (results.hasMore()) {
                        sr = results.next();
                    }
                    referralsLeft = false;
                }
                catch (ReferralException e) {
                    ldapCtx = (LdapContext)e.getReferralContext();
                    if (results == null) continue;
                    results.close();
                }
            }
            if (sr == null) {
                results.close();
                throw new LoginException("Search of baseDN(" + this.baseCtxDN + ") found no matches");
            }
            String name = sr.getName();
            String userDN = null;
            userDN = sr.isRelative() ? new CompositeName(name).get(0) + "," + this.baseCtxDN : sr.getName();
            results.close();
            results = null;
            if (this.trace) {
                this.log.trace((Object)("findUserDN - " + userDN));
            }
            return userDN;
        }
        catch (NamingException e) {
            LoginException le = new LoginException("Unable to find user DN");
            le.initCause(e);
            throw le;
        }
    }

    private void referralAuthenticate(String absoluteName, Object credential) throws LoginException {
        URI uri;
        try {
            uri = new URI(absoluteName);
        }
        catch (URISyntaxException e) {
            LoginException le = new LoginException("Unable to find user DN in referral LDAP");
            le.initCause(e);
            throw le;
        }
        String name = this.localUserDN(absoluteName);
        String namingProviderURL = uri.getScheme() + "://" + uri.getAuthority();
        InitialLdapContext refCtx = null;
        try {
            Properties refEnv = this.constructLdapContextEnvironment(namingProviderURL, name, credential, null);
            refCtx = new InitialLdapContext(refEnv, null);
            refCtx.close();
        }
        catch (NamingException e) {
            LoginException le = new LoginException("Unable to create referral LDAP context");
            le.initCause(e);
            throw le;
        }
    }

    private String localUserDN(String absoluteDN) {
        try {
            URI userURI = new URI(absoluteDN);
            return userURI.getPath().substring(1);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private Boolean isUserDnAbsolute(String userDN) {
        try {
            URI userURI = new URI(userDN);
            return userURI.isAbsolute();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    protected void authenticate(String userDN) throws LoginException {
        char[] credential = this.getCredential();
        if (credential.length == 0 && !this.allowEmptyPassword) {
            this.log.trace((Object)"Rejecting empty password.");
            return;
        }
        if (this.isUserDnAbsolute(userDN).booleanValue()) {
            this.referralAuthenticate(userDN, credential);
        } else {
            try {
                LdapContext authContext = this.constructLdapContext(null, userDN, credential, null);
                authContext.close();
            }
            catch (NamingException ne) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Authentication failed - " + ne.getMessage()));
                }
                LoginException le = new LoginException("Authentication failed");
                le.initCause(ne);
                throw le;
            }
        }
        this.loginOk = true;
        if (this.getUseFirstPass()) {
            this.sharedState.put("javax.security.auth.login.name", this.getIdentity().getName());
            this.sharedState.put("javax.security.auth.login.password", credential);
        }
    }

    protected void rolesSearch(LdapContext searchContext, String dn) throws LoginException {
        Object[] filterArgs = null;
        filterArgs = this.isUserDnAbsolute(dn) != false ? new Object[]{this.getIdentity().getName(), this.localUserDN(dn)} : new Object[]{this.getIdentity().getName(), dn};
        NamingEnumeration<SearchResult> results = null;
        try {
            if (this.trace) {
                this.log.trace((Object)("rolesCtxDN=" + this.rolesCtxDN + " roleFilter=" + this.roleFilter + " filterArgs[0]=" + filterArgs[0] + " filterArgs[1]=" + filterArgs[1]));
            }
            if (this.roleFilter != null && this.roleFilter.length() > 0) {
                boolean referralsExist = true;
                while (referralsExist) {
                    try {
                        results = searchContext.search(this.rolesCtxDN, this.roleFilter, filterArgs, this.roleSearchControls);
                        while (results.hasMore()) {
                            SearchResult sr = results.next();
                            String resultDN = null;
                            resultDN = sr.isRelative() ? this.canonicalize(sr.getName()) : sr.getNameInNamespace();
                            this.obtainRole(searchContext, resultDN, sr);
                        }
                        referralsExist = false;
                    }
                    catch (ReferralException e) {
                        searchContext = (LdapContext)e.getReferralContext();
                    }
                }
            } else {
                this.obtainRole(searchContext, this.quoted(dn), null);
            }
        }
        catch (NamingException e) {
            LoginException le = new LoginException("Error finding roles");
            le.initCause(e);
            throw le;
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (NamingException e) {
                    this.log.warn((Object)"Problem closing results", (Throwable)e);
                }
            }
        }
    }

    private String quoted(String dn) {
        String temp = dn.trim();
        if (temp.startsWith("\"") && temp.endsWith("\"")) {
            return temp;
        }
        return "\"" + temp + "\"";
    }

    protected void obtainRole(LdapContext searchContext, String dn, SearchResult sr) throws NamingException, LoginException {
        if (this.trace) {
            this.log.trace((Object)("rolesSearch resultDN = " + dn));
        }
        String[] attrNames = new String[]{this.roleAttributeID};
        Attributes result = null;
        result = sr == null || sr.isRelative() ? searchContext.getAttributes(dn, attrNames) : this.getAttributesFromReferralEntity(sr);
        if (result != null && result.size() > 0) {
            Attribute roles = result.get(this.roleAttributeID);
            for (int n = 0; n < roles.size(); ++n) {
                String roleName = (String)roles.get(n);
                if (this.roleAttributeIsDN) {
                    String roleDN = "\"" + roleName + "\"";
                    this.loadRoleByRoleNameAttributeID(searchContext, roleDN);
                    this.recurseRolesSearch(searchContext, roleName);
                    continue;
                }
                this.addRole(roleName);
            }
        }
    }

    private Attributes getAttributesFromReferralEntity(SearchResult sr) throws NamingException {
        Attributes result = sr.getAttributes();
        boolean chkSuccessful = false;
        if (this.referralUserAttributeIDToCheck != null) {
            Attribute usersToCheck = result.get(this.referralUserAttributeIDToCheck);
            for (int i = 0; usersToCheck != null && i < usersToCheck.size(); ++i) {
                String userDNToCheck = (String)usersToCheck.get(i);
                if (userDNToCheck.equals(this.referralUserDNToCheck)) {
                    chkSuccessful = true;
                    break;
                }
                if (!userDNToCheck.equals(this.getIdentity().getName())) continue;
                chkSuccessful = true;
                break;
            }
        }
        return chkSuccessful ? result : null;
    }

    protected void loadRoleByRoleNameAttributeID(LdapContext searchContext, String roleDN) {
        block5: {
            String[] returnAttribute = new String[]{this.roleNameAttributeID};
            if (this.trace) {
                this.log.trace((Object)("Using roleDN: " + roleDN));
            }
            try {
                Attributes result2 = searchContext.getAttributes(roleDN, returnAttribute);
                Attribute roles2 = result2.get(this.roleNameAttributeID);
                if (roles2 != null) {
                    for (int m = 0; m < roles2.size(); ++m) {
                        String roleName = (String)roles2.get(m);
                        this.addRole(roleName);
                    }
                }
            }
            catch (NamingException e) {
                if (!this.trace) break block5;
                this.log.trace((Object)"Failed to query roleNameAttrName", (Throwable)e);
            }
        }
    }

    protected void recurseRolesSearch(LdapContext searchContext, String roleDN) throws LoginException {
        if (this.recurseRoles) {
            if (!this.processedRoleDNs.contains(roleDN)) {
                this.processedRoleDNs.add(roleDN);
                if (this.trace) {
                    this.log.trace((Object)("Recursive search for '" + roleDN + "'"));
                }
                this.rolesSearch(searchContext, roleDN);
            } else if (this.trace) {
                this.log.trace((Object)("Already visited role '" + roleDN + "' ending recursion."));
            }
        }
    }

    protected void traceLdapEnv(Properties env) {
        if (this.trace) {
            Properties tmp = new Properties();
            tmp.putAll((Map<?, ?>)env);
            String credentials = tmp.getProperty("java.naming.security.credentials");
            String bindCredential = tmp.getProperty(BIND_CREDENTIAL);
            if (credentials != null && credentials.length() > 0) {
                tmp.setProperty("java.naming.security.credentials", "***");
            }
            if (bindCredential != null && bindCredential.length() > 0) {
                tmp.setProperty(BIND_CREDENTIAL, "***");
            }
            this.log.trace((Object)("Logging into LDAP server, env=" + tmp.toString()));
        }
    }

    protected String canonicalize(String searchResult) {
        String result = searchResult;
        int len = searchResult.length();
        result = searchResult.endsWith("\"") ? searchResult.substring(0, len - 1) + "," + this.rolesCtxDN + "\"" : searchResult + "," + this.rolesCtxDN;
        return result;
    }

    private void addRole(String roleName) {
        block4: {
            if (roleName != null) {
                try {
                    Principal p = super.createIdentity(roleName);
                    if (this.trace) {
                        this.log.trace((Object)("Assign user '" + this.getIdentity().getName() + "' to role " + roleName));
                    }
                    this.userRoles.addMember(p);
                }
                catch (Exception e) {
                    if (!this.log.isDebugEnabled()) break block4;
                    this.log.debug((Object)("Failed to create principal: " + roleName), (Throwable)e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AuthorizeAction
    implements PrivilegedAction<Object> {
        private AuthorizeAction() {
        }

        @Override
        public Object run() {
            try {
                return AdvancedLdapLoginModule.this.innerLogin();
            }
            catch (LoginException e) {
                return e;
            }
        }
    }
}

