/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import java.util.List;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;
import org.infinispan.objectfilter.impl.util.StringHelper;

public final class PropertyValueExpr
implements ValueExpr {
    private final List<String> propertyPath;
    private final boolean isRepeated;

    public PropertyValueExpr(List<String> propertyPath, boolean isRepeated) {
        this.propertyPath = propertyPath;
        this.isRepeated = isRepeated;
    }

    public PropertyValueExpr(String propertyPath, boolean isRepeated) {
        this(StringHelper.splitPropertyPath(propertyPath), isRepeated);
    }

    public List<String> getPropertyPath() {
        return this.propertyPath;
    }

    public boolean isRepeated() {
        return this.isRepeated;
    }

    @Override
    public ValueExpr acceptVisitor(Visitor visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyValueExpr other = (PropertyValueExpr)o;
        return this.propertyPath.equals(other.propertyPath);
    }

    public int hashCode() {
        return this.propertyPath.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PROP(");
        boolean isFirst = true;
        for (String p : this.propertyPath) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(',');
            }
            sb.append(p);
        }
        if (this.isRepeated) {
            sb.append('*');
        }
        sb.append(")");
        return sb.toString();
    }
}

