/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.producer.AbstractMemberProducer;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.security.GetMethodAction;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

public abstract class ProducerMethodProducer<X, T>
extends AbstractMemberProducer<X, T> {
    private static final String PRODUCER_ANNOTATION = "@Produces";
    private final MethodInjectionPoint<T, ? super X> method;

    public ProducerMethodProducer(EnhancedAnnotatedMethod<T, ? super X> enhancedAnnotatedMethod, DisposalMethod<?, ?> disposalMethod) {
        super(enhancedAnnotatedMethod, disposalMethod);
        this.method = InjectionPointFactory.instance().createMethodInjectionPoint(enhancedAnnotatedMethod, this.getBean(), enhancedAnnotatedMethod.getDeclaringType().getJavaClass(), null, this.getBeanManager());
        this.checkProducerMethod(enhancedAnnotatedMethod);
        this.checkDelegateInjectionPoints();
    }

    protected void checkProducerMethod(EnhancedAnnotatedMethod<T, ? super X> method) {
        if (method.getEnhancedParameters(Observes.class).size() > 0) {
            throw BeanLogger.LOG.inconsistentAnnotationsOnMethod(PRODUCER_ANNOTATION, "@Observes", this.method);
        }
        if (method.getEnhancedParameters(Disposes.class).size() > 0) {
            throw BeanLogger.LOG.inconsistentAnnotationsOnMethod(PRODUCER_ANNOTATION, "@Disposes", this.method);
        }
        if (this.getDeclaringBean() instanceof SessionBean && !Modifier.isStatic(method.slim().getJavaMember().getModifiers())) {
            boolean methodDeclaredOnTypes = false;
            for (Type type : this.getDeclaringBean().getTypes()) {
                Class clazz = Reflections.getRawType(type);
                try {
                    AccessController.doPrivileged(new GetMethodAction(clazz, method.getName(), method.getParameterTypesAsArray()));
                    methodDeclaredOnTypes = true;
                    break;
                }
                catch (PrivilegedActionException ignored) {
                }
            }
            if (!methodDeclaredOnTypes) {
                throw BeanLogger.LOG.methodNotBusinessMethod(this, this.getDeclaringBean());
            }
        }
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.method.getInjectionPoints();
    }

    @Override
    protected T produce(Object receiver, CreationalContext<T> ctx) {
        return this.method.invoke(receiver, null, this.getBeanManager(), ctx, CreationException.class);
    }

    @Override
    public AnnotatedMember<? super X> getAnnotated() {
        return this.method.getAnnotated();
    }

    @Override
    protected DefinitionException producerWithInvalidTypeVariable(AnnotatedMember<?> member) {
        return BeanLogger.LOG.producerMethodReturnTypeInvalidTypeVariable(member, Formats.formatAsStackTraceElement(member.getJavaMember()));
    }

    @Override
    protected DefinitionException producerWithInvalidWildcard(AnnotatedMember<?> member) {
        return BeanLogger.LOG.producerMethodCannotHaveAWildcardReturnType(member, Formats.formatAsStackTraceElement(member.getJavaMember()));
    }

    @Override
    protected DefinitionException producerWithParameterizedTypeWithTypeVariableBeanTypeMustBeDependent(AnnotatedMember<?> member) {
        return BeanLogger.LOG.producerMethodWithTypeVariableReturnTypeMustBeDependent(member, Formats.formatAsStackTraceElement(member.getJavaMember()));
    }
}

