/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rt.security.saml;

import java.net.URI;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.common.security.SimpleGroup;
import org.apache.cxf.rt.security.claims.Claim;
import org.apache.cxf.rt.security.claims.ClaimCollection;
import org.apache.cxf.rt.security.claims.SAMLClaim;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.xml.XMLObject;
import org.w3c.dom.Element;

public final class SAMLUtils {
    private SAMLUtils() {
    }

    public static ClaimCollection getClaims(SamlAssertionWrapper assertion) {
        ClaimCollection claims = new ClaimCollection();
        if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20)) {
            List statements = assertion.getSaml2().getAttributeStatements();
            for (AttributeStatement as : statements) {
                for (Attribute atr : as.getAttributes()) {
                    SAMLClaim claim = new SAMLClaim();
                    claim.setClaimType(URI.create(atr.getName()));
                    claim.setName(atr.getName());
                    claim.setNameFormat(atr.getNameFormat());
                    claim.setFriendlyName(atr.getFriendlyName());
                    for (XMLObject o : atr.getAttributeValues()) {
                        String attrValue = o.getDOM().getTextContent();
                        claim.getValues().add(attrValue);
                    }
                    claims.add(claim);
                }
            }
        } else {
            List attributeStatements = assertion.getSaml1().getAttributeStatements();
            for (org.opensaml.saml1.core.AttributeStatement statement : attributeStatements) {
                for (org.opensaml.saml1.core.Attribute atr : statement.getAttributes()) {
                    SAMLClaim claim = new SAMLClaim();
                    String claimType = atr.getAttributeName();
                    if (atr.getAttributeNamespace() != null) {
                        claimType = atr.getAttributeNamespace() + "/" + claimType;
                    }
                    claim.setClaimType(URI.create(claimType));
                    claim.setName(atr.getAttributeName());
                    claim.setNameFormat(atr.getAttributeNamespace());
                    for (XMLObject o : atr.getAttributeValues()) {
                        String attrValue = o.getDOM().getTextContent();
                        claim.getValues().add(attrValue);
                    }
                    claims.add(claim);
                }
            }
        }
        return claims;
    }

    public static Set<Principal> parseRolesFromClaims(ClaimCollection claims, String name, String nameFormat) {
        String roleAttributeName = name;
        if (roleAttributeName == null) {
            roleAttributeName = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role";
        }
        HashSet<Principal> roles = new HashSet<Principal>();
        for (Claim claim : claims) {
            if (!(claim instanceof SAMLClaim) || !((SAMLClaim)claim).getName().equals(name) || nameFormat != null && (!(claim instanceof SAMLClaim) || !nameFormat.equals(((SAMLClaim)claim).getNameFormat()))) continue;
            for (Object claimValue : claim.getValues()) {
                if (!(claimValue instanceof String)) continue;
                roles.add((Principal)new SimpleGroup((String)claimValue));
            }
            if (claim.getValues().size() <= 1) continue;
            break;
        }
        return roles;
    }

    public static String getIssuer(Object assertion) {
        return ((SamlAssertionWrapper)assertion).getIssuerString();
    }

    public static Element getAssertionElement(Object assertion) {
        return ((SamlAssertionWrapper)assertion).getElement();
    }
}

