/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.hibernate.impl.EntityInfoLoadKey;
import org.hibernate.search.query.hibernate.impl.ObjectInitializationContext;
import org.hibernate.search.query.hibernate.impl.ObjectInitializer;
import org.hibernate.search.query.hibernate.impl.ObjectLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class SecondLevelCacheObjectInitializer
implements ObjectInitializer {
    private static final Log log = LoggerFactory.make();
    private final ObjectInitializer delegate;

    public SecondLevelCacheObjectInitializer(ObjectInitializer delegate) {
        this.delegate = delegate;
    }

    @Override
    public void initializeObjects(EntityInfo[] entityInfos, LinkedHashMap<EntityInfoLoadKey, Object> idToObjectMap, ObjectInitializationContext objectInitializationContext) {
        boolean traceEnabled = log.isTraceEnabled();
        int maxResults = entityInfos.length;
        if (maxResults == 0) {
            if (traceEnabled) {
                log.tracef("No object to initialize", (Object)maxResults);
            }
            return;
        }
        ArrayList<EntityInfo> remainingEntityInfos = new ArrayList<EntityInfo>(entityInfos.length);
        for (EntityInfo entityInfo : entityInfos) {
            if (ObjectLoaderHelper.areDocIdAndEntityIdIdentical(entityInfo, objectInitializationContext.getSession())) {
                boolean isIn2LCache = objectInitializationContext.getSession().getSessionFactory().getCache().containsEntity(entityInfo.getClazz(), entityInfo.getId());
                if (isIn2LCache) {
                    try {
                        Object o = objectInitializationContext.getSession().get(entityInfo.getClazz(), entityInfo.getId());
                        if (o == null) continue;
                        EntityInfoLoadKey key = new EntityInfoLoadKey(entityInfo.getClazz(), entityInfo.getId());
                        idToObjectMap.put(key, o);
                    }
                    catch (ObjectNotFoundException onfe) {
                        remainingEntityInfos.add(entityInfo);
                    }
                    continue;
                }
                remainingEntityInfos.add(entityInfo);
                continue;
            }
            remainingEntityInfos.add(entityInfo);
        }
        int remainingSize = remainingEntityInfos.size();
        if (traceEnabled) {
            log.tracef("Initialized %d objects out of %d in the second level cache", (Object)(maxResults - remainingSize), (Object)maxResults);
        }
        if (remainingSize > 0) {
            this.delegate.initializeObjects(remainingEntityInfos.toArray(new EntityInfo[remainingSize]), idToObjectMap, objectInitializationContext);
        }
    }
}

