/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.ActivationInterceptor;
import org.infinispan.interceptors.CacheWriterInterceptor;
import org.infinispan.interceptors.InvalidationInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.stats.ClusterCacheStats;
import org.infinispan.stats.Stats;
import org.infinispan.stats.impl.SecurityActions;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="ClusterCacheStats", description="General cluster statistics such as timings, hit/miss ratio, etc.")
public class ClusterCacheStatsImpl
implements ClusterCacheStats,
JmxStatisticsExposer {
    private static final long serialVersionUID = -7692443865184602500L;
    private static final String TIME_SINCE_START = "timeSinceStart";
    private static final String REMOVE_MISSES = "removeMisses";
    private static final String REMOVE_HITS = "removeHits";
    private static final String AVERAGE_WRITE_TIME = "averageWriteTime";
    private static final String AVERAGE_READ_TIME = "averageReadTime";
    private static final String AVERAGE_REMOVE_TIME = "averageRemoveTime";
    private static final String EVICTIONS = "evictions";
    private static final String HITS = "hits";
    private static final String MISSES = "misses";
    private static final String NUMBER_OF_ENTRIES = "numberOfEntries";
    private static final String STORES = "stores";
    private static final String NUMBER_OF_LOCKS_HELD = "numberOfLocksHeld";
    private static final String NUMBER_OF_LOCKS_AVAILABLE = "numberOfLocksAvailable";
    private static final String INVALIDATIONS = "invalidations";
    private static final String PASSIVATIONS = "passivations";
    private static final String ACTIVATIONS = "activations";
    private static final String CACHE_LOADER_LOADS = "cacheLoaderLoads";
    private static final String CACHE_LOADER_MISSES = "cacheLoaderMisses";
    private static final String CACHE_WRITER_STORES = "cacheWriterStores";
    public static final long DEFAULT_STALE_STATS_THRESHOLD = 3000L;
    private static final Log log = LogFactory.getLog(ClusterCacheStatsImpl.class);
    private transient Cache<?, ?> cache;
    private transient DefaultExecutorService des;
    private TimeService ts;
    private boolean statisticsEnabled = false;
    private long staleStatsTreshold = 3000L;
    private long statsUpdateTimestamp = 0L;
    private final AtomicLong resetNanoseconds = new AtomicLong(0L);
    private long stores;
    private long timeSinceStart;
    private long removeMisses;
    private long removeHits;
    private long misses;
    private long hits;
    private long evictions;
    private long numberOfEntries;
    private long averageWriteTime;
    private long averageReadTime;
    private long averageRemoveTime;
    private double readWriteRatio;
    private double hitRatio;
    int numberOfLocksHeld;
    int numberOfLocksAvailable;
    long invalidations;
    long activations;
    long passivations;
    long cacheLoaderLoads;
    long cacheLoaderMisses;
    long cacheWriterStores;

    @Inject
    public void injectDependencies(Cache<?, ?> cache, TimeService ts, Configuration configuration) {
        this.cache = cache;
        this.ts = ts;
        this.statisticsEnabled = configuration.jmxStatistics().enabled();
    }

    @Start
    public void start() {
        this.des = SecurityActions.getDefaultExecutorService(this.cache);
    }

    @Stop
    public void stop() {
        if (this.des != null && !this.des.isShutdown()) {
            this.des.shutdownNow();
        }
    }

    public long getStaleStatsTreshold() {
        return this.staleStatsTreshold;
    }

    @ManagedOperation(description="Sets the treshold for cluster wide stats refresh (miliseconds)", name="setStaleStatsTreshold", displayName="Set the cluster wide stats refresh treshold")
    public void setStaleStatsTreshold(@Parameter(name="staleStatsTreshold", description="Stats refresh treshold in miliseconds") long staleStatsTreshold) {
        this.staleStatsTreshold = staleStatsTreshold;
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        if (this.isStatisticsEnabled()) {
            this.reset();
            this.resetNanoseconds.set(this.ts.time());
        }
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
        if (enabled) {
            this.resetNanoseconds.set(this.ts.time());
        }
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isStatisticsEnabled() {
        return this.getStatisticsEnabled();
    }

    @Override
    @ManagedAttribute(description="Cluster wide total average number of milliseconds for a read operation on the cache", displayName="Cluster wide total average read time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageReadTime() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.averageReadTime;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="Cluster wide total average number of milliseconds for a remove operation in the cache", displayName="Cluster wide total average remove time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageRemoveTime() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.averageRemoveTime;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="Cluster wide average number of milliseconds for a write operation in the cache", displayName="Cluster wide average write time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageWriteTime() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.averageWriteTime;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache eviction operations", displayName="Cluster wide total number of cache evictions", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getEvictions() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.evictions;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache attribute hits", displayName="Cluster wide total number of cache hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getHits() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.hits;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="Cluster wide total percentage hit/(hit+miss) ratio for this cache", displayName="Cluster wide total hit ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getHitRatio() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.hitRatio;
        }
        return -1.0;
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache attribute misses", displayName="Cluster wide total number of cache misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getMisses() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.misses;
        }
        return -1L;
    }

    @ManagedAttribute(description="Cluster wide total number of entries currently in the cache", displayName="Cluster wide total number of current cache entries", displayType=DisplayType.SUMMARY)
    public int getNumberOfEntries() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return (int)this.numberOfEntries;
        }
        return -1;
    }

    @Override
    @ManagedAttribute(description="Cluster wide read/writes ratio for the cache", displayName="Cluster wide read/write ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getReadWriteRatio() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.readWriteRatio;
        }
        return -1.0;
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache removal hits", displayName="Cluster wide total number of cache removal hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveHits() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.removeHits;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache removals where keys were not found", displayName="Cluster wide total number of cache removal misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveMisses() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.removeMisses;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache attribute put operations", displayName="Cluster wide total number of cache puts", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getStores() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.stores;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="Number of seconds since the first cache node started", displayName="Number of seconds since the first cache node started", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getTimeSinceStart() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.timeSinceStart;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="Number of seconds since the cluster-wide cache statistics were last reset", displayName="Seconds since cluster-wide cache statistics were reset", units=Units.SECONDS, displayType=DisplayType.SUMMARY)
    public long getTimeSinceReset() {
        long result = -1L;
        if (this.isStatisticsEnabled()) {
            result = this.ts.timeDuration(this.resetNanoseconds.get(), TimeUnit.SECONDS);
        }
        return result;
    }

    @Override
    public int getCurrentNumberOfEntries() {
        return this.getNumberOfEntries();
    }

    @Override
    public long getTotalNumberOfEntries() {
        return this.getStores();
    }

    @Override
    public long getRetrievals() {
        return this.getHits() + this.getMisses();
    }

    @Override
    public void reset() {
        this.stores = 0L;
        this.timeSinceStart = 0L;
        this.removeMisses = 0L;
        this.removeHits = 0L;
        this.misses = 0L;
        this.hits = 0L;
        this.evictions = 0L;
        this.numberOfEntries = 0L;
        this.averageWriteTime = 0L;
        this.averageReadTime = 0L;
        this.averageRemoveTime = 0L;
        this.readWriteRatio = 0.0;
        this.hitRatio = 0.0;
        this.numberOfLocksHeld = 0;
        this.numberOfLocksAvailable = 0;
        this.invalidations = 0L;
        this.activations = 0L;
        this.passivations = 0L;
        this.cacheLoaderLoads = 0L;
        this.cacheLoaderMisses = 0L;
        this.cacheWriterStores = 0L;
    }

    @Override
    @ManagedAttribute(description="Total number of exclusive locks available in the cluster", displayName="Cluster wide total number of locks", measurementType=MeasurementType.DYNAMIC, displayType=DisplayType.SUMMARY)
    public int getNumberOfLocksAvailable() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.numberOfLocksAvailable;
        }
        return -1;
    }

    @Override
    @ManagedAttribute(description="Total number of locks held in the cluster", displayName="Cluster wide total number of locks held", measurementType=MeasurementType.DYNAMIC, displayType=DisplayType.SUMMARY)
    public int getNumberOfLocksHeld() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.numberOfLocksHeld;
        }
        return -1;
    }

    @Override
    @ManagedAttribute(description="The total number of invalidations in the cluster", displayName="Cluster wide total number of invalidations", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getInvalidations() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.invalidations;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="The total number of activations in the cluster", displayName="Cluster wide total number of activations", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getActivations() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.activations;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="The total number of passivations in the cluster", displayName="Cluster wide total number of passivations", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getPassivations() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.passivations;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="The total number of cacheloader load operations in the cluster", displayName="Cluster wide total number of cacheloader loads", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getCacheLoaderLoads() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.cacheLoaderLoads;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="The total number of cacheloader load misses in the cluster", displayName="Cluster wide total number of cacheloader misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getCacheLoaderMisses() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.cacheLoaderMisses;
        }
        return -1L;
    }

    @Override
    @ManagedAttribute(description="The total number of cachestore store operations in the cluster", displayName="Cluster wide total number of cachestore stores", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getStoreWrites() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.cacheWriterStores;
        }
        return -1L;
    }

    protected boolean launchNewDistTask() {
        long duration = this.ts.timeDuration(this.statsUpdateTimestamp, this.ts.time(), TimeUnit.MILLISECONDS);
        return duration > this.staleStatsTreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void fetchClusterWideStatsIfNeeded() {
        if (this.launchNewDistTask()) {
            List<Future<Map<String, Number>>> responseList = Collections.emptyList();
            try {
                responseList = this.des.submitEverywhere(new DistributedCacheStatsCallable());
                this.updateFieldsFromResponseMap(responseList);
            }
            catch (Exception e) {
                log.warn("Could not execute cluster wide cache stats operation ", e);
            }
            finally {
                this.statsUpdateTimestamp = this.ts.time();
            }
        }
    }

    private void updateFieldsFromResponseMap(List<Future<Map<String, Number>>> responseList) throws Exception {
        this.averageWriteTime = this.addLongAttributes(responseList, AVERAGE_WRITE_TIME) / (long)responseList.size();
        this.averageReadTime = this.addLongAttributes(responseList, AVERAGE_READ_TIME) / (long)responseList.size();
        this.averageRemoveTime = this.addLongAttributes(responseList, AVERAGE_REMOVE_TIME) / (long)responseList.size();
        this.evictions = this.addLongAttributes(responseList, EVICTIONS);
        this.hits = this.addLongAttributes(responseList, HITS);
        this.misses = this.addLongAttributes(responseList, MISSES);
        this.numberOfEntries = this.addLongAttributes(responseList, NUMBER_OF_ENTRIES);
        this.removeHits = this.addLongAttributes(responseList, REMOVE_HITS);
        this.removeMisses = this.addLongAttributes(responseList, REMOVE_MISSES);
        this.stores = this.addLongAttributes(responseList, STORES);
        this.hitRatio = this.updateHitRatio(responseList);
        this.readWriteRatio = this.updateReadWriteRatio(responseList);
        this.timeSinceStart = this.updateTimeSinceStart(responseList);
        this.numberOfLocksHeld = this.addIntAttributes(responseList, NUMBER_OF_LOCKS_HELD);
        this.numberOfLocksAvailable = this.addIntAttributes(responseList, NUMBER_OF_LOCKS_AVAILABLE);
        this.invalidations = this.addLongAttributes(responseList, INVALIDATIONS);
        this.passivations = this.addLongAttributes(responseList, PASSIVATIONS);
        this.activations = this.addLongAttributes(responseList, ACTIVATIONS);
        this.cacheLoaderLoads = this.addLongAttributes(responseList, CACHE_LOADER_LOADS);
        this.cacheLoaderMisses = this.addLongAttributes(responseList, CACHE_LOADER_MISSES);
        this.cacheWriterStores = this.addLongAttributes(responseList, CACHE_WRITER_STORES);
    }

    private long addLongAttributes(List<Future<Map<String, Number>>> responseList, String attribute) throws Exception {
        long total = 0L;
        for (Future<Map<String, Number>> f : responseList) {
            Map<String, Number> m = f.get();
            Number value = m.get(attribute);
            long longValue = value.longValue();
            if (longValue <= -1L) continue;
            total += longValue;
        }
        return total;
    }

    private int addIntAttributes(List<Future<Map<String, Number>>> responseList, String attribute) throws Exception {
        int total = 0;
        for (Future<Map<String, Number>> f : responseList) {
            Map<String, Number> m = f.get();
            Number value = m.get(attribute);
            long intValue = value.intValue();
            if (intValue <= -1L) continue;
            total = (int)((long)total + intValue);
        }
        return total;
    }

    private long updateTimeSinceStart(List<Future<Map<String, Number>>> responseList) throws Exception {
        long timeSinceStartMax = 0L;
        for (Future<Map<String, Number>> f : responseList) {
            Map<String, Number> m = f.get();
            Number timeSinceStart = m.get(TIME_SINCE_START);
            if (timeSinceStart.longValue() <= timeSinceStartMax) continue;
            timeSinceStartMax = timeSinceStart.longValue();
        }
        return timeSinceStartMax;
    }

    private double updateReadWriteRatio(List<Future<Map<String, Number>>> responseList) throws Exception {
        long sumOfAllReads = 0L;
        long sumOfAllWrites = 0L;
        double rwRatio = 0.0;
        for (Future<Map<String, Number>> f : responseList) {
            Map<String, Number> m = f.get();
            Number hits = m.get(HITS);
            Number misses = m.get(MISSES);
            Number stores = m.get(STORES);
            sumOfAllReads += hits.longValue() + misses.longValue();
            sumOfAllWrites += stores.longValue();
        }
        if (sumOfAllWrites > 0L) {
            rwRatio = (double)sumOfAllReads / (double)sumOfAllWrites;
        }
        return rwRatio;
    }

    private double updateHitRatio(List<Future<Map<String, Number>>> responseList) throws Exception {
        long totalHits = 0L;
        long totalRetrievals = 0L;
        double hitRatio = 0.0;
        for (Future<Map<String, Number>> f : responseList) {
            Map<String, Number> m = f.get();
            Number hits = m.get(HITS);
            Number misses = m.get(MISSES);
            totalHits += hits.longValue();
            totalRetrievals += hits.longValue() + misses.longValue();
        }
        if (totalRetrievals > 0L) {
            hitRatio = (double)totalHits / (double)totalRetrievals;
        }
        return hitRatio;
    }

    public static <T extends CommandInterceptor> T getFirstInterceptorWhichExtends(AdvancedCache<?, ?> cache, Class<T> interceptorClass) {
        List<CommandInterceptor> interceptorChain = cache.getInterceptorChain();
        for (CommandInterceptor interceptor : interceptorChain) {
            boolean isSubclass = interceptorClass.isAssignableFrom(interceptor.getClass());
            if (!isSubclass) continue;
            return (T)interceptor;
        }
        return null;
    }

    private static class DistributedCacheStatsCallable
    implements DistributedCallable<Object, Object, Map<String, Number>>,
    Serializable {
        private static final long serialVersionUID = -8400973931071456798L;
        private transient AdvancedCache<Object, Object> remoteCache;

        private DistributedCacheStatsCallable() {
        }

        @Override
        public Map<String, Number> call() throws Exception {
            HashMap<String, Number> map = new HashMap<String, Number>();
            Stats stats = this.remoteCache.getStats();
            map.put(ClusterCacheStatsImpl.AVERAGE_READ_TIME, stats.getAverageReadTime());
            map.put(ClusterCacheStatsImpl.AVERAGE_WRITE_TIME, stats.getAverageWriteTime());
            map.put(ClusterCacheStatsImpl.AVERAGE_REMOVE_TIME, stats.getAverageRemoveTime());
            map.put(ClusterCacheStatsImpl.EVICTIONS, stats.getEvictions());
            map.put(ClusterCacheStatsImpl.HITS, stats.getHits());
            map.put(ClusterCacheStatsImpl.MISSES, stats.getMisses());
            if (this.isDistributed()) {
                map.put(ClusterCacheStatsImpl.NUMBER_OF_ENTRIES, stats.getCurrentNumberOfEntries() / this.numOwners());
            } else {
                map.put(ClusterCacheStatsImpl.NUMBER_OF_ENTRIES, stats.getCurrentNumberOfEntries());
            }
            map.put(ClusterCacheStatsImpl.STORES, stats.getStores());
            map.put(ClusterCacheStatsImpl.REMOVE_HITS, stats.getRemoveHits());
            map.put(ClusterCacheStatsImpl.REMOVE_MISSES, stats.getRemoveMisses());
            map.put(ClusterCacheStatsImpl.TIME_SINCE_START, stats.getTimeSinceStart());
            LockManager lockManager = this.remoteCache.getLockManager();
            map.put(ClusterCacheStatsImpl.NUMBER_OF_LOCKS_HELD, lockManager.getNumberOfLocksHeld());
            map.put(ClusterCacheStatsImpl.NUMBER_OF_LOCKS_AVAILABLE, 0);
            InvalidationInterceptor invalidationInterceptor = ClusterCacheStatsImpl.getFirstInterceptorWhichExtends(this.remoteCache, InvalidationInterceptor.class);
            if (invalidationInterceptor != null) {
                map.put(ClusterCacheStatsImpl.INVALIDATIONS, invalidationInterceptor.getInvalidations());
            } else {
                map.put(ClusterCacheStatsImpl.INVALIDATIONS, 0);
            }
            PassivationManager pManager = this.remoteCache.getComponentRegistry().getComponent(PassivationManager.class);
            if (pManager != null) {
                map.put(ClusterCacheStatsImpl.PASSIVATIONS, pManager.getPassivations());
            } else {
                map.put(ClusterCacheStatsImpl.PASSIVATIONS, 0);
            }
            ActivationManager aManager = this.remoteCache.getComponentRegistry().getComponent(ActivationManager.class);
            if (pManager != null) {
                map.put(ClusterCacheStatsImpl.ACTIVATIONS, aManager.getActivationCount());
            } else {
                map.put(ClusterCacheStatsImpl.ACTIVATIONS, 0);
            }
            ActivationInterceptor aInterceptor = ClusterCacheStatsImpl.getFirstInterceptorWhichExtends(this.remoteCache, ActivationInterceptor.class);
            if (aInterceptor != null) {
                map.put(ClusterCacheStatsImpl.CACHE_LOADER_LOADS, aInterceptor.getCacheLoaderLoads());
                map.put(ClusterCacheStatsImpl.CACHE_LOADER_MISSES, aInterceptor.getCacheLoaderMisses());
            } else {
                map.put(ClusterCacheStatsImpl.CACHE_LOADER_LOADS, 0);
                map.put(ClusterCacheStatsImpl.CACHE_LOADER_MISSES, 0);
            }
            CacheWriterInterceptor interceptor = ClusterCacheStatsImpl.getFirstInterceptorWhichExtends(this.remoteCache, CacheWriterInterceptor.class);
            if (interceptor != null) {
                map.put(ClusterCacheStatsImpl.CACHE_WRITER_STORES, interceptor.getWritesToTheStores());
            } else {
                map.put(ClusterCacheStatsImpl.CACHE_WRITER_STORES, 0);
            }
            return map;
        }

        @Override
        public void setEnvironment(Cache<Object, Object> cache, Set<Object> inputKeys) {
            this.remoteCache = cache.getAdvancedCache();
        }

        private boolean isDistributed() {
            return this.remoteCache.getCacheConfiguration().clustering().cacheMode().isDistributed();
        }

        private int numOwners() {
            return this.remoteCache.getCacheConfiguration().clustering().hash().numOwners();
        }
    }
}

