/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.token.SecurityContextToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.w3c.dom.Document;

public class WSSecSecurityContextToken {
    private SecurityContextToken sct;
    private String sctId;
    private String identifier;
    private byte[] secret;
    private int wscVersion = 2;

    public void prepare(Document doc, Crypto crypto) throws WSSecurityException {
        if (this.sct == null) {
            if (this.identifier != null) {
                this.sct = new SecurityContextToken(this.wscVersion, doc, this.identifier);
            } else {
                this.sct = new SecurityContextToken(this.wscVersion, doc);
                this.identifier = this.sct.getIdentifier();
            }
        }
        if (this.sctId != null) {
            this.sct.setID(this.sctId);
        }
    }

    public void prependSCTElementToHeader(Document doc, WSSecHeader secHeader) throws WSSecurityException {
        WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.sct.getElement());
    }

    public SecurityContextToken getSct() {
        return this.sct;
    }

    public void setSct(SecurityContextToken sct) {
        this.sct = sct;
    }

    public byte[] getSecret() {
        return this.secret;
    }

    protected void setSecret(byte[] ephemeralKey) {
        this.secret = ephemeralKey;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getSctId() {
        if (this.sct != null) {
            return this.sct.getID();
        }
        return this.sctId;
    }

    public void setSctId(String sctId) {
        this.sctId = sctId;
    }

    public void setWscVersion(int wscVersion) {
        this.wscVersion = wscVersion;
    }
}

