/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message.token;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.wss4j.common.util.DateUtil;
import org.apache.wss4j.common.util.WSCurrentTimeSource;
import org.apache.wss4j.common.util.WSTimeSource;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.bsp.BSPEnforcer;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.dom.util.XmlSchemaDateFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Timestamp {
    private Element element;
    private List<Element> customElements;
    private Date createdDate;
    private Date expiresDate;

    public Timestamp(Element timestampElement, BSPEnforcer bspEnforcer) throws WSSecurityException {
        this.element = timestampElement;
        this.customElements = new ArrayList<Element>();
        String strCreated = null;
        String strExpires = null;
        for (Node currentChild = this.element.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            String valueType;
            if (1 != currentChild.getNodeType()) continue;
            Element currentChildElement = (Element)currentChild;
            if ("Created".equals(currentChild.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(currentChild.getNamespaceURI())) {
                if (strCreated == null) {
                    valueType = currentChildElement.getAttributeNS(null, "ValueType");
                    if (valueType != null && !"".equals(valueType)) {
                        bspEnforcer.handleBSPRule(BSPRule.R3225);
                    }
                    strCreated = ((Text)currentChildElement.getFirstChild()).getData();
                    continue;
                }
                bspEnforcer.handleBSPRule(BSPRule.R3203);
                continue;
            }
            if ("Expires".equals(currentChild.getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(currentChild.getNamespaceURI())) {
                if (strCreated == null) {
                    bspEnforcer.handleBSPRule(BSPRule.R3221);
                }
                if (strExpires != null) {
                    bspEnforcer.handleBSPRule(BSPRule.R3224);
                    continue;
                }
                valueType = currentChildElement.getAttributeNS(null, "ValueType");
                if (valueType != null && !"".equals(valueType)) {
                    bspEnforcer.handleBSPRule(BSPRule.R3226);
                }
                strExpires = ((Text)currentChildElement.getFirstChild()).getData();
                continue;
            }
            bspEnforcer.handleBSPRule(BSPRule.R3222);
            this.customElements.add(currentChildElement);
        }
        if (strCreated == null) {
            bspEnforcer.handleBSPRule(BSPRule.R3203);
        }
        if (strCreated != null) {
            XMLGregorianCalendar createdCalendar = null;
            try {
                createdCalendar = WSSConfig.datatypeFactory.newXMLGregorianCalendar(strCreated);
            }
            catch (IllegalArgumentException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, (Exception)e);
            }
            if (createdCalendar.getFractionalSecond() != null && createdCalendar.getFractionalSecond().scale() > 3) {
                bspEnforcer.handleBSPRule(BSPRule.R3220);
            }
            if (createdCalendar.getSecond() > 59) {
                bspEnforcer.handleBSPRule(BSPRule.R3213);
            }
            if (createdCalendar.getTimezone() == Integer.MIN_VALUE) {
                bspEnforcer.handleBSPRule(BSPRule.R3217);
            }
            this.createdDate = createdCalendar.toGregorianCalendar().getTime();
        }
        if (strExpires != null) {
            XMLGregorianCalendar expiresCalendar = null;
            try {
                expiresCalendar = WSSConfig.datatypeFactory.newXMLGregorianCalendar(strExpires);
            }
            catch (IllegalArgumentException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY, (Exception)e);
            }
            if (expiresCalendar.getFractionalSecond() != null && expiresCalendar.getFractionalSecond().scale() > 3) {
                bspEnforcer.handleBSPRule(BSPRule.R3229);
            }
            if (expiresCalendar.getSecond() > 59) {
                bspEnforcer.handleBSPRule(BSPRule.R3215);
            }
            if (expiresCalendar.getTimezone() == Integer.MIN_VALUE) {
                bspEnforcer.handleBSPRule(BSPRule.R3223);
            }
            this.expiresDate = expiresCalendar.toGregorianCalendar().getTime();
        }
    }

    public Timestamp(boolean milliseconds, Document doc, int ttl) {
        this(milliseconds, doc, (WSTimeSource)new WSCurrentTimeSource(), ttl);
    }

    public Timestamp(boolean milliseconds, Document doc, WSTimeSource timeSource, int ttl) {
        this.customElements = new ArrayList<Element>();
        this.element = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        DateFormat zulu = null;
        if (milliseconds) {
            zulu = new XmlSchemaDateFormat();
        } else {
            zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
            zulu.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        this.createdDate = timeSource.now();
        elementCreated.appendChild(doc.createTextNode(zulu.format(this.createdDate)));
        this.element.appendChild(elementCreated);
        if (ttl != 0) {
            this.expiresDate = timeSource.now();
            this.expiresDate.setTime(this.createdDate.getTime() + (long)ttl * 1000L);
            Element elementExpires = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
            elementExpires.appendChild(doc.createTextNode(zulu.format(this.expiresDate)));
            this.element.appendChild(elementExpires);
        }
    }

    public void addWSUNamespace() {
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return DOM2Writer.nodeToString((Node)this.element);
    }

    public Date getCreated() {
        return this.createdDate;
    }

    public Date getExpires() {
        return this.expiresDate;
    }

    public void addCustomElement(Document doc, Element customElement) {
        this.customElements.add(customElement);
        this.element.appendChild(customElement);
    }

    public List<Element> getCustomElements() {
        return this.customElements;
    }

    public void setID(String id) {
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
    }

    public String getID() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public boolean isExpired() {
        if (this.expiresDate != null) {
            Date rightNow = new Date();
            return this.expiresDate.before(rightNow);
        }
        return false;
    }

    public boolean verifyCreated(int timeToLive, int futureTimeToLive) {
        return DateUtil.verifyCreated((Date)this.createdDate, (int)timeToLive, (int)futureTimeToLive);
    }

    public int hashCode() {
        int result = 17;
        if (this.createdDate != null) {
            result = 31 * result + this.createdDate.hashCode();
        }
        if (this.expiresDate != null) {
            result = 31 * result + this.expiresDate.hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Timestamp)) {
            return false;
        }
        Timestamp timestamp = (Timestamp)object;
        if (!this.compare(timestamp.getCreated(), this.getCreated())) {
            return false;
        }
        return this.compare(timestamp.getExpires(), this.getExpires());
    }

    private boolean compare(Date item1, Date item2) {
        if (item1 == null && item2 != null) {
            return false;
        }
        return item1 == null || item1.equals(item2);
    }
}

