/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.DefaultAccessLogReceiver;
import io.undertow.server.handlers.accesslog.JBossLoggingAccessLogReceiver;
import java.io.File;
import java.util.concurrent.Executor;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.xnio.XnioWorker;

class AccessLogService
implements Service<AccessLogService> {
    private final InjectedValue<Host> host = new InjectedValue();
    protected final InjectedValue<XnioWorker> worker = new InjectedValue();
    private final String pattern;
    private final String path;
    private final String pathRelativeTo;
    private final String filePrefix;
    private final String fileSuffix;
    private final boolean useServerLog;
    private volatile AccessLogReceiver logReceiver;
    private PathManager.Callback.Handle callbackHandle;
    private File directory;
    private final InjectedValue<PathManager> pathManager = new InjectedValue();

    AccessLogService(String pattern) {
        this.pattern = pattern;
        this.path = null;
        this.pathRelativeTo = null;
        this.filePrefix = null;
        this.fileSuffix = null;
        this.useServerLog = true;
    }

    AccessLogService(String pattern, String path, String pathRelativeTo, String filePrefix, String fileSuffix) {
        this.pattern = pattern;
        this.path = path;
        this.pathRelativeTo = pathRelativeTo;
        this.filePrefix = filePrefix;
        this.fileSuffix = fileSuffix;
        this.useServerLog = false;
    }

    public void start(StartContext context) throws StartException {
        if (this.useServerLog) {
            this.logReceiver = new JBossLoggingAccessLogReceiver();
        } else {
            if (this.pathRelativeTo != null) {
                this.callbackHandle = ((PathManager)this.pathManager.getValue()).registerCallback(this.pathRelativeTo, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
            }
            this.directory = new File(((PathManager)this.pathManager.getValue()).resolveRelativePathEntry(this.path, this.pathRelativeTo));
            if (!this.directory.exists() && !this.directory.mkdirs()) {
                throw UndertowLogger.ROOT_LOGGER.couldNotCreateLogDirectory(this.directory);
            }
            try {
                this.logReceiver = new DefaultAccessLogReceiver((Executor)this.worker.getValue(), this.directory, this.filePrefix, this.fileSuffix);
            }
            catch (IllegalStateException e) {
                throw new StartException((Throwable)e);
            }
        }
        ((Host)this.host.getValue()).setAccessLogService(this);
    }

    public void stop(StopContext context) {
        ((Host)this.host.getValue()).setAccessLogService(null);
        if (this.callbackHandle != null) {
            this.callbackHandle.remove();
            this.callbackHandle = null;
        }
    }

    public AccessLogService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    InjectedValue<XnioWorker> getWorker() {
        return this.worker;
    }

    InjectedValue<PathManager> getPathManager() {
        return this.pathManager;
    }

    protected AccessLogHandler configureAccessLogHandler(HttpHandler handler) {
        return new AccessLogHandler(handler, this.logReceiver, this.pattern, AccessLogService.class.getClassLoader());
    }

    public InjectedValue<Host> getHost() {
        return this.host;
    }
}

