/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PeerNameResolvingHandler;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.io.IOServices;
import org.wildfly.extension.io.OptionList;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.ListenerService;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.UndertowService;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.XnioWorker;

abstract class ListenerAdd
extends AbstractAddStepHandler {
    ListenerAdd(ListenerResourceDefinition definition) {
        super(definition.getAttributes());
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress parent = address.subAddress(0, address.size() - 1);
        String name = address.getLastElement().getValue();
        String bindingRef = ListenerResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, model).asString();
        String workerName = ListenerResourceDefinition.WORKER.resolveModelAttribute(context, model).asString();
        String bufferPoolName = ListenerResourceDefinition.BUFFER_POOL.resolveModelAttribute(context, model).asString();
        boolean enabled = ListenerResourceDefinition.ENABLED.resolveModelAttribute(context, model).asBoolean();
        boolean peerHostLookup = ListenerResourceDefinition.RESOLVE_PEER_ADDRESS.resolveModelAttribute(context, model).asBoolean();
        OptionMap listenerOptions = OptionList.resolveOptions((ExpressionResolver)context, (ModelNode)model, ListenerResourceDefinition.LISTENER_OPTIONS);
        OptionMap socketOptions = OptionList.resolveOptions((ExpressionResolver)context, (ModelNode)model, ListenerResourceDefinition.SOCKET_OPTIONS);
        String serverName = parent.getLastElement().getValue();
        ServiceName listenerServiceName = UndertowService.listenerName(name);
        ListenerService<? extends ListenerService> service = this.createService(name, serverName, context, model, listenerOptions, socketOptions);
        if (peerHostLookup) {
            service.addWrapperHandler(new HandlerWrapper(){

                public HttpHandler wrap(HttpHandler handler) {
                    return new PeerNameResolvingHandler(handler);
                }
            });
        }
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(listenerServiceName, service);
        serviceBuilder.addDependency(IOServices.WORKER.append(new String[]{workerName}), XnioWorker.class, service.getWorker()).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingRef}), SocketBinding.class, service.getBinding()).addDependency(IOServices.BUFFER_POOL.append(new String[]{bufferPoolName}), Pool.class, service.getBufferPool()).addDependency(UndertowService.SERVER.append(new String[]{serverName}), Server.class, service.getServerService());
        this.configureAdditionalDependencies(context, (ServiceBuilder<? extends ListenerService>)serviceBuilder, model, service);
        serviceBuilder.setInitialMode(enabled ? ServiceController.Mode.ACTIVE : ServiceController.Mode.NEVER).install();
    }

    abstract ListenerService<? extends ListenerService> createService(String var1, String var2, OperationContext var3, ModelNode var4, OptionMap var5, OptionMap var6) throws OperationFailedException;

    abstract void configureAdditionalDependencies(OperationContext var1, ServiceBuilder<? extends ListenerService> var2, ModelNode var3, ListenerService var4) throws OperationFailedException;
}

