/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

@Immutable
public class PutAllOperation
extends RetryOnFailureOperation<Void> {
    protected final Map<byte[], byte[]> map;
    protected final int lifespan;
    protected final int maxIdle;

    public PutAllOperation(Codec codec, TransportFactory transportFactory, Map<byte[], byte[]> map, byte[] cacheName, AtomicInteger topologyId, Flag[] flags, int lifespan, int maxIdle) {
        super(codec, transportFactory, cacheName, topologyId, flags);
        this.map = map;
        this.lifespan = lifespan;
        this.maxIdle = maxIdle;
    }

    @Override
    protected Void executeOperation(Transport transport) {
        HeaderParams params = this.writeHeader(transport, (short)45);
        transport.writeVInt(this.lifespan);
        transport.writeVInt(this.maxIdle);
        transport.writeVInt(this.map.size());
        for (Map.Entry<byte[], byte[]> entry : this.map.entrySet()) {
            transport.writeArray(entry.getKey());
            transport.writeArray(entry.getValue());
        }
        transport.flush();
        short status = this.readHeaderAndValidate(transport, params);
        if (status != 0) {
            throw new InvalidResponseException("Unexpected response status: " + Integer.toHexString(status));
        }
        return null;
    }

    @Override
    protected Transport getTransport(int retryCount, Set<SocketAddress> failedServers) {
        return this.transportFactory.getTransport(failedServers, this.cacheName);
    }
}

