/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security;

import java.security.GeneralSecurityException;
import org.wildfly.security.SecurityFactory;

public final class OneTimeSecurityFactory<T>
implements SecurityFactory<T> {
    private volatile SecurityFactory<T> factory;
    private volatile T obj;

    public OneTimeSecurityFactory(SecurityFactory<T> factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T create() throws GeneralSecurityException {
        T val = this.obj;
        if (val == null) {
            if (Thread.holdsLock(this)) {
                throw new IllegalStateException("Cannot instantiate self-referential factory");
            }
            OneTimeSecurityFactory oneTimeSecurityFactory = this;
            synchronized (oneTimeSecurityFactory) {
                val = this.obj;
                if (val == null) {
                    val = this.obj = this.factory.create();
                    this.factory = null;
                }
            }
        }
        return val;
    }
}

