/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.util.Collection;
import java.util.Set;
import org.wildfly.security.auth.AuthenticationConfiguration;

class FilterSaslMechanismAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final boolean allow;
    private final Set<String> names;

    FilterSaslMechanismAuthenticationConfiguration(AuthenticationConfiguration parent, boolean allow, Set<String> names) {
        super(parent, true);
        this.allow = allow;
        this.names = names;
    }

    @Override
    void filterSaslMechanisms(Collection<String> names) {
        if (this.allow) {
            names.retainAll(this.names);
        } else {
            names.removeAll(this.names);
        }
        super.filterSaslMechanisms(names);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new FilterSaslMechanismAuthenticationConfiguration(newParent, this.allow, this.names);
    }
}

