/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.provider.ldap;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.wildfly.security.auth.provider.ldap.CredentialLoader;
import org.wildfly.security.auth.provider.ldap.DirContextFactory;
import org.wildfly.security.auth.provider.ldap.IdentityCredentialLoader;
import org.wildfly.security.auth.provider.ldap.UserPasswordPasswordUtil;
import org.wildfly.security.auth.spi.CredentialSupport;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.BSDUnixDESCryptPasswordSpec;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.PasswordSpec;
import org.wildfly.security.password.spec.SaltedSimpleDigestPasswordSpec;
import org.wildfly.security.password.spec.SimpleDigestPasswordSpec;
import org.wildfly.security.password.spec.UnixDESCryptPasswordSpec;

class UserPasswordCredentialLoader
implements CredentialLoader {
    static final String DEFAULT_USER_PASSWORD_ATTRIBUTE_NAME = "userPassword";
    private final String userPasswordAttributeName;
    private final Map<Class<?>, CredentialSupport> credentialSupportMap;

    public UserPasswordCredentialLoader(String userPasswordAttributeName, Map<Class<?>, CredentialSupport> credentialSupportMap) {
        this.userPasswordAttributeName = userPasswordAttributeName;
        this.credentialSupportMap = credentialSupportMap;
    }

    @Override
    public CredentialSupport getCredentialSupport(DirContextFactory contextFactory, Class<?> credentialType) {
        if (this.credentialSupportMap.isEmpty()) {
            return CredentialSupport.UNKNOWN;
        }
        CredentialSupport response = this.credentialSupportMap.get(credentialType);
        if (response == null) {
            response = CredentialSupport.UNSUPPORTED;
        }
        return response;
    }

    @Override
    public IdentityCredentialLoader forIdentity(DirContextFactory contextFactory, String distinguishedName) {
        return new ForIdentityLoader(contextFactory, distinguishedName);
    }

    private class ForIdentityLoader
    implements IdentityCredentialLoader {
        private final DirContextFactory contextFactory;
        private final String distinguishedName;

        public ForIdentityLoader(DirContextFactory contextFactory, String distinguishedName) {
            this.contextFactory = contextFactory;
            this.distinguishedName = distinguishedName;
        }

        @Override
        public CredentialSupport getCredentialSupport(Class<?> credentialType) {
            Object credential = this.getCredential(credentialType);
            if (credential != null && credentialType.isInstance(credential)) {
                return CredentialSupport.FULLY_SUPPORTED;
            }
            return CredentialSupport.UNSUPPORTED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <C> C getCredential(Class<C> credentialType) {
            DirContext context = null;
            try {
                context = this.contextFactory.obtainDirContext(null);
                Attributes attributes = context.getAttributes(this.distinguishedName, new String[]{UserPasswordCredentialLoader.this.userPasswordAttributeName});
                Attribute attribute = attributes.get(UserPasswordCredentialLoader.this.userPasswordAttributeName);
                for (int i = 0; i < attribute.size(); ++i) {
                    byte[] value = (byte[])attribute.get(i);
                    PasswordSpec spec = UserPasswordPasswordUtil.parseUserPassword(value);
                    PasswordFactory pf = PasswordFactory.getInstance(this.toAlgorithm(spec));
                    Password password = pf.generatePassword(spec);
                    if (credentialType.isInstance(password)) {
                        C c = credentialType.cast(password);
                        return c;
                    }
                    System.out.println(new String(value, UserPasswordPasswordUtil.UTF_8));
                }
                C c = null;
                return c;
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException | NamingException e) {
                C c = null;
                return c;
            }
            finally {
                this.contextFactory.returnContext(context);
            }
        }

        private String toAlgorithm(PasswordSpec passwordSpec) {
            if (passwordSpec instanceof ClearPasswordSpec) {
                return "clear";
            }
            if (passwordSpec instanceof SimpleDigestPasswordSpec) {
                return ((SimpleDigestPasswordSpec)passwordSpec).getAlgorithm();
            }
            if (passwordSpec instanceof SaltedSimpleDigestPasswordSpec) {
                return ((SaltedSimpleDigestPasswordSpec)passwordSpec).getAlgorithm();
            }
            if (passwordSpec instanceof BSDUnixDESCryptPasswordSpec) {
                return "bsd-crypt-des";
            }
            if (passwordSpec instanceof UnixDESCryptPasswordSpec) {
                return "crypt-des";
            }
            return null;
        }
    }
}

