/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.proxy;

import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wildfly.security._private.ElytronMessages;

public final class SaslProxy {
    private static final int ST_FAILED = 0;
    private static final int ST_WAIT_FOR_CHALLENGE = 1;
    private static final int ST_WAIT_FOR_RESPONSE = 2;
    private static final int ST_DONE = 3;
    private static final byte[] EMPTY = new byte[0];
    private final Client client = new Client();
    private final Server server = new Server();
    private final String mechanismName;
    private final boolean responseFirst;
    private final Object lock = new Object();
    private int state;
    private byte[] message = EMPTY;
    private String authorizationID;

    public SaslProxy(String mechanismName, boolean responseFirst) {
        this.mechanismName = mechanismName;
        this.responseFirst = responseFirst;
        this.state = responseFirst ? 2 : 1;
    }

    public SaslClient getClient() {
        return this.client;
    }

    public SaslServer getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upstreamServerComplete(String authorizationID) {
        Object object = this.lock;
        synchronized (object) {
            if (this.state == 3) {
                throw new IllegalStateException();
            }
            this.state = 3;
            this.authorizationID = authorizationID;
            this.notifyAll();
        }
    }

    static /* synthetic */ byte[] access$402(SaslProxy x0, byte[] x1) {
        x0.message = x1;
        return x1;
    }

    final class Server
    implements SaslServer {
        Server() {
        }

        @Override
        public String getMechanismName() {
            return SaslProxy.this.mechanismName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public byte[] evaluateResponse(byte[] response) throws SaslException {
            Object object = SaslProxy.this.lock;
            synchronized (object) {
                block13: while (true) {
                    switch (SaslProxy.this.state) {
                        case 0: {
                            throw ElytronMessages.log.saslProxyAuthenticationFailed();
                        }
                        case 3: {
                            return null;
                        }
                        case 1: {
                            try {
                                SaslProxy.this.lock.wait();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                SaslProxy.this.state = 0;
                                throw ElytronMessages.log.saslProxyAuthenticationFailed();
                            }
                        }
                        continue block13;
                        case 2: {
                            try {
                                byte[] byArray = SaslProxy.this.message;
                                return byArray;
                            }
                            finally {
                                SaslProxy.this.state = 1;
                                SaslProxy.access$402(SaslProxy.this, response);
                                SaslProxy.this.lock.notifyAll();
                            }
                        }
                    }
                    break;
                }
                throw new IllegalStateException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isComplete() {
            Object object = SaslProxy.this.lock;
            synchronized (object) {
                return SaslProxy.this.state == 3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getAuthorizationID() {
            Object object = SaslProxy.this.lock;
            synchronized (object) {
                if (SaslProxy.this.state == 3) {
                    return SaslProxy.this.authorizationID;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
            throw new IllegalStateException("Wrap/unwrap is unsupported");
        }

        @Override
        public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
            throw new IllegalStateException("Wrap/unwrap is unsupported");
        }

        @Override
        public Object getNegotiatedProperty(String propName) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() throws SaslException {
            Object object = SaslProxy.this.lock;
            synchronized (object) {
                switch (SaslProxy.this.state) {
                    case 0: 
                    case 3: {
                        return;
                    }
                    case 1: 
                    case 2: {
                        SaslProxy.this.state = 0;
                        SaslProxy.access$402(SaslProxy.this, null);
                        SaslProxy.this.lock.notifyAll();
                        return;
                    }
                }
            }
        }
    }

    final class Client
    implements SaslClient {
        Client() {
        }

        @Override
        public String getMechanismName() {
            return SaslProxy.this.mechanismName;
        }

        @Override
        public boolean hasInitialResponse() {
            return SaslProxy.this.responseFirst;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
            Object object = SaslProxy.this.lock;
            synchronized (object) {
                block13: while (true) {
                    switch (SaslProxy.this.state) {
                        case 0: {
                            throw ElytronMessages.log.saslProxyAuthenticationFailed();
                        }
                        case 3: {
                            return null;
                        }
                        case 2: {
                            try {
                                SaslProxy.this.lock.wait();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                SaslProxy.this.state = 0;
                                throw ElytronMessages.log.saslProxyAuthenticationFailed();
                            }
                        }
                        continue block13;
                        case 1: {
                            try {
                                byte[] byArray = SaslProxy.this.message;
                                return byArray;
                            }
                            finally {
                                SaslProxy.this.state = 2;
                                SaslProxy.access$402(SaslProxy.this, challenge);
                                SaslProxy.this.lock.notifyAll();
                            }
                        }
                    }
                    break;
                }
                throw new IllegalStateException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isComplete() {
            Object object = SaslProxy.this.lock;
            synchronized (object) {
                return SaslProxy.this.state == 3;
            }
        }

        @Override
        public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
            throw new IllegalStateException("Wrap/unwrap is unsupported");
        }

        @Override
        public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
            throw new IllegalStateException("Wrap/unwrap is unsupported");
        }

        @Override
        public Object getNegotiatedProperty(String propName) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispose() throws SaslException {
            Object object = SaslProxy.this.lock;
            synchronized (object) {
                switch (SaslProxy.this.state) {
                    case 0: 
                    case 3: {
                        return;
                    }
                    case 1: 
                    case 2: {
                        SaslProxy.this.state = 0;
                        SaslProxy.access$402(SaslProxy.this, null);
                        SaslProxy.this.lock.notifyAll();
                        return;
                    }
                }
            }
        }
    }
}

