/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedActionException;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.wildfly.security.ParametricPrivilegedExceptionAction;
import org.wildfly.security.auth.AuthenticationContext;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServer;

public final class AuthenticationContextSaslServer
extends AbstractDelegatingSaslServer {
    private AuthenticationContext context;
    private ParametricPrivilegedExceptionAction<byte[], byte[]> responseAction = new ParametricPrivilegedExceptionAction<byte[], byte[]>(){

        @Override
        public byte[] run(byte[] parameter) throws Exception {
            return AuthenticationContextSaslServer.this.delegate.evaluateResponse(parameter);
        }
    };

    public AuthenticationContextSaslServer(SaslServer delegate, AuthenticationContext context) {
        super(delegate);
        this.context = context;
    }

    public AuthenticationContextSaslServer(SaslServer delegate) {
        super(delegate);
        this.context = AuthenticationContext.captureCurrent();
    }

    @Override
    public byte[] evaluateResponse(byte[] challenge) throws SaslException {
        try {
            return this.context.run(challenge, this.responseAction);
        }
        catch (PrivilegedActionException e) {
            try {
                throw e.getCause();
            }
            catch (Error | RuntimeException | SaslException rethrow) {
                throw rethrow;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
    }

    @Override
    public void dispose() throws SaslException {
        try {
            super.dispose();
        }
        finally {
            this.context = null;
            this.responseAction = null;
        }
    }
}

