/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.sasl.util.AggregateSaslClientFactory;
import org.wildfly.security.sasl.util.AggregateSaslServerFactory;
import org.wildfly.security.sasl.util.AuthenticationCompleteCallbackSaslClientFactory;
import org.wildfly.security.sasl.util.AuthenticationCompleteCallbackSaslServerFactory;
import org.wildfly.security.sasl.util.SecurityProviderSaslClientFactory;
import org.wildfly.security.sasl.util.SecurityProviderSaslServerFactory;
import org.wildfly.security.sasl.util.ServiceLoaderSaslClientFactory;
import org.wildfly.security.sasl.util.ServiceLoaderSaslServerFactory;

public final class SaslFactories {
    private static final SecurityProviderSaslClientFactory providerSaslClientFactory = new SecurityProviderSaslClientFactory();
    private static final SecurityProviderSaslServerFactory providerSaslServerFactory = new SecurityProviderSaslServerFactory();
    private static final String[] NO_STRINGS = new String[0];
    public static final SaslClientFactory EMPTY_SASL_CLIENT_FACTORY = new SaslClientFactory(){

        @Override
        public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            return null;
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return NO_STRINGS;
        }
    };
    public static final SaslServerFactory EMPTY_SASL_SERVER_FACTORY = new SaslServerFactory(){

        @Override
        public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
            return null;
        }

        @Override
        public String[] getMechanismNames(Map<String, ?> props) {
            return NO_STRINGS;
        }
    };

    private SaslFactories() {
    }

    public static SaslClientFactory getStandardSaslClientFactory(ClassLoader classLoader) {
        return new AuthenticationCompleteCallbackSaslClientFactory(new AggregateSaslClientFactory(new ServiceLoaderSaslClientFactory(classLoader), providerSaslClientFactory));
    }

    public static SaslServerFactory getStandardSaslServerFactory(ClassLoader classLoader) {
        return new AuthenticationCompleteCallbackSaslServerFactory(new AggregateSaslServerFactory(new ServiceLoaderSaslServerFactory(classLoader), providerSaslServerFactory));
    }
}

