/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.security.doseta;

import org.jboss.resteasy.annotations.security.doseta.After;
import org.jboss.resteasy.annotations.security.doseta.Signed;
import org.jboss.resteasy.security.doseta.DKIMSignature;
import org.jboss.resteasy.security.doseta.KeyRepository;

public class AbstractDigitalSigningHeaderDecorator {
    protected Signed signed;

    protected DKIMSignature createHeader(KeyRepository repository) {
        After after;
        DKIMSignature header = new DKIMSignature();
        if (this.signed.domain() != null && !this.signed.domain().equals("")) {
            header.setDomain(this.signed.domain());
        } else if (repository != null) {
            header.setDomain(repository.getDefaultPrivateDomain());
        }
        if (this.signed.algorithm() != null && !this.signed.algorithm().equals("")) {
            header.setAlgorithm(this.signed.algorithm());
        }
        if (this.signed.selector() != null && !this.signed.selector().equals("")) {
            header.setSelector(this.signed.selector());
        } else if (repository != null) {
            header.setSelector(repository.getDefaultPrivateSelector());
        }
        if (this.signed.timestamped()) {
            header.setTimestamp();
        }
        if ((after = this.signed.expires()).seconds() > 0 || after.minutes() > 0 || after.hours() > 0 || after.days() > 0 || after.months() > 0 || after.years() > 0) {
            header.setExpiration(after.seconds(), after.minutes(), after.hours(), after.days(), after.months(), after.years());
        }
        return header;
    }
}

