/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.PermissionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.OperationNotSupportedException;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.event.PartitionCreatedEvent;
import org.picketlink.idm.event.PartitionDeletedEvent;
import org.picketlink.idm.event.PartitionUpdatedEvent;
import org.picketlink.idm.internal.AbstractAttributedTypeManager;
import org.picketlink.idm.internal.ContextualIdentityManager;
import org.picketlink.idm.internal.ContextualPermissionManager;
import org.picketlink.idm.internal.ContextualRelationshipManager;
import org.picketlink.idm.internal.PartitionManagerConfiguration;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.basic.Realm;
import org.picketlink.idm.permission.acl.spi.PermissionHandler;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.IdentityQueryBuilder;
import org.picketlink.idm.spi.AttributeStore;
import org.picketlink.idm.spi.IdentityContext;

public class DefaultPartitionManager
extends AbstractAttributedTypeManager<Partition>
implements PartitionManager {
    private static final long serialVersionUID = 1L;
    private static final Realm DEFAULT_REALM = new Realm("default");

    public DefaultPartitionManager(IdentityConfiguration configuration) {
        this(Arrays.asList(configuration));
    }

    public DefaultPartitionManager(Collection<IdentityConfiguration> configurations) {
        this(configurations, null, null);
    }

    public DefaultPartitionManager(Collection<IdentityConfiguration> configurations, EventBridge eventBridge, Collection<PermissionHandler> permissionHandlers) {
        this(configurations, eventBridge, permissionHandlers, null);
    }

    public DefaultPartitionManager(Collection<IdentityConfiguration> configurations, EventBridge eventBridge, Collection<PermissionHandler> permissionHandlers, IdGenerator idGenerator) {
        super(new PartitionManagerConfiguration(configurations, permissionHandlers, eventBridge, idGenerator));
    }

    public IdentityManager createIdentityManager() throws IdentityManagementException {
        return this.createIdentityManager((Partition)DEFAULT_REALM);
    }

    public IdentityManager createIdentityManager(Partition partition) throws IdentityManagementException {
        if (partition == null) {
            if (!this.getConfiguration().supportsPartition()) {
                return this.createIdentityManager();
            }
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition");
        }
        Partition storedPartition = this.getStoredPartition(partition);
        try {
            return new ContextualIdentityManager(storedPartition, this);
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.partitionCouldNotCreateIdentityManager(storedPartition, e);
        }
    }

    public PermissionManager createPermissionManager() {
        return this.createPermissionManager((Partition)DEFAULT_REALM);
    }

    public PermissionManager createPermissionManager(Partition partition) throws IdentityManagementException {
        if (partition == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition");
        }
        Partition storedPartition = this.getStoredPartition(partition);
        try {
            return new ContextualPermissionManager(storedPartition, this);
        }
        catch (Exception ex) {
            throw IDMInternalMessages.MESSAGES.partitionCouldNotCreatePermissionManager(storedPartition);
        }
    }

    public RelationshipManager createRelationshipManager() {
        return new ContextualRelationshipManager(this);
    }

    public <T extends Partition> T getPartition(Class<T> partitionClass, String name) {
        if (partitionClass == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition class");
        }
        if (StringUtil.isNullOrEmpty((String)name)) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition name");
        }
        if (!this.getConfiguration().supportsPartition()) {
            return (T)this.createDefaultPartition();
        }
        try {
            IdentityContext identityContext = this.getIdentityContext();
            Partition partition = this.getStoreSelector().getStoreForPartitionOperation(identityContext, partitionClass).get(identityContext, partitionClass, name);
            if (partition != null) {
                this.loadAttributes(identityContext, partition);
            }
            return (T)partition;
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.partitionGetFailed(partitionClass, name, e);
        }
    }

    public <T extends Partition> List<T> getPartitions(Class<T> partitionClass) {
        if (partitionClass == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition class");
        }
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        if (!this.getConfiguration().supportsPartition()) {
            partitions.add(this.createDefaultPartition());
        } else {
            try {
                IdentityContext identityContext = this.getIdentityContext();
                partitions.addAll(this.getStoreSelector().getStoreForPartitionOperation(identityContext, partitionClass).get(identityContext, partitionClass));
                for (Partition partition : partitions) {
                    this.loadAttributes(identityContext, partition);
                }
            }
            catch (Exception e) {
                throw IDMInternalMessages.MESSAGES.partitionGetFailed(partitionClass, "not specified", e);
            }
        }
        return partitions;
    }

    public <T extends Partition> T lookupById(Class<T> partitionClass, String id) {
        if (partitionClass == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition class");
        }
        if (StringUtil.isNullOrEmpty((String)id)) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition identifier");
        }
        if (!this.getConfiguration().supportsPartition()) {
            return (T)this.createDefaultPartition();
        }
        try {
            IdentityContext identityContext = this.getIdentityContext();
            Partition partition = this.getStoreSelector().getStoreForPartitionOperation(identityContext, partitionClass).lookupById(identityContext, partitionClass, id);
            if (partition != null) {
                this.loadAttributes(identityContext, partition);
            }
            return (T)partition;
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.partitionGetFailed(partitionClass, id, e);
        }
    }

    @Override
    protected void fireAttributedTypeAddedEvent(Partition attributedType) {
    }

    @Override
    protected void doAdd(Partition attributedType) {
    }

    @Override
    public void add(Partition attributedType) throws IdentityManagementException {
        this.add(attributedType, null);
    }

    public void add(Partition partition, String configurationName) throws IdentityManagementException {
        this.checkPartitionManagementSupported();
        if (partition == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition");
        }
        if (StringUtil.isNullOrEmpty((String)configurationName)) {
            configurationName = this.getConfiguration().getDefaultConfigurationName();
        }
        if (this.getConfiguration().getConfigurationByName(configurationName) != null) {
            this.checkUniqueness(partition);
            try {
                IdentityContext identityContext = this.getIdentityContext();
                this.getStoreSelector().getStoreForPartitionOperation(identityContext, partition.getClass()).add(identityContext, partition, configurationName);
                this.addAttributes(identityContext, (AttributedType)partition);
                this.fireEvent(new PartitionCreatedEvent(partition, (PartitionManager)this));
            }
            catch (Exception e) {
                throw IDMInternalMessages.MESSAGES.partitionAddFailed(partition, configurationName, e);
            }
        }
    }

    @Override
    protected void fireAttributedTypeUpdatedEvent(Partition attributedType) {
        this.fireEvent(new PartitionUpdatedEvent(attributedType, (PartitionManager)this));
    }

    @Override
    protected void doUpdate(Partition attributedType) {
        this.checkPartitionManagementSupported();
        IdentityContext identityContext = this.getIdentityContext();
        this.getStoreSelector().getStoreForPartitionOperation(identityContext, attributedType.getClass()).update(identityContext, attributedType);
    }

    @Override
    protected void fireAttributedTypeRemovedEvent(Partition attributedType) {
        this.fireEvent(new PartitionDeletedEvent(attributedType, (PartitionManager)this));
    }

    @Override
    protected void doRemove(Partition attributedType) {
        this.checkPartitionManagementSupported();
        IdentityManager identityManager = this.createIdentityManager(attributedType);
        IdentityQueryBuilder queryBuilder = identityManager.getQueryBuilder();
        IdentityQuery query = queryBuilder.createIdentityQuery(IdentityType.class);
        for (IdentityType identityType : query.getResultList()) {
            identityManager.remove((AttributedType)identityType);
        }
        IdentityContext identityContext = this.getIdentityContext();
        this.getStoreSelector().getStoreForPartitionOperation(identityContext, attributedType.getClass()).remove(identityContext, attributedType);
    }

    @Override
    protected void checkUniqueness(Partition attributedType) throws IdentityManagementException {
        Object storedPartition = this.getPartition(attributedType.getClass(), attributedType.getName());
        if (storedPartition != null) {
            throw IDMInternalMessages.MESSAGES.partitionAlreadyExistsWithName(attributedType.getClass(), storedPartition.getName());
        }
    }

    @Override
    protected void checkIfExists(Partition partition) throws IdentityManagementException {
        if (partition == null) {
            throw IDMInternalMessages.MESSAGES.nullArgument("Partition");
        }
        if (this.lookupById(partition.getClass(), partition.getId()) == null) {
            throw IDMInternalMessages.MESSAGES.partitionNotFoundWithName(partition.getClass(), partition.getName());
        }
    }

    public Collection<IdentityConfiguration> getConfigurations() {
        return this.getConfiguration().getConfigurations();
    }

    private void checkPartitionManagementSupported() throws OperationNotSupportedException {
        if (!this.getConfiguration().supportsPartition()) {
            throw IDMInternalMessages.MESSAGES.partitionManagementNoSupported(Partition.class, IdentityStoreConfiguration.IdentityOperation.create);
        }
    }

    private Partition createDefaultPartition() {
        Realm storedPartition = new Realm("default");
        storedPartition.setId("default");
        return storedPartition;
    }

    private Partition getStoredPartition(Partition partition) {
        Object storedPartition = this.getConfiguration().supportsPartition() ? this.getPartition(partition.getClass(), partition.getName()) : this.createDefaultPartition();
        if (storedPartition == null) {
            throw IDMInternalMessages.MESSAGES.partitionNotFoundWithName(partition.getClass(), partition.getName());
        }
        return storedPartition;
    }

    private <T extends Partition> void loadAttributes(IdentityContext context, T partition) {
        AttributeStore attributeStore = this.getStoreSelector().getStoreForAttributeOperation(context);
        if (attributeStore != null) {
            attributeStore.loadAttributes(context, partition);
        }
    }

    @Override
    public IdentityContext getIdentityContext() {
        return this.createIdentityContext(null, this.getConfiguration().getEventBridge(), this.getConfiguration().getIdGenerator());
    }
}

