/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.parsing;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.parsing.Element;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionPropertyResourceDefinition;
import org.jboss.as.domain.management.connections.ldap.LdapConnectionResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.parsing.ManagementXml;
import org.jboss.as.domain.management.parsing.ManagementXmlDelegate;
import org.jboss.as.domain.management.security.AdvancedUserSearchResourceDefintion;
import org.jboss.as.domain.management.security.BaseLdapGroupSearchResource;
import org.jboss.as.domain.management.security.BaseLdapUserSearchResource;
import org.jboss.as.domain.management.security.GroupToPrincipalResourceDefinition;
import org.jboss.as.domain.management.security.JaasAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.KerberosAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.KeystoreAttributes;
import org.jboss.as.domain.management.security.KeytabResourceDefinition;
import org.jboss.as.domain.management.security.LdapAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.LdapAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.LdapCacheResourceDefinition;
import org.jboss.as.domain.management.security.LocalAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PlugInAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PrincipalToGroupResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthenticationResourceDefinition;
import org.jboss.as.domain.management.security.PropertiesAuthorizationResourceDefinition;
import org.jboss.as.domain.management.security.PropertyResourceDefinition;
import org.jboss.as.domain.management.security.SSLServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecretServerIdentityResourceDefinition;
import org.jboss.as.domain.management.security.SecurityRealmResourceDefinition;
import org.jboss.as.domain.management.security.UserResourceDefinition;
import org.jboss.as.domain.management.security.UserSearchResourceDefintion;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class ManagementXml_Legacy
extends ManagementXml {
    private final Namespace namespace;
    private final ManagementXmlDelegate delegate;

    ManagementXml_Legacy(Namespace namespace, ManagementXmlDelegate delegate) {
        this.namespace = namespace;
        this.delegate = delegate;
    }

    @Override
    public void parseManagement(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requireNativeInterface) throws XMLStreamException {
        switch (this.namespace) {
            case DOMAIN_1_0: 
            case DOMAIN_1_1: 
            case DOMAIN_1_2: 
            case DOMAIN_1_3: 
            case DOMAIN_1_4: {
                this.parseManagement_1_0(reader, address, list, requireNativeInterface);
                break;
            }
            default: {
                this.parseManagement_1_5(reader, address, list, requireNativeInterface);
            }
        }
    }

    private void parseManagement_1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requireNativeInterface) throws XMLStreamException {
        int securityRealmsCount = 0;
        int connectionsCount = 0;
        int managementInterfacesCount = 0;
        ModelNode managementAddress = address.clone().add("core-service", "management");
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECURITY_REALMS: {
                    if (++securityRealmsCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.delegate.parseSecurityRealms(reader, managementAddress, list)) continue block5;
                    this.parseSecurityRealms(reader, managementAddress, list);
                    continue block5;
                }
                case OUTBOUND_CONNECTIONS: {
                    if (++connectionsCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.delegate.parseOutboundConnections(reader, managementAddress, list)) continue block5;
                    this.parseOutboundConnections(reader, managementAddress, list);
                    continue block5;
                }
                case MANAGEMENT_INTERFACES: {
                    if (++managementInterfacesCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.delegate.parseManagementInterfaces(reader, managementAddress, list)) continue block5;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (requireNativeInterface && managementInterfacesCount < 1) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.MANAGEMENT_INTERFACES));
        }
    }

    private void parseManagement_1_5(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list, boolean requireNativeInterface) throws XMLStreamException {
        int securityRealmsCount = 0;
        int connectionsCount = 0;
        int managementInterfacesCount = 0;
        ModelNode managementAddress = address.clone().add("core-service", "management");
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECURITY_REALMS: {
                    if (++securityRealmsCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.delegate.parseSecurityRealms(reader, managementAddress, list)) continue block7;
                    this.parseSecurityRealms(reader, managementAddress, list);
                    continue block7;
                }
                case OUTBOUND_CONNECTIONS: {
                    if (++connectionsCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.delegate.parseOutboundConnections(reader, managementAddress, list)) continue block7;
                    this.parseOutboundConnections(reader, managementAddress, list);
                    continue block7;
                }
                case MANAGEMENT_INTERFACES: {
                    if (++managementInterfacesCount > 1) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    if (this.delegate.parseManagementInterfaces(reader, managementAddress, list)) continue block7;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case AUDIT_LOG: {
                    if (this.delegate.parseAuditLog(reader, managementAddress, list)) continue block7;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case ACCESS_CONTROL: {
                    if (this.delegate.parseAccessControl(reader, managementAddress, list)) continue block7;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (requireNativeInterface && managementInterfacesCount < 1) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.MANAGEMENT_INTERFACES));
        }
    }

    private void parseOutboundConnections(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case LDAP: {
                    switch (this.namespace) {
                        case DOMAIN_1_0: 
                        case DOMAIN_1_1: 
                        case DOMAIN_1_2: 
                        case DOMAIN_1_3: {
                            this.parseLdapConnection_1_0(reader, address, list);
                            continue block8;
                        }
                        case DOMAIN_1_4: 
                        case DOMAIN_1_5: {
                            this.parseLdapConnection_1_4(reader, address, list);
                            continue block8;
                        }
                        case DOMAIN_2_0: {
                            this.parseLdapConnection_2_0(reader, address, list);
                            continue block8;
                        }
                    }
                    this.parseLdapConnection_1_6_and_2_1(reader, address, list);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLdapConnection_1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.URL, Attribute.SEARCH_DN, Attribute.SEARCH_CREDENTIAL);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    add.get("address").set(address).add("ldap-connection", value);
                    continue block7;
                }
                case URL: {
                    LdapConnectionResourceDefinition.URL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block7;
                }
                case SEARCH_DN: {
                    LdapConnectionResourceDefinition.SEARCH_DN.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block7;
                }
                case SEARCH_CREDENTIAL: {
                    LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block7;
                }
                case INITIAL_CONTEXT_FACTORY: {
                    LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseLdapConnection_1_4(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.URL);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    add.get("address").set(address).add("ldap-connection", value);
                    continue block8;
                }
                case URL: {
                    LdapConnectionResourceDefinition.URL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case SEARCH_DN: {
                    LdapConnectionResourceDefinition.SEARCH_DN.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case SEARCH_CREDENTIAL: {
                    LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case SECURITY_REALM: {
                    LdapConnectionResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                case INITIAL_CONTEXT_FACTORY: {
                    LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseLdapConnection_2_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        ModelNode connectionAddress = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.URL);
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    connectionAddress = address.clone().add("ldap-connection", value);
                    add.get("address").set(connectionAddress);
                    continue block11;
                }
                case URL: {
                    LdapConnectionResourceDefinition.URL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block11;
                }
                case SEARCH_DN: {
                    LdapConnectionResourceDefinition.SEARCH_DN.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block11;
                }
                case SEARCH_CREDENTIAL: {
                    LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block11;
                }
                case SECURITY_REALM: {
                    LdapConnectionResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block11;
                }
                case INITIAL_CONTEXT_FACTORY: {
                    LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        boolean propertiesFound = false;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    if (propertiesFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    propertiesFound = true;
                    this.parseLdapConnectionProperties(reader, connectionAddress, list);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLdapConnection_1_6_and_2_1(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        ModelNode connectionAddress = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.URL);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case NAME: {
                    connectionAddress = address.clone().add("ldap-connection", value);
                    add.get("address").set(connectionAddress);
                    continue block13;
                }
                case URL: {
                    LdapConnectionResourceDefinition.URL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case SEARCH_DN: {
                    LdapConnectionResourceDefinition.SEARCH_DN.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case SEARCH_CREDENTIAL: {
                    LdapConnectionResourceDefinition.SEARCH_CREDENTIAL.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case SECURITY_REALM: {
                    LdapConnectionResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case INITIAL_CONTEXT_FACTORY: {
                    LdapConnectionResourceDefinition.INITIAL_CONTEXT_FACTORY.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case REFERRALS: {
                    LdapConnectionResourceDefinition.REFERRALS.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block13;
                }
                case HANDLES_REFERRALS_FOR: {
                    for (String url : reader.getListAttributeValue(i)) {
                        LdapConnectionResourceDefinition.HANDLES_REFERRALS_FOR.parseAndAddParameterElement(url, add, (XMLStreamReader)reader);
                    }
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        boolean propertiesFound = false;
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    if (propertiesFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    propertiesFound = true;
                    this.parseLdapConnectionProperties(reader, connectionAddress, list);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLdapConnectionProperties(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.VALUE);
                    ModelNode add = new ModelNode();
                    add.get("operation").set("add");
                    int count = reader.getAttributeCount();
                    block8: for (int i = 0; i < count; ++i) {
                        String value = reader.getAttributeValue(i);
                        if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                        }
                        Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
                        required.remove(attribute);
                        switch (attribute) {
                            case NAME: {
                                add.get("address").set(address.clone()).add("property", value);
                                continue block8;
                            }
                            case VALUE: {
                                LdapConnectionPropertyResourceDefinition.VALUE.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (required.size() > 0) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    list.add(add);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSecurityRealms(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECURITY_REALM: {
                    switch (this.namespace) {
                        case DOMAIN_1_0: {
                            this.parseSecurityRealm_1_0(reader, address, list);
                            continue block7;
                        }
                        case DOMAIN_1_1: 
                        case DOMAIN_1_2: {
                            this.parseSecurityRealm_1_1(reader, address, list);
                            continue block7;
                        }
                    }
                    this.parseSecurityRealm_1_3(reader, address, list);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSecurityRealm_1_0(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String realmName = reader.getAttributeValue(0);
        ModelNode realmAddress = address.clone();
        realmAddress.add("security-realm", realmName);
        ModelNode add = new ModelNode();
        add.get("address").set(realmAddress);
        add.get("operation").set("add");
        list.add(add);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SERVER_IDENTITIES: {
                    this.parseServerIdentities_1_0(reader, realmAddress, list);
                    continue block4;
                }
                case AUTHENTICATION: {
                    this.parseAuthentication_1_0(reader, realmAddress, list);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSecurityRealm_1_1(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String realmName = reader.getAttributeValue(0);
        ModelNode realmAddress = address.clone();
        realmAddress.add("security-realm", realmName);
        ModelNode add = new ModelNode();
        add.get("address").set(realmAddress);
        add.get("operation").set("add");
        list.add(add);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SERVER_IDENTITIES: {
                    this.parseServerIdentities_1_0(reader, realmAddress, list);
                    continue block5;
                }
                case AUTHENTICATION: {
                    this.parseAuthentication_1_1(reader, realmAddress, list);
                    continue block5;
                }
                case AUTHORIZATION: {
                    this.parseAuthorization_1_1(reader, add, list);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSecurityRealm_1_3(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String realmName = reader.getAttributeValue(0);
        ModelNode realmAddress = address.clone();
        realmAddress.add("security-realm", realmName);
        ModelNode add = new ModelNode();
        add.get("address").set(realmAddress);
        add.get("operation").set("add");
        list.add(add);
        block23: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PLUG_INS: {
                    this.parsePlugIns(reader, realmAddress, list);
                    continue block23;
                }
                case SERVER_IDENTITIES: {
                    switch (this.namespace.getMajorVersion()) {
                        case 1: {
                            switch (this.namespace) {
                                case DOMAIN_1_3: 
                                case DOMAIN_1_4: 
                                case DOMAIN_1_5: 
                                case DOMAIN_1_6: {
                                    this.parseServerIdentities_1_0(reader, realmAddress, list);
                                    continue block23;
                                }
                            }
                            this.parseServerIdentities_1_7_and_3_0(reader, realmAddress, list);
                            continue block23;
                        }
                        case 2: {
                            this.parseServerIdentities_1_0(reader, realmAddress, list);
                            continue block23;
                        }
                    }
                    this.parseServerIdentities_1_7_and_3_0(reader, realmAddress, list);
                    continue block23;
                }
                case AUTHENTICATION: {
                    switch (this.namespace.getMajorVersion()) {
                        case 1: {
                            switch (this.namespace) {
                                case DOMAIN_1_3: 
                                case DOMAIN_1_4: 
                                case DOMAIN_1_5: 
                                case DOMAIN_1_6: {
                                    this.parseAuthentication_1_3(reader, realmAddress, list);
                                    continue block23;
                                }
                            }
                            this.parseAuthentication_1_7_and_3_0(reader, realmAddress, list);
                            continue block23;
                        }
                        case 2: {
                            this.parseAuthentication_1_3(reader, realmAddress, list);
                            continue block23;
                        }
                    }
                    this.parseAuthentication_1_7_and_3_0(reader, realmAddress, list);
                    continue block23;
                }
                case AUTHORIZATION: {
                    switch (this.namespace) {
                        case DOMAIN_1_3: 
                        case DOMAIN_1_4: {
                            this.parseAuthorization_1_3(reader, realmAddress, list);
                            continue block23;
                        }
                    }
                    this.parseAuthorization_1_5_and_2_0(reader, add, list);
                    continue block23;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parsePlugIns(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PLUG_IN: {
                    ModelNode plugIn = new ModelNode();
                    plugIn.get("operation").set("add");
                    String moduleValue = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.MODULE.getLocalName());
                    ModelNode newAddress = realmAddress.clone();
                    newAddress.add("plug-in", moduleValue);
                    plugIn.get("address").set(newAddress);
                    list.add(plugIn);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServerIdentities_1_0(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECRET: {
                    this.parseSecret(reader, realmAddress, list);
                    continue block7;
                }
                case SSL: {
                    if (this.namespace.getMajorVersion() == 1) {
                        this.parseSSL_1_0(reader, realmAddress, list);
                        continue block7;
                    }
                    switch (this.namespace) {
                        case DOMAIN_2_0: 
                        case DOMAIN_2_1: {
                            this.parseSSL_1_0(reader, realmAddress, list);
                            continue block7;
                        }
                    }
                    this.parseSSL_1_7_and_2_2(reader, realmAddress, list);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseServerIdentities_1_7_and_3_0(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case SECRET: {
                    this.parseSecret(reader, realmAddress, list);
                    continue block5;
                }
                case SSL: {
                    this.parseSSL_1_7_and_2_2(reader, realmAddress, list);
                    continue block5;
                }
                case KERBEROS: {
                    this.parseKerberosIdentity(reader, realmAddress, list);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSecret(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode secret = new ModelNode();
        secret.get("operation").set("add");
        secret.get("address").set(realmAddress).add("server-identity", "secret");
        String secretValue = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.VALUE.getLocalName());
        SecretServerIdentityResourceDefinition.VALUE.parseAndSetParameter(secretValue, secret, (XMLStreamReader)reader);
        list.add(secret);
    }

    private void parseSSL_1_0(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode ssl = new ModelNode();
        ssl.get("operation").set("add");
        ssl.get("address").set(realmAddress).add("server-identity", "ssl");
        list.add(ssl);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PROTOCOL: {
                    SSLServerIdentityResourceDefinition.PROTOCOL.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case KEYSTORE: {
                    switch (this.namespace) {
                        case DOMAIN_1_0: 
                        case DOMAIN_1_1: 
                        case DOMAIN_1_2: {
                            this.parseKeystore_1_0(reader, ssl);
                            continue block11;
                        }
                        case DOMAIN_1_3: 
                        case DOMAIN_1_4: 
                        case DOMAIN_1_5: 
                        case DOMAIN_2_0: {
                            this.parseKeystore_1_3(reader, ssl, true);
                            continue block11;
                        }
                    }
                    this.parseKeystore_1_6_and_2_1(reader, ssl, true);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseSSL_1_7_and_2_2(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode ssl = new ModelNode();
        ssl.get("operation").set("add");
        ssl.get("address").set(realmAddress).add("server-identity", "ssl");
        list.add(ssl);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PROTOCOL: {
                    SSLServerIdentityResourceDefinition.PROTOCOL.parseAndSetParameter(value, ssl, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ENGINE: {
                    this.parseEngine(reader, ssl);
                    continue block8;
                }
                case KEYSTORE: {
                    this.parseKeystore_1_6_and_2_1(reader, ssl, true);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseEngine(XMLExtendedStreamReader reader, ModelNode addOperation) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED_CIPHER_SUITES: {
                    for (String value : reader.getListAttributeValue(i)) {
                        SSLServerIdentityResourceDefinition.ENABLED_CIPHER_SUITES.parseAndAddParameterElement(value, addOperation, (XMLStreamReader)reader);
                    }
                    continue block4;
                }
                case ENABLED_PROTOCOLS: {
                    for (String value : reader.getListAttributeValue(i)) {
                        SSLServerIdentityResourceDefinition.ENABLED_PROTOCOLS.parseAndAddParameterElement(value, addOperation, (XMLStreamReader)reader);
                    }
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseKeystore_1_0(XMLExtendedStreamReader reader, ModelNode addOperation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH, Attribute.PASSWORD);
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case PATH: {
                    KeystoreAttributes.KEYSTORE_PATH.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                case PASSWORD: {
                    KeystoreAttributes.KEYSTORE_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                case RELATIVE_TO: {
                    KeystoreAttributes.KEYSTORE_RELATIVE_TO.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseKeystore_1_3(XMLExtendedStreamReader reader, ModelNode addOperation, boolean extended) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATH, Attribute.KEYSTORE_PASSWORD);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case PATH: {
                    KeystoreAttributes.KEYSTORE_PATH.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case PASSWORD: {
                    DomainManagementLogger.ROOT_LOGGER.passwordAttributeDeprecated();
                    required.remove(Attribute.KEYSTORE_PASSWORD);
                    KeystoreAttributes.KEYSTORE_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case KEYSTORE_PASSWORD: {
                    KeystoreAttributes.KEYSTORE_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case RELATIVE_TO: {
                    KeystoreAttributes.KEYSTORE_RELATIVE_TO.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case ALIAS: {
                    if (extended) {
                        KeystoreAttributes.ALIAS.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                        continue block8;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case KEY_PASSWORD: {
                    if (extended) {
                        KeystoreAttributes.KEY_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                        continue block8;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseKeystore_1_6_and_2_1(XMLExtendedStreamReader reader, ModelNode addOperation, boolean extended) throws XMLStreamException {
        boolean keystorePasswordSet = false;
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PROVIDER: {
                    KeystoreAttributes.KEYSTORE_PROVIDER.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case PATH: {
                    KeystoreAttributes.KEYSTORE_PATH.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case KEYSTORE_PASSWORD: {
                    KeystoreAttributes.KEYSTORE_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    keystorePasswordSet = true;
                    continue block8;
                }
                case RELATIVE_TO: {
                    KeystoreAttributes.KEYSTORE_RELATIVE_TO.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                    continue block8;
                }
                case ALIAS: {
                    if (extended) {
                        KeystoreAttributes.ALIAS.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                        continue block8;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                case KEY_PASSWORD: {
                    if (extended) {
                        KeystoreAttributes.KEY_PASSWORD.parseAndSetParameter(value, addOperation, (XMLStreamReader)reader);
                        continue block8;
                    }
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!keystorePasswordSet) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.KEYSTORE_PASSWORD));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseKerberosIdentity(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode kerberos = new ModelNode();
        kerberos.get("operation").set("add");
        ModelNode kerberosAddress = realmAddress.clone().add("server-identity", "kerberos");
        kerberos.get("address").set(kerberosAddress);
        list.add(kerberos);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case KEYTAB: {
                    this.parseKeyTab(reader, kerberosAddress, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseKeyTab(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode keytab = new ModelNode();
        keytab.get("operation").set("add");
        list.add(keytab);
        EnumSet<Attribute> requiredAttributes = EnumSet.of(Attribute.PRINCIPAL, Attribute.PATH);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            requiredAttributes.remove(attribute);
            switch (attribute) {
                case PRINCIPAL: {
                    keytab.get("address").set(parentAddress).add("keytab", value);
                    continue block7;
                }
                case PATH: {
                    KeytabResourceDefinition.PATH.parseAndSetParameter(value, keytab, (XMLStreamReader)reader);
                    continue block7;
                }
                case RELATIVE_TO: {
                    KeytabResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, keytab, (XMLStreamReader)reader);
                    continue block7;
                }
                case FOR_HOSTS: {
                    for (String host : reader.getListAttributeValue(i)) {
                        KeytabResourceDefinition.FOR_HOSTS.parseAndAddParameterElement(host, keytab, (XMLStreamReader)reader);
                    }
                    continue block7;
                }
                case DEBUG: {
                    KeytabResourceDefinition.DEBUG.parseAndSetParameter(value, keytab, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!requiredAttributes.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredAttributes);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseAuthentication_1_0(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        int userCount = 0;
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (++userCount > 1) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case LDAP: {
                    this.parseLdapAuthentication_1_0(reader, realmAddress, list);
                    continue block5;
                }
                case PROPERTIES: {
                    this.parsePropertiesAuthentication_1_0(reader, realmAddress, list);
                    continue block5;
                }
                case USERS: {
                    this.parseUsersAuthentication(reader, realmAddress, list);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        this.addLegacyLocalAuthentication(realmAddress, list);
    }

    private void parseAuthentication_1_1(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        boolean trustStoreFound = false;
        boolean usernamePasswordFound = false;
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case JAAS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseJaasAuthentication_1_1(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block7;
                }
                case LDAP: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseLdapAuthentication_1_1(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block7;
                }
                case PROPERTIES: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parsePropertiesAuthentication_1_1(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block7;
                }
                case TRUSTSTORE: {
                    if (trustStoreFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseTruststore(reader, realmAddress, list);
                    trustStoreFound = true;
                    continue block7;
                }
                case USERS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseUsersAuthentication(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        this.addLegacyLocalAuthentication(realmAddress, list);
    }

    private void parseAuthentication_1_3(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        boolean trustStoreFound = false;
        boolean localFound = false;
        boolean usernamePasswordFound = false;
        block27: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case JAAS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    block9 : switch (this.namespace) {
                        case DOMAIN_1_3: 
                        case DOMAIN_1_4: 
                        case DOMAIN_1_5: {
                            this.parseJaasAuthentication_1_1(reader, realmAddress, list);
                            break;
                        }
                        default: {
                            switch (this.namespace.getMajorVersion()) {
                                case 2: {
                                    this.parseJaasAuthentication_1_1(reader, realmAddress, list);
                                    break block9;
                                }
                            }
                            this.parseJaasAuthentication_1_6_and_3_0(reader, realmAddress, list);
                        }
                    }
                    usernamePasswordFound = true;
                    continue block27;
                }
                case LDAP: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    block15 : switch (this.namespace) {
                        case DOMAIN_1_3: {
                            this.parseLdapAuthentication_1_1(reader, realmAddress, list);
                            break;
                        }
                        default: {
                            switch (this.namespace.getMajorVersion()) {
                                case 1: {
                                    this.parseLdapAuthentication_1_4(reader, realmAddress, list);
                                    break block15;
                                }
                            }
                            this.parseLdapAuthentication_1_7_and_2_0(reader, realmAddress, list);
                        }
                    }
                    usernamePasswordFound = true;
                    continue block27;
                }
                case PROPERTIES: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parsePropertiesAuthentication_1_1(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block27;
                }
                case TRUSTSTORE: {
                    if (trustStoreFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseTruststore(reader, realmAddress, list);
                    trustStoreFound = true;
                    continue block27;
                }
                case USERS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseUsersAuthentication(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block27;
                }
                case PLUG_IN: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ModelNode parentAddress = realmAddress.clone().add("authentication");
                    this.parsePlugIn_Authentication(reader, parentAddress, list);
                    usernamePasswordFound = true;
                    continue block27;
                }
                case LOCAL: {
                    if (localFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    block21 : switch (this.namespace) {
                        case DOMAIN_2_0: {
                            this.parseLocalAuthentication_1_3(reader, realmAddress, list);
                            break;
                        }
                        default: {
                            switch (this.namespace.getMajorVersion()) {
                                case 1: {
                                    this.parseLocalAuthentication_1_3(reader, realmAddress, list);
                                    break block21;
                                }
                            }
                            this.parseLocalAuthentication_2_1(reader, realmAddress, list);
                        }
                    }
                    localFound = true;
                    continue block27;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuthentication_1_7_and_3_0(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        boolean trustStoreFound = false;
        boolean localFound = false;
        boolean kerberosFound = false;
        boolean usernamePasswordFound = false;
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case JAAS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseJaasAuthentication_1_6_and_3_0(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block10;
                }
                case KERBEROS: {
                    if (kerberosFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseKerberosAuthentication_3_0(reader, realmAddress, list);
                    kerberosFound = true;
                    continue block10;
                }
                case LDAP: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseLdapAuthentication_1_7_and_2_0(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block10;
                }
                case PROPERTIES: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parsePropertiesAuthentication_1_1(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block10;
                }
                case TRUSTSTORE: {
                    if (trustStoreFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseTruststore(reader, realmAddress, list);
                    trustStoreFound = true;
                    continue block10;
                }
                case USERS: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseUsersAuthentication(reader, realmAddress, list);
                    usernamePasswordFound = true;
                    continue block10;
                }
                case PLUG_IN: {
                    if (usernamePasswordFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ModelNode parentAddress = realmAddress.clone().add("authentication");
                    this.parsePlugIn_Authentication(reader, parentAddress, list);
                    usernamePasswordFound = true;
                    continue block10;
                }
                case LOCAL: {
                    if (localFound) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    this.parseLocalAuthentication_2_1(reader, realmAddress, list);
                    localFound = true;
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseKerberosAuthentication_3_0(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "kerberos");
        ModelNode kerberos = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(kerberos);
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case REMOVE_REALM: {
                    KerberosAuthenticationResourceDefinition.REMOVE_REALM.parseAndSetParameter(value, kerberos, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseJaasAuthentication_1_1(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "jaas");
        ModelNode jaas = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(jaas);
        boolean nameFound = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    if (nameFound) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    nameFound = true;
                    JaasAuthenticationResourceDefinition.NAME.parseAndSetParameter(value, jaas, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!nameFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseJaasAuthentication_1_6_and_3_0(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "jaas");
        ModelNode jaas = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(jaas);
        boolean nameFound = false;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    if (nameFound) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    nameFound = true;
                    JaasAuthenticationResourceDefinition.NAME.parseAndSetParameter(value, jaas, (XMLStreamReader)reader);
                    continue block4;
                }
                case ASSIGN_GROUPS: {
                    JaasAuthenticationResourceDefinition.ASSIGN_GROUPS.parseAndSetParameter(value, jaas, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!nameFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseLdapAuthentication_1_0(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "ldap");
        ModelNode ldapAuthentication = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthentication);
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION, Attribute.BASE_DN, Attribute.USERNAME_ATTRIBUTE);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthenticationResourceDefinition.CONNECTION.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block7;
                }
                case BASE_DN: {
                    LdapAuthenticationResourceDefinition.BASE_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block7;
                }
                case USERNAME_ATTRIBUTE: {
                    LdapAuthenticationResourceDefinition.USERNAME_FILTER.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block7;
                }
                case RECURSIVE: {
                    LdapAuthenticationResourceDefinition.RECURSIVE.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block7;
                }
                case USER_DN: {
                    LdapAuthenticationResourceDefinition.USER_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseLdapAuthentication_1_1(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "ldap");
        ModelNode ldapAuthentication = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthentication);
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION, Attribute.BASE_DN);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthenticationResourceDefinition.CONNECTION.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block10;
                }
                case BASE_DN: {
                    LdapAuthenticationResourceDefinition.BASE_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block10;
                }
                case RECURSIVE: {
                    LdapAuthenticationResourceDefinition.RECURSIVE.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block10;
                }
                case USER_DN: {
                    LdapAuthenticationResourceDefinition.USER_DN.parseAndSetParameter(value, ldapAuthentication, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        boolean choiceFound = false;
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            if (choiceFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            choiceFound = true;
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ADVANCED_FILTER: {
                    String filter = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.FILTER.getLocalName());
                    LdapAuthenticationResourceDefinition.ADVANCED_FILTER.parseAndSetParameter(filter, ldapAuthentication, (XMLStreamReader)reader);
                    continue block11;
                }
                case USERNAME_FILTER: {
                    String usernameAttr = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.ATTRIBUTE.getLocalName());
                    LdapAuthenticationResourceDefinition.USERNAME_FILTER.parseAndSetParameter(usernameAttr, ldapAuthentication, (XMLStreamReader)reader);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!choiceFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.ADVANCED_FILTER, Element.USERNAME_FILTER));
        }
    }

    private void parseLdapAuthenticationAttributes_1_4(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION, Attribute.BASE_DN);
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthenticationResourceDefinition.CONNECTION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                case BASE_DN: {
                    LdapAuthenticationResourceDefinition.BASE_DN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                case RECURSIVE: {
                    LdapAuthenticationResourceDefinition.RECURSIVE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                case USER_DN: {
                    LdapAuthenticationResourceDefinition.USER_DN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                case ALLOW_EMPTY_PASSWORDS: {
                    LdapAuthenticationResourceDefinition.ALLOW_EMPTY_PASSWORDS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
    }

    private void parseLdapAuthenticationAttributes_2_0(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION, Attribute.BASE_DN);
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthenticationResourceDefinition.CONNECTION.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case BASE_DN: {
                    LdapAuthenticationResourceDefinition.BASE_DN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case RECURSIVE: {
                    LdapAuthenticationResourceDefinition.RECURSIVE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case USER_DN: {
                    LdapAuthenticationResourceDefinition.USER_DN.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case ALLOW_EMPTY_PASSWORDS: {
                    LdapAuthenticationResourceDefinition.ALLOW_EMPTY_PASSWORDS.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case USERNAME_LOAD: {
                    LdapAuthenticationResourceDefinition.USERNAME_LOAD.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
    }

    private void parseLdapAuthentication_1_4(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "ldap");
        ModelNode ldapAuthentication = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthentication);
        this.parseLdapAuthenticationAttributes_1_4(reader, ldapAuthentication);
        boolean choiceFound = false;
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            if (choiceFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            choiceFound = true;
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case ADVANCED_FILTER: {
                    String filter = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.FILTER.getLocalName());
                    LdapAuthenticationResourceDefinition.ADVANCED_FILTER.parseAndSetParameter(filter, ldapAuthentication, (XMLStreamReader)reader);
                    continue block4;
                }
                case USERNAME_FILTER: {
                    String usernameAttr = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.ATTRIBUTE.getLocalName());
                    LdapAuthenticationResourceDefinition.USERNAME_FILTER.parseAndSetParameter(usernameAttr, ldapAuthentication, (XMLStreamReader)reader);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!choiceFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.ADVANCED_FILTER, Element.USERNAME_FILTER));
        }
    }

    private void parseLdapAuthentication_1_7_and_2_0(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "ldap");
        ModelNode ldapAuthentication = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthentication);
        switch (this.namespace.getMajorVersion()) {
            case 1: {
                this.parseLdapAuthenticationAttributes_1_4(reader, ldapAuthentication);
                break;
            }
            default: {
                this.parseLdapAuthenticationAttributes_2_0(reader, ldapAuthentication);
            }
        }
        ModelNode addLdapCache = null;
        boolean choiceFound = false;
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            if (choiceFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case CACHE: {
                    if (addLdapCache != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    addLdapCache = this.parseLdapCache(reader);
                    continue block8;
                }
                case ADVANCED_FILTER: {
                    choiceFound = true;
                    String filter = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.FILTER.getLocalName());
                    LdapAuthenticationResourceDefinition.ADVANCED_FILTER.parseAndSetParameter(filter, ldapAuthentication, (XMLStreamReader)reader);
                    continue block8;
                }
                case USERNAME_FILTER: {
                    choiceFound = true;
                    String usernameAttr = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.ATTRIBUTE.getLocalName());
                    LdapAuthenticationResourceDefinition.USERNAME_FILTER.parseAndSetParameter(usernameAttr, ldapAuthentication, (XMLStreamReader)reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!choiceFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.ADVANCED_FILTER, Element.USERNAME_FILTER));
        }
        if (addLdapCache != null) {
            this.correctCacheAddress(ldapAuthentication, addLdapCache);
            list.add(addLdapCache);
        }
    }

    private ModelNode parseLdapCache(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode addr = new ModelNode();
        ModelNode addCacheOp = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        String type = "by-search-time";
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    if ("by-access-time".equals(value) || "by-search-time".equals(value)) {
                        type = value;
                        continue block6;
                    }
                    throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                }
                case EVICTION_TIME: {
                    LdapCacheResourceDefinition.EVICTION_TIME.parseAndSetParameter(value, addCacheOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case CACHE_FAILURES: {
                    LdapCacheResourceDefinition.CACHE_FAILURES.parseAndSetParameter(value, addCacheOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case MAX_CACHE_SIZE: {
                    LdapCacheResourceDefinition.MAX_CACHE_SIZE.parseAndSetParameter(value, addCacheOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addCacheOp.get("address").add("cache", type);
        return addCacheOp;
    }

    private void correctCacheAddress(ModelNode parentAdd, ModelNode cacheAdd) {
        List addressList = cacheAdd.get("address").asPropertyList();
        ModelNode cacheAddress = parentAdd.get("address").clone();
        for (Property current : addressList) {
            cacheAddress.add(current.getName(), current.getValue().asString());
        }
        cacheAdd.get("address").set(cacheAddress);
    }

    private void addLegacyLocalAuthentication(ModelNode realmAddress, List<ModelNode> list) {
        ModelNode addr = realmAddress.clone().add("authentication", "local");
        ModelNode local = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        local.get("default-user").set("$local");
        list.add(local);
    }

    private void parseLocalAuthentication_1_3(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "local");
        ModelNode local = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(local);
        int count = reader.getAttributeCount();
        HashSet<Attribute> attributesFound = new HashSet<Attribute>(count);
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            if (attributesFound.contains(attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            attributesFound.add(attribute);
            switch (attribute) {
                case DEFAULT_USER: {
                    LocalAuthenticationResourceDefinition.DEFAULT_USER.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block4;
                }
                case ALLOWED_USERS: {
                    LocalAuthenticationResourceDefinition.ALLOWED_USERS.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseLocalAuthentication_2_1(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "local");
        ModelNode local = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(local);
        int count = reader.getAttributeCount();
        HashSet<Attribute> attributesFound = new HashSet<Attribute>(count);
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            if (attributesFound.contains(attribute)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            attributesFound.add(attribute);
            switch (attribute) {
                case DEFAULT_USER: {
                    LocalAuthenticationResourceDefinition.DEFAULT_USER.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block5;
                }
                case ALLOWED_USERS: {
                    LocalAuthenticationResourceDefinition.ALLOWED_USERS.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block5;
                }
                case SKIP_GROUP_LOADING: {
                    LocalAuthenticationResourceDefinition.SKIP_GROUP_LOADING.parseAndSetParameter(value, local, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parsePropertiesAuthentication_1_0(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "properties");
        ModelNode properties = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(properties);
        String path = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    PropertiesAuthenticationResourceDefinition.PATH.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block4;
                }
                case RELATIVE_TO: {
                    PropertiesAuthenticationResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        properties.get("plain-text").set(true);
    }

    private void parsePropertiesAuthentication_1_1(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authentication", "properties");
        ModelNode properties = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(properties);
        String path = null;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    PropertiesAuthenticationResourceDefinition.PATH.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block5;
                }
                case RELATIVE_TO: {
                    PropertiesAuthenticationResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block5;
                }
                case PLAIN_TEXT: {
                    PropertiesAuthenticationResourceDefinition.PLAIN_TEXT.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseUsersAuthentication(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode usersAddress = realmAddress.clone().add("authentication", "users");
        list.add(Util.getEmptyOperation((String)"add", (ModelNode)usersAddress));
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case USER: {
                    this.parseUser(reader, usersAddress, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseUser(XMLExtendedStreamReader reader, ModelNode usersAddress, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.USERNAME.getLocalName());
        String userName = reader.getAttributeValue(0);
        ModelNode userAddress = usersAddress.clone().add("user", userName);
        ModelNode user = Util.getEmptyOperation((String)"add", (ModelNode)userAddress);
        list.add(user);
        String password = null;
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PASSWORD: {
                    password = reader.getElementText();
                    UserResourceDefinition.PASSWORD.parseAndSetParameter(password, user, (XMLStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (password == null) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, EnumSet.of(Element.PASSWORD));
        }
    }

    private void parseTruststore(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").set(realmAddress).add("authentication", "truststore");
        switch (this.namespace) {
            case DOMAIN_1_0: 
            case DOMAIN_1_1: 
            case DOMAIN_1_2: {
                this.parseKeystore_1_0(reader, op);
                break;
            }
            case DOMAIN_1_3: 
            case DOMAIN_1_4: 
            case DOMAIN_1_5: 
            case DOMAIN_2_0: {
                this.parseKeystore_1_3(reader, op, false);
                break;
            }
            default: {
                this.parseKeystore_1_6_and_2_1(reader, op, false);
            }
        }
        list.add(op);
    }

    private void parseAuthorization_1_1(XMLExtendedStreamReader reader, ModelNode realmAdd, List<ModelNode> list) throws XMLStreamException {
        ModelNode realmAddress = realmAdd.get("address");
        boolean authzFound = false;
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (authzFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROPERTIES: {
                    this.parsePropertiesAuthorization(reader, realmAddress, list);
                    authzFound = true;
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuthorization_1_3(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        boolean authzFound = false;
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (authzFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROPERTIES: {
                    this.parsePropertiesAuthorization(reader, realmAddress, list);
                    authzFound = true;
                    continue block4;
                }
                case PLUG_IN: {
                    ModelNode parentAddress = realmAddress.clone().add("authorization");
                    this.parsePlugIn_Authorization(reader, parentAddress, list);
                    authzFound = true;
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseAuthorization_1_5_and_2_0(XMLExtendedStreamReader reader, ModelNode realmAdd, List<ModelNode> list) throws XMLStreamException {
        ModelNode realmAddress = realmAdd.get("address");
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAP_GROUPS_TO_ROLES: {
                    SecurityRealmResourceDefinition.MAP_GROUPS_TO_ROLES.parseAndSetParameter(value, realmAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean authzFound = false;
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (authzFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case PROPERTIES: {
                    this.parsePropertiesAuthorization(reader, realmAddress, list);
                    authzFound = true;
                    continue block9;
                }
                case PLUG_IN: {
                    ModelNode parentAddress = realmAddress.clone().add("authorization");
                    this.parsePlugIn_Authorization(reader, parentAddress, list);
                    authzFound = true;
                    continue block9;
                }
                case LDAP: {
                    this.parseLdapAuthorization_1_5(reader, realmAddress, list);
                    authzFound = true;
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseLdapAuthorization_1_5(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authorization", "ldap");
        ModelNode ldapAuthorization = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(ldapAuthorization);
        EnumSet<Attribute> required = EnumSet.of(Attribute.CONNECTION);
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            required.remove(attribute);
            switch (attribute) {
                case CONNECTION: {
                    LdapAuthorizationResourceDefinition.CONNECTION.parseAndSetParameter(value, ldapAuthorization, (XMLStreamReader)reader);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        HashSet<Element> foundElements = new HashSet<Element>();
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (!foundElements.add(element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case USERNAME_TO_DN: {
                    switch (this.namespace.getMajorVersion()) {
                        case 1: {
                            this.parseUsernameToDn_1_5(reader, addr, list);
                            continue block14;
                        }
                    }
                    this.parseUsernameToDn_2_0(reader, addr, list);
                    continue block14;
                }
                case GROUP_SEARCH: {
                    switch (this.namespace) {
                        case DOMAIN_1_5: 
                        case DOMAIN_1_6: {
                            this.parseGroupSearch_1_5(reader, addr, list);
                            continue block14;
                        }
                    }
                    this.parseGroupSearch_1_7_and_2_0(reader, addr, list);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseUsernameToDn_1_5(XMLExtendedStreamReader reader, ModelNode ldapAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode childAdd = new ModelNode();
        childAdd.get("operation").set("add");
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case FORCE: {
                    BaseLdapUserSearchResource.FORCE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean filterFound = false;
        ModelNode address = ldapAddress.clone().add("username-to-dn");
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (filterFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case USERNAME_IS_DN: {
                    filterFound = true;
                    this.parseUsernameIsDn(reader, address, childAdd);
                    continue block9;
                }
                case USERNAME_FILTER: {
                    filterFound = true;
                    this.parseUsernameFilter(reader, address, childAdd);
                    continue block9;
                }
                case ADVANCED_FILTER: {
                    filterFound = true;
                    this.parseAdvancedFilter(reader, address, childAdd);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!filterFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.USERNAME_IS_DN, Element.USERNAME_FILTER, Element.ADVANCED_FILTER));
        }
        list.add(childAdd);
    }

    private void parseUsernameToDn_2_0(XMLExtendedStreamReader reader, ModelNode ldapAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode childAdd = new ModelNode();
        childAdd.get("operation").set("add");
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case FORCE: {
                    BaseLdapUserSearchResource.FORCE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean filterFound = false;
        ModelNode cacheAdd = null;
        ModelNode address = ldapAddress.clone().add("username-to-dn");
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (filterFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case CACHE: {
                    if (cacheAdd != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    cacheAdd = this.parseLdapCache(reader);
                    continue block10;
                }
                case USERNAME_IS_DN: {
                    filterFound = true;
                    this.parseUsernameIsDn(reader, address, childAdd);
                    continue block10;
                }
                case USERNAME_FILTER: {
                    filterFound = true;
                    this.parseUsernameFilter(reader, address, childAdd);
                    continue block10;
                }
                case ADVANCED_FILTER: {
                    filterFound = true;
                    this.parseAdvancedFilter(reader, address, childAdd);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!filterFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.USERNAME_IS_DN, Element.USERNAME_FILTER, Element.ADVANCED_FILTER));
        }
        list.add(childAdd);
        if (cacheAdd != null) {
            this.correctCacheAddress(childAdd, cacheAdd);
            list.add(cacheAdd);
        }
    }

    private void parseUsernameIsDn(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("username-is-dn"));
    }

    private void parseUsernameFilter(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        boolean baseDnFound = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case BASE_DN: {
                    baseDnFound = true;
                    UserSearchResourceDefintion.BASE_DN.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case RECURSIVE: {
                    UserSearchResourceDefintion.RECURSIVE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case USER_DN_ATTRIBUTE: {
                    UserSearchResourceDefintion.USER_DN_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case ATTRIBUTE: {
                    UserSearchResourceDefintion.ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!baseDnFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.BASE_DN));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("username-filter"));
    }

    private void parseAdvancedFilter(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        boolean baseDnFound = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case BASE_DN: {
                    baseDnFound = true;
                    AdvancedUserSearchResourceDefintion.BASE_DN.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case RECURSIVE: {
                    AdvancedUserSearchResourceDefintion.RECURSIVE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case USER_DN_ATTRIBUTE: {
                    UserSearchResourceDefintion.USER_DN_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case FILTER: {
                    AdvancedUserSearchResourceDefintion.FILTER.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!baseDnFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.BASE_DN));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("advanced-filter"));
    }

    private void parseGroupSearch_1_5(XMLExtendedStreamReader reader, ModelNode ldapAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode childAdd = new ModelNode();
        childAdd.get("operation").set("add");
        int count = reader.getAttributeCount();
        block13: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case GROUP_NAME: {
                    BaseLdapGroupSearchResource.GROUP_NAME.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block13;
                }
                case ITERATIVE: {
                    BaseLdapGroupSearchResource.ITERATIVE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block13;
                }
                case GROUP_DN_ATTRIBUTE: {
                    BaseLdapGroupSearchResource.GROUP_DN_ATTRIBUTE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block13;
                }
                case GROUP_NAME_ATTRIBUTE: {
                    BaseLdapGroupSearchResource.GROUP_NAME_ATTRIBUTE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean filterFound = false;
        ModelNode address = ldapAddress.clone().add("group-search");
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (filterFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case GROUP_TO_PRINCIPAL: {
                    filterFound = true;
                    this.parseGroupToPrincipal(reader, address, childAdd);
                    continue block14;
                }
                case PRINCIPAL_TO_GROUP: {
                    filterFound = true;
                    switch (this.namespace) {
                        case DOMAIN_1_5: {
                            this.parsePrincipalToGroup_1_5(reader, address, childAdd);
                            continue block14;
                        }
                    }
                    this.parsePrincipalToGroup_1_6_and_2_1(reader, address, childAdd);
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!filterFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.GROUP_TO_PRINCIPAL, Element.PRINCIPAL_TO_GROUP));
        }
        list.add(childAdd);
    }

    private void parseGroupSearch_1_7_and_2_0(XMLExtendedStreamReader reader, ModelNode ldapAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode childAdd = new ModelNode();
        childAdd.get("operation").set("add");
        int count = reader.getAttributeCount();
        block17: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case GROUP_NAME: {
                    BaseLdapGroupSearchResource.GROUP_NAME.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block17;
                }
                case ITERATIVE: {
                    BaseLdapGroupSearchResource.ITERATIVE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block17;
                }
                case GROUP_DN_ATTRIBUTE: {
                    BaseLdapGroupSearchResource.GROUP_DN_ATTRIBUTE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block17;
                }
                case GROUP_NAME_ATTRIBUTE: {
                    BaseLdapGroupSearchResource.GROUP_NAME_ATTRIBUTE.parseAndSetParameter(value, childAdd, (XMLStreamReader)reader);
                    continue block17;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        boolean filterFound = false;
        ModelNode cacheAdd = null;
        ModelNode address = ldapAddress.clone().add("group-search");
        block18: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (filterFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            switch (element) {
                case CACHE: {
                    if (cacheAdd != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    cacheAdd = this.parseLdapCache(reader);
                    continue block18;
                }
                case GROUP_TO_PRINCIPAL: {
                    filterFound = true;
                    this.parseGroupToPrincipal(reader, address, childAdd);
                    continue block18;
                }
                case PRINCIPAL_TO_GROUP: {
                    filterFound = true;
                    switch (this.namespace) {
                        case DOMAIN_2_0: {
                            this.parsePrincipalToGroup_1_5(reader, address, childAdd);
                            continue block18;
                        }
                    }
                    switch (this.namespace.getMajorVersion()) {
                        case 2: {
                            this.parsePrincipalToGroup_1_6_and_2_1(reader, address, childAdd);
                            continue block18;
                        }
                    }
                    this.parsePrincipalToGroup_1_7_and_3_0(reader, address, childAdd);
                    continue block18;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!filterFound) {
            throw ParseUtils.missingOneOf((XMLExtendedStreamReader)reader, EnumSet.of(Element.GROUP_TO_PRINCIPAL, Element.PRINCIPAL_TO_GROUP));
        }
        list.add(childAdd);
        if (cacheAdd != null) {
            this.correctCacheAddress(childAdd, cacheAdd);
            list.add(cacheAdd);
        }
    }

    private void parseGroupToPrincipalAttributes_1_5_and_2_0(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean baseDnFound = false;
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case BASE_DN: {
                    baseDnFound = true;
                    GroupToPrincipalResourceDefinition.BASE_DN.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                case RECURSIVE: {
                    GroupToPrincipalResourceDefinition.RECURSIVE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                case SEARCH_BY: {
                    GroupToPrincipalResourceDefinition.SEARCH_BY.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!baseDnFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.BASE_DN));
        }
    }

    private void parseGroupToPrincipalAttributes_1_6_and_3_0(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean baseDnFound = false;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case BASE_DN: {
                    baseDnFound = true;
                    GroupToPrincipalResourceDefinition.BASE_DN.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case RECURSIVE: {
                    GroupToPrincipalResourceDefinition.RECURSIVE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case SEARCH_BY: {
                    GroupToPrincipalResourceDefinition.SEARCH_BY.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                case PREFER_ORIGINAL_CONNECTION: {
                    GroupToPrincipalResourceDefinition.PREFER_ORIGINAL_CONNECTION.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!baseDnFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.BASE_DN));
        }
    }

    private void parseGroupToPrincipal(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        block0 : switch (this.namespace) {
            case DOMAIN_1_5: {
                this.parseGroupToPrincipalAttributes_1_5_and_2_0(reader, addOp);
                break;
            }
            default: {
                switch (this.namespace.getMajorVersion()) {
                    case 2: {
                        this.parseGroupToPrincipalAttributes_1_5_and_2_0(reader, addOp);
                        break block0;
                    }
                }
                this.parseGroupToPrincipalAttributes_1_6_and_3_0(reader, addOp);
            }
        }
        boolean elementFound = false;
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            if (elementFound) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            elementFound = true;
            switch (element) {
                case MEMBERSHIP_FILTER: {
                    this.parseMembershipFilter(reader, addOp);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        addOp.get("address").set(parentAddress.clone().add("group-to-principal"));
    }

    private void parseMembershipFilter(XMLExtendedStreamReader reader, ModelNode addOp) throws XMLStreamException {
        boolean principalAttribute = false;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PRINCIPAL_ATTRIBUTE: {
                    principalAttribute = true;
                    GroupToPrincipalResourceDefinition.PRINCIPAL_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!principalAttribute) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PRINCIPAL_ATTRIBUTE));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parsePrincipalToGroup_1_5(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case GROUP_ATTRIBUTE: {
                    PrincipalToGroupResourceDefinition.GROUP_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("principal-to-group"));
    }

    private void parsePrincipalToGroup_1_6_and_2_1(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case GROUP_ATTRIBUTE: {
                    PrincipalToGroupResourceDefinition.GROUP_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block4;
                }
                case PREFER_ORIGINAL_CONNECTION: {
                    PrincipalToGroupResourceDefinition.PREFER_ORIGINAL_CONNECTION.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("principal-to-group"));
    }

    private void parsePrincipalToGroup_1_7_and_3_0(XMLExtendedStreamReader reader, ModelNode parentAddress, ModelNode addOp) throws XMLStreamException {
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case GROUP_ATTRIBUTE: {
                    PrincipalToGroupResourceDefinition.GROUP_ATTRIBUTE.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                case PREFER_ORIGINAL_CONNECTION: {
                    PrincipalToGroupResourceDefinition.PREFER_ORIGINAL_CONNECTION.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                case SKIP_MISSING_GROUPS: {
                    PrincipalToGroupResourceDefinition.SKIP_MISSING_GROUPS.parseAndSetParameter(value, addOp, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        addOp.get("address").set(parentAddress.clone().add("principal-to-group"));
    }

    private void parsePropertiesAuthorization(XMLExtendedStreamReader reader, ModelNode realmAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = realmAddress.clone().add("authorization", "properties");
        ModelNode properties = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(properties);
        String path = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    path = value;
                    PropertiesAuthorizationResourceDefinition.PATH.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block4;
                }
                case RELATIVE_TO: {
                    PropertiesAuthorizationResourceDefinition.RELATIVE_TO.parseAndSetParameter(value, properties, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parsePlugIn_Authentication(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = parentAddress.clone().add("plug-in");
        ModelNode plugIn = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(plugIn);
        boolean nameFound = false;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    PlugInAuthenticationResourceDefinition.NAME.parseAndSetParameter(value, plugIn, (XMLStreamReader)reader);
                    nameFound = true;
                    continue block10;
                }
                case MECHANISM: {
                    PlugInAuthenticationResourceDefinition.MECHANISM.parseAndSetParameter(value, plugIn, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!nameFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    block12: while (reader.hasNext() && reader.nextTag() != 2) {
                        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
                        Element propertyElement = Element.forName((String)reader.getLocalName());
                        switch (propertyElement) {
                            case PROPERTY: {
                                this.parseProperty(reader, addr, list);
                                continue block12;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parsePlugIn_Authorization(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode addr = parentAddress.clone().add("plug-in");
        ModelNode plugIn = Util.getEmptyOperation((String)"add", (ModelNode)addr);
        list.add(plugIn);
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
        String plugInName = reader.getAttributeValue(0);
        plugIn.get("name").set(plugInName);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
            Element element = Element.forName((String)reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    block7: while (reader.hasNext() && reader.nextTag() != 2) {
                        ParseUtils.requireNamespace((XMLExtendedStreamReader)reader, (Namespace)this.namespace);
                        Element propertyElement = Element.forName((String)reader.getLocalName());
                        switch (propertyElement) {
                            case PROPERTY: {
                                this.parseProperty(reader, addr, list);
                                continue block7;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseProperty(XMLExtendedStreamReader reader, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        ModelNode add = new ModelNode();
        add.get("operation").set("add");
        list.add(add);
        boolean addressFound = false;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (!ParseUtils.isNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i)) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
            }
            Attribute attribute = Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    add.get("address").set(parentAddress).add("property", value);
                    addressFound = true;
                    continue block4;
                }
                case VALUE: {
                    PropertyResourceDefinition.VALUE.parseAndSetParameter(value, add, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!addressFound) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    @Override
    public void writeManagement(XMLExtendedStreamWriter writer, ModelNode management, boolean allowInterfaces) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }
}

