/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.iiop;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJBMetaData;
import javax.ejb.HomeHandle;
import javax.management.MBeanException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.component.entity.EntityBeanComponent;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.ejb3.iiop.LocalIIOPInvoker;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.iiop.HandleImplIIOP;
import org.jboss.iiop.csiv2.SASCurrent;
import org.jboss.iiop.tm.InboundTransactionCurrent;
import org.jboss.invocation.InterceptorContext;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.InputStreamByteInput;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SimplePrincipal;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.PortableServer.Current;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.wildfly.iiop.openjdk.rmi.RmiIdlUtil;
import org.wildfly.iiop.openjdk.rmi.marshal.strategy.SkeletonStrategy;
import org.wildfly.security.manager.WildFlySecurityManager;

public class EjbCorbaServant
extends Servant
implements InvokeHandler,
LocalIIOPInvoker {
    private final ComponentView componentView;
    private final ORB orb;
    private final Current poaCurrent;
    private final Map<String, SkeletonStrategy> methodInvokerMap;
    private final String[] repositoryIds;
    private final InterfaceDef interfaceDef;
    private final String securityDomain;
    private final boolean home;
    private volatile HomeHandle homeHandle = null;
    private volatile EJBMetaData ejbMetaData;
    private final SASCurrent sasCurrent;
    private final InboundTransactionCurrent inboundTxCurrent;
    private final TransactionManager transactionManager;
    private final MarshallerFactory factory;
    private final MarshallingConfiguration configuration;
    private final ClassLoader classLoader;

    public EjbCorbaServant(Current poaCurrent, Map<String, SkeletonStrategy> methodInvokerMap, String[] repositoryIds, InterfaceDef interfaceDef, ORB orb, ComponentView componentView, MarshallerFactory factory, MarshallingConfiguration configuration, TransactionManager transactionManager, ClassLoader classLoader, boolean home, String securityDomain) {
        InboundTransactionCurrent inboundTxCurrent;
        SASCurrent sasCurrent;
        this.poaCurrent = poaCurrent;
        this.methodInvokerMap = methodInvokerMap;
        this.repositoryIds = repositoryIds;
        this.interfaceDef = interfaceDef;
        this.orb = orb;
        this.componentView = componentView;
        this.factory = factory;
        this.configuration = configuration;
        this.transactionManager = transactionManager;
        this.classLoader = classLoader;
        this.home = home;
        this.securityDomain = securityDomain;
        try {
            sasCurrent = (SASCurrent)this.orb.resolve_initial_references("SASCurrent");
        }
        catch (InvalidName invalidName) {
            sasCurrent = null;
        }
        this.sasCurrent = sasCurrent;
        try {
            inboundTxCurrent = (InboundTransactionCurrent)this.orb.resolve_initial_references("InboundTransactionCurrent");
        }
        catch (InvalidName invalidName) {
            inboundTxCurrent = null;
        }
        this.inboundTxCurrent = inboundTxCurrent;
    }

    public Object _get_interface_def() {
        if (this.interfaceDef != null) {
            return this.interfaceDef;
        }
        return super._get_interface_def();
    }

    public String[] _all_interfaces(POA poa, byte[] objectId) {
        return (String[])this.repositoryIds.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.CORBA.portable.OutputStream _invoke(String opName, org.omg.CORBA.portable.InputStream in, ResponseHandler handler) {
        EjbLogger.ROOT_LOGGER.tracef("EJBObject invocation: %s", opName);
        SkeletonStrategy op = this.methodInvokerMap.get(opName);
        if (op == null) {
            EjbLogger.ROOT_LOGGER.debugf("Unable to find opname '%s' valid operations:%s", opName, this.methodInvokerMap.keySet());
            throw new BAD_OPERATION(opName);
        }
        NamespaceContextSelector selector = this.componentView.getComponent().getNamespaceContextSelector();
        ClassLoader oldCl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)selector);
        try {
            OutputStream out;
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            SecurityContext sc = null;
            try {
                java.lang.Object retVal;
                block35: {
                    if (!this.home && opName.equals("_get_handle")) {
                        retVal = new HandleImplIIOP(this.orb.object_to_string(this._this_object()));
                    } else if (this.home && opName.equals("_get_homeHandle")) {
                        retVal = this.homeHandle;
                    } else if (this.home && opName.equals("_get_EJBMetaData")) {
                        retVal = this.ejbMetaData;
                    } else {
                        Transaction tx = null;
                        if (this.inboundTxCurrent != null) {
                            tx = this.inboundTxCurrent.getCurrentTransaction();
                        }
                        if (tx != null) {
                            this.transactionManager.resume(tx);
                        }
                        try {
                            SimplePrincipal principal = null;
                            java.lang.Object credential = null;
                            if (this.sasCurrent != null) {
                                byte[] incomingName = this.sasCurrent.get_incoming_principal_name();
                                if (incomingName != null && incomingName.length > 0) {
                                    if (incomingName.length > 0) {
                                        String name = new String(incomingName, StandardCharsets.UTF_8);
                                        int domainIndex = name.indexOf(64);
                                        if (domainIndex > 0) {
                                            name = name.substring(0, domainIndex);
                                        }
                                        principal = new SimplePrincipal(name);
                                        credential = this.sasCurrent;
                                    }
                                } else {
                                    byte[] username = this.sasCurrent.get_incoming_username();
                                    byte[] incomingPassword = this.sasCurrent.get_incoming_password();
                                    if (username.length > 0) {
                                        String name = new String(username, StandardCharsets.UTF_8);
                                        int domainIndex = name.indexOf(64);
                                        if (domainIndex > 0) {
                                            name = name.substring(0, domainIndex);
                                        }
                                        principal = new SimplePrincipal(name);
                                        credential = new String(incomingPassword, StandardCharsets.UTF_8).toCharArray();
                                    }
                                }
                                if (this.securityDomain != null) {
                                    sc = SecurityContextFactory.createSecurityContext((String)this.securityDomain);
                                    sc.getUtil().createSubjectInfo(principal, credential, null);
                                }
                            }
                            java.lang.Object[] params = op.readParams((org.omg.CORBA_2_3.portable.InputStream)in);
                            if (!this.home && opName.equals("isIdentical") && params.length == 1) {
                                java.lang.Object val = params[0];
                                retVal = val instanceof Object ? Boolean.valueOf(this.handleIsIdentical((Object)val)) : Boolean.valueOf(false);
                                break block35;
                            }
                            if (sc != null) {
                                EjbCorbaServant.setSecurityContextOnAssociation(sc);
                            }
                            try {
                                InterceptorContext interceptorContext = new InterceptorContext();
                                if (sc != null) {
                                    interceptorContext.putPrivateData(SecurityContext.class, (java.lang.Object)sc);
                                }
                                this.prepareInterceptorContext(op, params, interceptorContext);
                                retVal = this.componentView.invoke(interceptorContext);
                            }
                            finally {
                                if (sc != null) {
                                    EjbCorbaServant.clearSecurityContextOnAssociation();
                                }
                            }
                        }
                        finally {
                            if (tx != null && this.transactionManager.getStatus() != 6) {
                                this.transactionManager.suspend();
                            }
                        }
                    }
                }
                out = (OutputStream)handler.createReply();
                if (op.isNonVoid()) {
                    op.writeRetval(out, retVal);
                }
            }
            catch (Exception e) {
                EjbLogger.ROOT_LOGGER.trace("Exception in EJBObject invocation", e);
                if (e instanceof MBeanException) {
                    e = ((MBeanException)e).getTargetException();
                }
                RmiIdlUtil.rethrowIfCorbaSystemException((Exception)e);
                out = (OutputStream)handler.createExceptionReply();
                op.writeException(out, e);
            }
            OutputStream outputStream = out;
            return outputStream;
        }
        finally {
            NamespaceContextSelector.popCurrentSelector();
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldCl);
        }
    }

    private void prepareInterceptorContext(SkeletonStrategy op, java.lang.Object[] params, InterceptorContext interceptorContext) throws IOException, ClassNotFoundException {
        if (!this.home) {
            if (this.componentView.getComponent() instanceof StatefulSessionComponent) {
                SessionID sessionID = (SessionID)this.unmarshalIdentifier();
                interceptorContext.putPrivateData(SessionID.class, (java.lang.Object)sessionID);
            } else if (this.componentView.getComponent() instanceof EntityBeanComponent) {
                java.lang.Object pk = this.unmarshalIdentifier();
                interceptorContext.putPrivateData(EntityBeanComponent.PRIMARY_KEY_CONTEXT_KEY, pk);
            }
        }
        interceptorContext.setContextData(new HashMap());
        interceptorContext.setParameters(params);
        interceptorContext.setMethod(op.getMethod());
        interceptorContext.putPrivateData(ComponentView.class, (java.lang.Object)this.componentView);
        interceptorContext.putPrivateData(Component.class, (java.lang.Object)this.componentView.getComponent());
    }

    private boolean handleIsIdentical(Object val) throws RemoteException {
        return this.orb.object_to_string(this._this_object()).equals(this.orb.object_to_string(val));
    }

    private java.lang.Object unmarshalIdentifier() throws IOException, ClassNotFoundException {
        java.lang.Object id;
        try {
            byte[] idData = this.poaCurrent.get_object_id();
            Unmarshaller unmarshaller = this.factory.createUnmarshaller(this.configuration);
            unmarshaller.start((ByteInput)new InputStreamByteInput((InputStream)new ByteArrayInputStream(idData)));
            id = unmarshaller.readObject();
            unmarshaller.finish();
        }
        catch (NoContext noContext) {
            throw new RuntimeException(noContext);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public java.lang.Object invoke(String opName, java.lang.Object[] arguments, Transaction tx, Principal identity, java.lang.Object credential) throws Exception {
        EjbLogger.ROOT_LOGGER.tracef("EJBObject local invocation: %s", opName);
        SkeletonStrategy op = this.methodInvokerMap.get(opName);
        if (op == null) {
            throw new BAD_OPERATION(opName);
        }
        if (tx != null) {
            this.transactionManager.resume(tx);
        }
        try {
            InterceptorContext interceptorContext = new InterceptorContext();
            this.prepareInterceptorContext(op, arguments, interceptorContext);
            java.lang.Object object = this.componentView.invoke(interceptorContext);
            return object;
        }
        finally {
            if (tx != null && this.transactionManager.getStatus() != 6) {
                this.transactionManager.suspend();
            }
        }
    }

    public void setHomeHandle(HomeHandle homeHandle) {
        this.homeHandle = homeHandle;
    }

    public void setEjbMetaData(EJBMetaData ejbMetaData) {
        this.ejbMetaData = ejbMetaData;
    }

    private static void setSecurityContextOnAssociation(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    private static void clearSecurityContextOnAssociation() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.clearSecurityContext();
                return null;
            }
        });
    }
}

