/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.common.injection.finders;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.jboss.ws.common.Messages;

final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static void assertNoPrimitiveParameters(Method method, Class<? extends Annotation> annotation) {
        for (Class<?> type : method.getParameterTypes()) {
            if (!type.isPrimitive()) continue;
            throw annotation == null ? Messages.MESSAGES.methodCannotDeclarePrimitiveParameters(method) : Messages.MESSAGES.methodCannotDeclarePrimitiveParameters2(method, annotation);
        }
    }

    public static void assertNoPrimitiveParameters(Method method) {
        ReflectionUtils.assertNoPrimitiveParameters(method, null);
    }

    public static void assertNotPrimitiveType(Field field, Class<? extends Annotation> annotation) {
        if (field.getType().isPrimitive()) {
            throw annotation == null ? Messages.MESSAGES.fieldCannotBeOfPrimitiveOrVoidType(field) : Messages.MESSAGES.fieldCannotBeOfPrimitiveOrVoidType2(field, annotation);
        }
    }

    public static void assertNotPrimitiveType(Field field) {
        ReflectionUtils.assertNotPrimitiveType(field, null);
    }

    public static void assertNoParameters(Method method, Class<? extends Annotation> annotation) {
        if (method.getParameterTypes().length != 0) {
            throw annotation == null ? Messages.MESSAGES.methodHasToHaveNoParameters(method) : Messages.MESSAGES.methodHasToHaveNoParameters2(method, annotation);
        }
    }

    public static void assertNoParameters(Method method) {
        ReflectionUtils.assertNoParameters(method, null);
    }

    public static void assertVoidReturnType(Method method, Class<? extends Annotation> annotation) {
        if (!method.getReturnType().equals(Void.class) && !method.getReturnType().equals(Void.TYPE)) {
            throw annotation == null ? Messages.MESSAGES.methodHasToReturnVoid(method) : Messages.MESSAGES.methodHasToReturnVoid2(method, annotation);
        }
    }

    public static void assertVoidReturnType(Method method) {
        ReflectionUtils.assertVoidReturnType(method, null);
    }

    public static void assertNotVoidType(Field field, Class<? extends Annotation> annotation) {
        if (field.getClass().equals(Void.class) && field.getClass().equals(Void.TYPE)) {
            throw annotation == null ? Messages.MESSAGES.fieldCannotBeOfPrimitiveOrVoidType(field) : Messages.MESSAGES.fieldCannotBeOfPrimitiveOrVoidType2(field, annotation);
        }
    }

    public static void assertNotVoidType(Field field) {
        ReflectionUtils.assertNotVoidType(field, null);
    }

    public static void assertNoCheckedExceptionsAreThrown(Method method, Class<? extends Annotation> annotation) {
        Class<?>[] declaredExceptions = method.getExceptionTypes();
        for (int i = 0; i < declaredExceptions.length; ++i) {
            Class<RuntimeException> exception = declaredExceptions[i];
            if (exception.isAssignableFrom(RuntimeException.class)) continue;
            throw annotation == null ? Messages.MESSAGES.methodCannotThrowCheckedException(method) : Messages.MESSAGES.methodCannotThrowCheckedException2(method, annotation);
        }
    }

    public static void assertNoCheckedExceptionsAreThrown(Method method) {
        ReflectionUtils.assertNoCheckedExceptionsAreThrown(method, null);
    }

    public static void assertNotStatic(Method method, Class<? extends Annotation> annotation) {
        if (Modifier.isStatic(method.getModifiers())) {
            throw annotation == null ? Messages.MESSAGES.methodCannotBeStatic(method) : Messages.MESSAGES.methodCannotBeStatic2(method, annotation);
        }
    }

    public static void assertNotStatic(Method method) {
        ReflectionUtils.assertNotStatic(method, null);
    }

    public static void assertNotStatic(Field field, Class<? extends Annotation> annotation) {
        if (Modifier.isStatic(field.getModifiers())) {
            throw annotation == null ? Messages.MESSAGES.fieldCannotBeStaticOrFinal(field) : Messages.MESSAGES.fieldCannotBeStaticOrFinal2(field, annotation);
        }
    }

    public static void assertNotStatic(Field field) {
        ReflectionUtils.assertNotStatic(field, null);
    }

    public static void assertNotFinal(Field field, Class<? extends Annotation> annotation) {
        if (Modifier.isFinal(field.getModifiers())) {
            throw annotation == null ? Messages.MESSAGES.fieldCannotBeStaticOrFinal(field) : Messages.MESSAGES.fieldCannotBeStaticOrFinal2(field, annotation);
        }
    }

    public static void assertNotFinal(Field field) {
        ReflectionUtils.assertNotFinal(field, null);
    }

    public static void assertOneParameter(Method method, Class<? extends Annotation> annotation) {
        if (method.getParameterTypes().length != 1) {
            throw annotation == null ? Messages.MESSAGES.methodHasToDeclareExactlyOneParameter(method) : Messages.MESSAGES.methodHasToDeclareExactlyOneParameter2(method, annotation);
        }
    }

    public static void assertOneParameter(Method method) {
        ReflectionUtils.assertOneParameter(method, null);
    }

    public static void assertValidSetterName(Method method, Class<? extends Annotation> annotation) {
        boolean isUpperCasedPropertyName;
        String methodName = method.getName();
        boolean correctMethodNameLength = methodName.length() > 3;
        boolean isSetterMethodName = methodName.startsWith("set");
        boolean bl = isUpperCasedPropertyName = correctMethodNameLength ? Character.isUpperCase(methodName.charAt(3)) : false;
        if (!(correctMethodNameLength && isSetterMethodName && isUpperCasedPropertyName)) {
            throw annotation == null ? Messages.MESSAGES.methodDoesNotRespectJavaBeanSetterMethodName(method) : Messages.MESSAGES.methodDoesNotRespectJavaBeanSetterMethodName2(method, annotation);
        }
    }

    public static void assertValidSetterName(Method method) {
        ReflectionUtils.assertValidSetterName(method, null);
    }

    public static void assertOnlyOneMethod(Collection<Method> methods, Class<? extends Annotation> annotation) {
        if (methods.size() > 1) {
            throw annotation == null ? Messages.MESSAGES.onlyOneMethodCanExist() : Messages.MESSAGES.onlyOneMethodCanExist2(annotation);
        }
    }

    public static void assertOnlyOneMethod(Collection<Method> methods) {
        ReflectionUtils.assertOnlyOneMethod(methods, null);
    }
}

