/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;

public class SearcherTaxonomyManager
extends ReferenceManager<SearcherAndTaxonomy> {
    private final SearcherFactory searcherFactory;
    private final long taxoEpoch;
    private final DirectoryTaxonomyWriter taxoWriter;

    public SearcherTaxonomyManager(IndexWriter writer, boolean applyAllDeletes, SearcherFactory searcherFactory, DirectoryTaxonomyWriter taxoWriter) throws IOException {
        if (searcherFactory == null) {
            searcherFactory = new SearcherFactory();
        }
        this.searcherFactory = searcherFactory;
        this.taxoWriter = taxoWriter;
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(taxoWriter);
        this.current = new SearcherAndTaxonomy(SearcherManager.getSearcher((SearcherFactory)searcherFactory, (IndexReader)DirectoryReader.open((IndexWriter)writer, (boolean)applyAllDeletes)), taxoReader);
        this.taxoEpoch = taxoWriter.getTaxonomyEpoch();
    }

    public SearcherTaxonomyManager(Directory indexDir, Directory taxoDir, SearcherFactory searcherFactory) throws IOException {
        if (searcherFactory == null) {
            searcherFactory = new SearcherFactory();
        }
        this.searcherFactory = searcherFactory;
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(taxoDir);
        this.current = new SearcherAndTaxonomy(SearcherManager.getSearcher((SearcherFactory)searcherFactory, (IndexReader)DirectoryReader.open((Directory)indexDir)), taxoReader);
        this.taxoWriter = null;
        this.taxoEpoch = -1L;
    }

    protected void decRef(SearcherAndTaxonomy ref) throws IOException {
        ref.searcher.getIndexReader().decRef();
        ref.taxonomyReader.decRef();
    }

    protected boolean tryIncRef(SearcherAndTaxonomy ref) throws IOException {
        if (ref.searcher.getIndexReader().tryIncRef()) {
            if (ref.taxonomyReader.tryIncRef()) {
                return true;
            }
            ref.searcher.getIndexReader().decRef();
        }
        return false;
    }

    protected SearcherAndTaxonomy refreshIfNeeded(SearcherAndTaxonomy ref) throws IOException {
        IndexReader r = ref.searcher.getIndexReader();
        DirectoryReader newReader = DirectoryReader.openIfChanged((DirectoryReader)((DirectoryReader)r));
        if (newReader == null) {
            return null;
        }
        DirectoryTaxonomyReader tr = TaxonomyReader.openIfChanged(ref.taxonomyReader);
        if (tr == null) {
            ref.taxonomyReader.incRef();
            tr = ref.taxonomyReader;
        } else if (this.taxoWriter != null && this.taxoWriter.getTaxonomyEpoch() != this.taxoEpoch) {
            IOUtils.close((Closeable[])new Closeable[]{newReader, tr});
            throw new IllegalStateException("DirectoryTaxonomyWriter.replaceTaxonomy was called, which is not allowed when using SearcherTaxonomyManager");
        }
        return new SearcherAndTaxonomy(SearcherManager.getSearcher((SearcherFactory)this.searcherFactory, (IndexReader)newReader), tr);
    }

    protected int getRefCount(SearcherAndTaxonomy reference) {
        return reference.searcher.getIndexReader().getRefCount();
    }

    public static class SearcherAndTaxonomy {
        public final IndexSearcher searcher;
        public final DirectoryTaxonomyReader taxonomyReader;

        public SearcherAndTaxonomy(IndexSearcher searcher, DirectoryTaxonomyReader taxonomyReader) {
            this.searcher = searcher;
            this.taxonomyReader = taxonomyReader;
        }
    }
}

