/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb;

import java.util.LinkedList;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.jacorb.JacORBSubsystemDefinitions;
import org.jboss.as.jacorb.logging.JacORBLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class TransformUtils {
    private TransformUtils() {
    }

    static List<String> checkLegacyModel(ModelNode model, boolean failOnErrors) throws OperationFailedException {
        LinkedList<String> propertiesToReject = new LinkedList<String>();
        for (AttributeDefinition attributeDefinition : JacORBSubsystemDefinitions.ON_OFF_ATTRIBUTES_TO_REJECT) {
            if (!model.hasDefined(attributeDefinition.getName()) || !model.get(attributeDefinition.getName()).equals(JacORBSubsystemDefinitions.DEFAULT_ENABLED_PROPERTY)) continue;
            propertiesToReject.add(attributeDefinition.getName());
        }
        for (AttributeDefinition attributeDefinition : JacORBSubsystemDefinitions.ATTRIBUTES_TO_REJECT) {
            if (!model.hasDefined(attributeDefinition.getName())) continue;
            propertiesToReject.add(attributeDefinition.getName());
        }
        if (!propertiesToReject.isEmpty()) {
            if (failOnErrors) {
                throw JacORBLogger.ROOT_LOGGER.cannotEmulateProperties(propertiesToReject);
            }
            JacORBLogger.ROOT_LOGGER.cannotEmulatePropertiesWarning(propertiesToReject);
        }
        return propertiesToReject;
    }

    static ModelNode transformModel(ModelNode legacyModel) {
        ModelNode model = new ModelNode();
        for (Property property : legacyModel.asPropertyList()) {
            ModelNode value;
            String name = property.getName();
            ModelNode legacyValue = property.getValue();
            if (!legacyModel.isDefined()) continue;
            switch (name) {
                case "giop-minor-version": {
                    name = "giop-version";
                    value = new ModelNode("1." + legacyValue);
                    break;
                }
                case "transactions": {
                    if (legacyValue.asString().equals("on")) {
                        value = new ModelNode("full");
                        break;
                    }
                    if (legacyValue.asString().equals("off")) {
                        value = new ModelNode("none");
                        break;
                    }
                    value = legacyValue;
                    break;
                }
                case "security": {
                    if (legacyValue.asString().equals("off")) {
                        value = new ModelNode("none");
                        break;
                    }
                    value = legacyValue;
                    break;
                }
                case "support-ssl": 
                case "add-component-via-interceptor": 
                case "export-corbaloc": {
                    if (legacyValue.asString().equals("on")) {
                        value = new ModelNode(true);
                        break;
                    }
                    value = new ModelNode(false);
                    break;
                }
                default: {
                    value = legacyValue;
                }
            }
            if (value.equals((Object)"off")) continue;
            model.get(name).set(value);
        }
        return model;
    }
}

