/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.configuration;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.http.HttpDestinationFactory;
import org.apache.cxf.transport.servlet.ServletDestinationFactory;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.cxf.ws.rm.RMManager;
import org.jboss.ws.api.binding.BindingCustomization;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.config.SOAPAddressRewriteMetadata;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.stack.cxf.Messages;
import org.jboss.wsf.stack.cxf.client.configuration.BeanCustomizer;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSNonSpringBusFactory;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSNonSpringConfigurer;
import org.jboss.wsf.stack.cxf.configuration.BusHolder;
import org.jboss.wsf.stack.cxf.configuration.SecurityActions;
import org.jboss.wsf.stack.cxf.configuration.ServerBeanCustomizer;
import org.jboss.wsf.stack.cxf.deployment.EndpointImpl;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.metadata.services.DDBeans;
import org.jboss.wsf.stack.cxf.metadata.services.DDEndpoint;

public class NonSpringBusHolder
extends BusHolder {
    private boolean configured = false;
    protected DDBeans metadata;
    protected List<EndpointImpl> endpoints = new LinkedList<EndpointImpl>();

    public NonSpringBusHolder(DDBeans metadata) {
        this.metadata = metadata;
        this.bus = new JBossWSNonSpringBusFactory().createBus();
        this.bus.setExtension((Object)new ServletDestinationFactory(), HttpDestinationFactory.class);
    }

    @Override
    public void configure(ResourceResolver resolver, Configurer configurer, JBossWebservicesMetaData wsmd, Deployment dep) {
        if (this.configured) {
            throw Messages.MESSAGES.busAlreadyConfigured((Object)this.bus);
        }
        super.configure(resolver, configurer, wsmd, dep);
        for (DDEndpoint dde : this.metadata.getEndpoints()) {
            EndpointImpl endpoint = new EndpointImpl(this.bus, NonSpringBusHolder.newInstance(dde.getImplementor()));
            if (dde.getInvoker() != null) {
                endpoint.setInvoker((Invoker)NonSpringBusHolder.newInstance(dde.getInvoker()));
            }
            endpoint.setAddress(dde.getAddress());
            endpoint.setEndpointName(dde.getPortName());
            endpoint.setServiceName(dde.getServiceName());
            endpoint.setWsdlLocation(dde.getWsdlLocation());
            NonSpringBusHolder.setHandlers(endpoint, dde);
            if (dde.getProperties() != null) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.putAll(dde.getProperties());
                endpoint.setProperties(props);
            }
            if (dde.isAddressingEnabled()) {
                WSAddressingFeature addressingFeature = new WSAddressingFeature();
                addressingFeature.setAddressingRequired(dde.isAddressingRequired());
                addressingFeature.setResponses(dde.getAddressingResponses());
                endpoint.getFeatures().add(addressingFeature);
            }
            endpoint.setPublishedEndpointUrl(dde.getPublishedEndpointUrl());
            endpoint.setSOAPAddressRewriteMetadata((SOAPAddressRewriteMetadata)dep.getAttachment(SOAPAddressRewriteMetadata.class));
            endpoint.publish();
            this.endpoints.add(endpoint);
            if (!dde.isMtomEnabled()) continue;
            SOAPBinding binding = (SOAPBinding)endpoint.getBinding();
            binding.setMTOMEnabled(true);
        }
        this.configured = true;
    }

    private static void setHandlers(EndpointImpl endpoint, DDEndpoint dde) {
        List<String> handlers = dde.getHandlers();
        if (handlers != null && !handlers.isEmpty()) {
            LinkedList<Handler> handlerInstances = new LinkedList<Handler>();
            for (String handler : handlers) {
                handlerInstances.add((Handler)NonSpringBusHolder.newInstance(handler));
            }
            endpoint.setHandlers(handlerInstances);
        }
    }

    @Override
    public void close() {
        RMManager rmManager = (RMManager)this.bus.getExtension(RMManager.class);
        if (rmManager != null) {
            rmManager.shutdown();
        }
        for (EndpointImpl endpoint : this.endpoints) {
            if (!endpoint.isPublished()) continue;
            endpoint.stop();
        }
        this.endpoints.clear();
        super.close();
    }

    private static Object newInstance(String className) {
        try {
            Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Configurer createServerConfigurer(BindingCustomization customization, WSDLFilePublisher wsdlPublisher, ArchiveDeployment dep) {
        ServerBeanCustomizer customizer = new ServerBeanCustomizer();
        customizer.setBindingCustomization(customization);
        customizer.setWsdlPublisher(wsdlPublisher);
        customizer.setDeployment(dep);
        return new JBossWSNonSpringConfigurer((BeanCustomizer)customizer);
    }
}

