/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.configuration;

import java.util.List;
import java.util.Locale;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.jboss.ws.api.util.ServiceLoader;
import org.jboss.ws.common.configuration.BasicConfigResolver;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.config.CommonConfig;
import org.jboss.wsf.spi.metadata.config.EndpointConfig;
import org.jboss.wsf.spi.security.JASPIAuthenticationProvider;
import org.jboss.wsf.stack.cxf.JBossWSInvoker;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.client.configuration.BeanCustomizer;
import org.jboss.wsf.stack.cxf.deployment.EndpointImpl;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.security.authentication.AuthenticationMgrSubjectCreatingInterceptor;
import org.jboss.wsf.stack.cxf.transport.JBossWSDestinationRegistryImpl;

public class ServerBeanCustomizer
extends BeanCustomizer {
    private WSDLFilePublisher wsdlPublisher;
    private ArchiveDeployment dep;

    public void customize(Object beanInstance) {
        DestinationRegistry oldRegistry;
        ServerFactoryBean factory;
        if (beanInstance instanceof EndpointImpl) {
            this.configureEndpoint((EndpointImpl)((Object)beanInstance));
        }
        if (beanInstance instanceof ServerFactoryBean) {
            List depEndpoints;
            factory = (ServerFactoryBean)beanInstance;
            if (factory.getInvoker() instanceof JBossWSInvoker) {
                ((JBossWSInvoker)factory.getInvoker()).setTargetBean(factory.getServiceBean());
            }
            if ((depEndpoints = this.dep.getService().getEndpoints()) != null) {
                String targetBeanName = factory.getServiceBean().getClass().getName();
                for (Endpoint depEndpoint : depEndpoints) {
                    if (!depEndpoint.getTargetBeanClass().getName().equals(targetBeanName)) continue;
                    depEndpoint.addAttachment(ServerFactoryBean.class, (Object)factory);
                }
            }
        }
        if (beanInstance instanceof HTTPTransportFactory && !((oldRegistry = (factory = (HTTPTransportFactory)beanInstance).getRegistry()) instanceof JBossWSDestinationRegistryImpl)) {
            factory.setRegistry((DestinationRegistry)new JBossWSDestinationRegistryImpl());
        }
        super.customize(beanInstance);
    }

    protected void configureEndpoint(EndpointImpl endpoint) {
        if (this.wsdlPublisher != null) {
            endpoint.setWsdlPublisher(this.wsdlPublisher);
        }
        if (!endpoint.isPublished()) {
            boolean isHttpEndpoint;
            Object implementor = endpoint.getImplementor();
            boolean bl = isHttpEndpoint = endpoint.getAddress() != null && endpoint.getAddress().substring(0, 5).toLowerCase(Locale.ENGLISH).startsWith("http");
            if (endpoint.getInvoker() == null && isHttpEndpoint) {
                endpoint.setInvoker(new JBossWSInvoker());
            }
            String endpointClassName = implementor.getClass().getName();
            List depEndpoints = this.dep.getService().getEndpoints();
            for (Endpoint depEndpoint : depEndpoints) {
                if (!endpointClassName.equals(depEndpoint.getTargetBeanName())) continue;
                EndpointConfig config = depEndpoint.getEndpointConfig();
                if (config == null) {
                    BasicConfigResolver bcr = new BasicConfigResolver(this.dep, implementor.getClass());
                    config = bcr.resolveEndpointConfig();
                    depEndpoint.setEndpointConfig(config);
                }
                if (config == null) continue;
                endpoint.setEndpointConfig((CommonConfig)config);
            }
            JASPIAuthenticationProvider jaspiProvider = (JASPIAuthenticationProvider)ServiceLoader.loadService((String)JASPIAuthenticationProvider.class.getName(), null, (ClassLoader)ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
            if (jaspiProvider == null) {
                Loggers.DEPLOYMENT_LOGGER.cannotFindJaspiClasses();
            } else if (jaspiProvider.enableServerAuthentication((Object)endpoint, (Endpoint)depEndpoints.get(0))) {
                endpoint.getInInterceptors().add(new AuthenticationMgrSubjectCreatingInterceptor());
            }
        }
    }

    public void setWsdlPublisher(WSDLFilePublisher wsdlPublisher) {
        this.wsdlPublisher = wsdlPublisher;
    }

    public void setDeployment(ArchiveDeployment dep) {
        this.dep = dep;
    }
}

