/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.component;

import java.util.Map;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.EntityInstantiator;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.MultiPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.relation.ToOneIdMapper;
import org.hibernate.envers.internal.entities.mapper.relation.component.MiddleComponentMapper;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.internal.util.ReflectHelper;

public class MiddleEmbeddableComponentMapper
implements MiddleComponentMapper,
CompositeMapperBuilder {
    private final MultiPropertyMapper delegate;
    private final Class componentClass;

    public MiddleEmbeddableComponentMapper(MultiPropertyMapper delegate, Class componentClass) {
        this.delegate = delegate;
        this.componentClass = componentClass;
    }

    @Override
    public Object mapToObjectFromFullMap(EntityInstantiator entityInstantiator, Map<String, Object> data, Object dataObject, Number revision) {
        try {
            Object componentInstance = dataObject != null ? dataObject : ReflectHelper.getDefaultConstructor((Class)this.componentClass).newInstance(new Object[0]);
            this.delegate.mapToEntityFromMap(entityInstantiator.getAuditConfiguration(), componentInstance, data, null, entityInstantiator.getAuditReaderImplementor(), revision);
            return componentInstance;
        }
        catch (Exception e) {
            throw new AuditException(e);
        }
    }

    @Override
    public void mapToMapFromObject(SessionImplementor session, Map<String, Object> idData, Map<String, Object> data, Object obj) {
        this.delegate.mapToMapFromEntity(session, data, obj, obj);
    }

    @Override
    public void addMiddleEqualToQuery(Parameters parameters, String idPrefix1, String prefix1, String idPrefix2, String prefix2) {
        this.addMiddleEqualToQuery(this.delegate, parameters, idPrefix1, prefix1, idPrefix2, prefix2);
    }

    protected void addMiddleEqualToQuery(CompositeMapperBuilder compositeMapper, Parameters parameters, String idPrefix1, String prefix1, String idPrefix2, String prefix2) {
        for (Map.Entry<PropertyData, PropertyMapper> entry : compositeMapper.getProperties().entrySet()) {
            String propertyName = entry.getKey().getName();
            PropertyMapper nestedMapper = entry.getValue();
            if (nestedMapper instanceof CompositeMapperBuilder) {
                this.addMiddleEqualToQuery((CompositeMapperBuilder)((Object)nestedMapper), parameters, idPrefix1, prefix1, idPrefix2, prefix2);
                continue;
            }
            if (nestedMapper instanceof ToOneIdMapper) {
                ((ToOneIdMapper)nestedMapper).addMiddleEqualToQuery(parameters, idPrefix1, prefix1, idPrefix2, prefix2);
                continue;
            }
            Parameters sub1 = parameters.addSubParameters("or");
            sub1.addWhere(prefix1 + '.' + propertyName, false, "=", prefix2 + '.' + propertyName, false);
            Parameters sub2 = sub1.addSubParameters("and");
            sub2.addNullRestriction(prefix1 + '.' + propertyName, false);
            sub2.addNullRestriction(prefix2 + '.' + propertyName, false);
        }
    }

    @Override
    public CompositeMapperBuilder addComponent(PropertyData propertyData, Class componentClass) {
        return this.delegate.addComponent(propertyData, componentClass);
    }

    @Override
    public void addComposite(PropertyData propertyData, PropertyMapper propertyMapper) {
        this.delegate.addComposite(propertyData, propertyMapper);
    }

    @Override
    public void add(PropertyData propertyData) {
        this.delegate.add(propertyData);
    }

    @Override
    public Map<PropertyData, PropertyMapper> getProperties() {
        return this.delegate.getProperties();
    }
}

