/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.ha;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ColocatedPolicyConfiguration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.messaging.activemq.ActiveMQReloadRequiredHandlers;
import org.wildfly.extension.messaging.activemq.MessagingExtension;
import org.wildfly.extension.messaging.activemq.ha.HAAttributes;
import org.wildfly.extension.messaging.activemq.ha.ManagementHelper;
import org.wildfly.extension.messaging.activemq.ha.ReplicationMasterDefinition;
import org.wildfly.extension.messaging.activemq.ha.ReplicationSlaveDefinition;

public class ReplicationColocatedDefinition
extends PersistentResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"ha-policy", (String)"replication-colocated");
    public static Collection<AttributeDefinition> ATTRIBUTES = Collections.unmodifiableList(Arrays.asList(HAAttributes.REQUEST_BACKUP, HAAttributes.BACKUP_REQUEST_RETRIES, HAAttributes.BACKUP_REQUEST_RETRY_INTERVAL, HAAttributes.MAX_BACKUPS, HAAttributes.BACKUP_PORT_OFFSET, HAAttributes.EXCLUDED_CONNECTORS));
    public static final ReplicationColocatedDefinition INSTANCE = new ReplicationColocatedDefinition();

    private ReplicationColocatedDefinition() {
        super(PATH, MessagingExtension.getResourceDescriptionResolver("ha-policy"), (OperationStepHandler)ManagementHelper.createAddOperation("ha-policy", false, ATTRIBUTES), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ActiveMQReloadRequiredHandlers.WriteAttributeHandler writeAttribute = new ActiveMQReloadRequiredHandlers.WriteAttributeHandler(ATTRIBUTES);
        for (AttributeDefinition attribute : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)writeAttribute);
        }
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    protected List<? extends PersistentResourceDefinition> getChildren() {
        return Collections.unmodifiableList(Arrays.asList(new PersistentResourceDefinition[]{ReplicationMasterDefinition.CONFIGURATION_INSTANCE, ReplicationSlaveDefinition.CONFIGURATION_INSTANCE}));
    }

    static HAPolicyConfiguration buildConfiguration(OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode slaveConfigurationModel;
        ModelNode masterConfigurationModel;
        ColocatedPolicyConfiguration haPolicyConfiguration = new ColocatedPolicyConfiguration().setRequestBackup(HAAttributes.REQUEST_BACKUP.resolveModelAttribute(context, model).asBoolean()).setBackupRequestRetries(HAAttributes.BACKUP_REQUEST_RETRIES.resolveModelAttribute(context, model).asInt()).setBackupRequestRetryInterval(HAAttributes.BACKUP_REQUEST_RETRY_INTERVAL.resolveModelAttribute(context, model).asLong()).setMaxBackups(HAAttributes.MAX_BACKUPS.resolveModelAttribute(context, model).asInt()).setBackupPortOffset(HAAttributes.BACKUP_PORT_OFFSET.resolveModelAttribute(context, model).asInt());
        ModelNode connectors = HAAttributes.EXCLUDED_CONNECTORS.resolveModelAttribute(context, model);
        if (connectors.isDefined()) {
            ArrayList connectorNames = new ArrayList(connectors.keys());
            haPolicyConfiguration.setExcludedConnectors(connectorNames);
        }
        if ((masterConfigurationModel = model.get(new String[]{"configuration", "master"})).isDefined()) {
            HAPolicyConfiguration masterConfiguration = ReplicationMasterDefinition.buildConfiguration(context, masterConfigurationModel);
            haPolicyConfiguration.setLiveConfig(masterConfiguration);
        }
        if ((slaveConfigurationModel = model.get(new String[]{"configuration", "slave"})).isDefined()) {
            HAPolicyConfiguration slaveConfiguration = ReplicationSlaveDefinition.buildConfiguration(context, slaveConfigurationModel);
            haPolicyConfiguration.setBackupConfig(slaveConfiguration);
        }
        return haPolicyConfiguration;
    }
}

