/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.journal;

import org.hornetq.core.journal.impl.JournalFile;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="HQ")
public interface HornetQJournalLogger
extends BasicLogger {
    public static final HornetQJournalLogger LOGGER = Logger.getMessageLogger(HornetQJournalLogger.class, HornetQJournalLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=141000, value="*** running direct journal blast: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void runningJournalBlast(Integer var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=141002, value="starting thread for sync speed test", format=Message.Format.MESSAGE_FORMAT)
    public void startingThread();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=141003, value="Write rate = {0} bytes / sec or {1} MiB / sec", format=Message.Format.MESSAGE_FORMAT)
    public void writeRate(Double var1, Long var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=141004, value="Flush rate = {0} flushes / sec", format=Message.Format.MESSAGE_FORMAT)
    public void flushRate(Double var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=141005, value="Check Data Files:", format=Message.Format.MESSAGE_FORMAT)
    public void checkFiles();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=141006, value="Sequence out of order on journal", format=Message.Format.MESSAGE_FORMAT)
    public void seqOutOfOrder();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=141007, value="Current File on the journal is <= the sequence file.getFileID={0} on the dataFiles\nCurrentfile.getFileId={1} while the file.getFileID()={2}\nIs same = ({3})", format=Message.Format.MESSAGE_FORMAT)
    public void currentFile(Long var1, Long var2, Long var3, Boolean var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=141008, value="Free File ID out of order", format=Message.Format.MESSAGE_FORMAT)
    public void fileIdOutOfOrder();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=141009, value="A Free File is less than the maximum data", format=Message.Format.MESSAGE_FORMAT)
    public void fileTooSmall();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142000, value="You have a native library with a different version than expected", format=Message.Format.MESSAGE_FORMAT)
    public void incompatibleNativeLibrary();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142001, value="Could not get lock after 60 seconds on closing Asynchronous File: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void couldNotGetLock(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142002, value="Asynchronous File: {0} being finalized with opened state", format=Message.Format.MESSAGE_FORMAT)
    public void fileFinalizedWhileOpen(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142003, value="AIO Callback Error: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void callbackError(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142004, value="Inconsistency during compacting: CommitRecord ID = {0} for an already committed transaction during compacting", format=Message.Format.MESSAGE_FORMAT)
    public void inconsistencyDuringCompacting(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142005, value="Inconsistency during compacting: Delete record being read on an existent record (id={0})", format=Message.Format.MESSAGE_FORMAT)
    public void inconsistencyDuringCompactingDelete(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142006, value="Could not find add Record information for record {0} during compacting", format=Message.Format.MESSAGE_FORMAT)
    public void compactingWithNoAddRecord(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142007, value="Can not find record {0} during compact replay", format=Message.Format.MESSAGE_FORMAT)
    public void noRecordDuringCompactReplay(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142008, value="Could not remove file {0} from the list of data files", format=Message.Format.MESSAGE_FORMAT)
    public void couldNotRemoveFile(JournalFile var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142009, value="Deleting {0} as it does not have the configured size", format=Message.Format.MESSAGE_FORMAT)
    public void deletingFile(JournalFile var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142010, value="Failed to add file to opened files queue: {0}. This should NOT happen!", format=Message.Format.MESSAGE_FORMAT)
    public void failedToAddFile(JournalFile var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142011, value="Error on reading compacting for {0}", format=Message.Format.MESSAGE_FORMAT)
    public void compactReadError(JournalFile var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142012, value="Couldn''t find tx={0} to merge after compacting", format=Message.Format.MESSAGE_FORMAT)
    public void compactMergeError(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142013, value="Prepared transaction {0} was not considered completed, it will be ignored", format=Message.Format.MESSAGE_FORMAT)
    public void preparedTXIncomplete(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142014, value="Transaction {0} is missing elements so the transaction is being ignored", format=Message.Format.MESSAGE_FORMAT)
    public void txMissingElements(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142015, value="Uncommitted transaction with id {0} found and discarded", format=Message.Format.MESSAGE_FORMAT)
    public void uncomittedTxFound(Long var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142016, value="Couldn''t stop compactor executor after 120 seconds", format=Message.Format.MESSAGE_FORMAT)
    public void couldNotStopCompactor();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142017, value="Couldn''t stop journal executor after 60 seconds", format=Message.Format.MESSAGE_FORMAT)
    public void couldNotStopJournalExecutor();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142018, value="Temporary files were left unnatended after a crash on journal directory, deleting invalid files now", format=Message.Format.MESSAGE_FORMAT)
    public void tempFilesLeftOpen();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142019, value="Deleting orphaned file {0}", format=Message.Format.MESSAGE_FORMAT)
    public void deletingOrphanedFile(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142020, value="Couldn''t get lock after 60 seconds on closing Asynchronous File: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorClosingFile(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142021, value="Error on IO callback, {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorOnIOCallback(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142022, value="Timed out on AIO poller shutdown", format=Message.Format.MESSAGE_FORMAT)
    public void timeoutOnPollerShutdown(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142023, value="Executor on file {0} couldn''t complete its tasks in 60 seconds.", format=Message.Format.MESSAGE_FORMAT)
    public void couldNotCompleteTask(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142024, value="Error completing callback", format=Message.Format.MESSAGE_FORMAT)
    public void errorCompletingCallback(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142025, value="Error calling onError callback", format=Message.Format.MESSAGE_FORMAT)
    public void errorCallingErrorCallback(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142026, value="Timed out on AIO writer shutdown", format=Message.Format.MESSAGE_FORMAT)
    public void timeoutOnWriterShutdown(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142027, value="Error on writing data! {0} code - {1}", format=Message.Format.MESSAGE_FORMAT)
    public void errorWritingData(@Cause Throwable var1, String var2, Integer var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142028, value="Error replaying pending commands after compacting", format=Message.Format.MESSAGE_FORMAT)
    public void errorReplayingCommands(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142029, value="Error closing file", format=Message.Format.MESSAGE_FORMAT)
    public void errorClosingFile(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142030, value="Could not open a file in 60 Seconds", format=Message.Format.MESSAGE_FORMAT)
    public void errorOpeningFile(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142031, value="Error retrieving ID part of the file name {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorRetrievingID(@Cause Throwable var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142032, value="Error reading journal file", format=Message.Format.MESSAGE_FORMAT)
    public void errorReadingFile(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142033, value="Error reinitializing file {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorReinitializingFile(@Cause Throwable var1, JournalFile var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=142034, value="Exception on submitting write", format=Message.Format.MESSAGE_FORMAT)
    public void errorSubmittingWrite(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=144000, value="Failed to delete file {0}", format=Message.Format.MESSAGE_FORMAT)
    public void errorDeletingFile(Object var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=144001, value="Error starting poller", format=Message.Format.MESSAGE_FORMAT)
    public void errorStartingPoller(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=144002, value="Error pushing opened file", format=Message.Format.MESSAGE_FORMAT)
    public void errorPushingFile(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=144003, value="Error compacting", format=Message.Format.MESSAGE_FORMAT)
    public void errorCompacting(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=144004, value="Error scheduling compacting", format=Message.Format.MESSAGE_FORMAT)
    public void errorSchedulingCompacting(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=144005, value="Failed to performance blast", format=Message.Format.MESSAGE_FORMAT)
    public void failedToPerfBlast(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=144006, value="IOError code {0}, {1}", format=Message.Format.MESSAGE_FORMAT)
    public void ioError(int var1, String var2);
}

