/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.repository;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import org.jberet._private.BatchLogger;
import org.jberet.job.model.Job;
import org.jberet.repository.AbstractRepository;
import org.jberet.repository.JobExecutionSelector;
import org.jberet.repository.JobRepository;
import org.jberet.repository.SoftReference;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.JobInstanceImpl;
import org.jberet.runtime.StepExecutionImpl;

public abstract class AbstractPersistentRepository
extends AbstractRepository
implements JobRepository {
    final ConcurrentMap<Long, SoftReference<JobExecutionImpl, Long>> jobExecutions = new ConcurrentHashMap<Long, SoftReference<JobExecutionImpl, Long>>();
    final ConcurrentMap<Long, SoftReference<JobInstanceImpl, Long>> jobInstances = new ConcurrentHashMap<Long, SoftReference<JobInstanceImpl, Long>>();
    final ReferenceQueue<JobExecutionImpl> jobExecutionReferenceQueue = new ReferenceQueue();
    final ReferenceQueue<JobInstanceImpl> jobInstanceReferenceQueue = new ReferenceQueue();

    @Override
    abstract void insertJobInstance(JobInstanceImpl var1);

    @Override
    abstract void insertJobExecution(JobExecutionImpl var1);

    @Override
    abstract void insertStepExecution(StepExecutionImpl var1, JobExecutionImpl var2);

    abstract List<StepExecution> selectStepExecutions(Long var1, ClassLoader var2);

    @Override
    public void removeJob(String jobId) {
        super.removeJob(jobId);
        Iterator it = this.jobInstances.entrySet().iterator();
        while (it.hasNext()) {
            JobInstanceImpl ji = (JobInstanceImpl)((SoftReference)it.next().getValue()).get();
            if (ji == null || !ji.getJobName().equals(jobId)) continue;
            BatchLogger.LOGGER.removing(JobInstance.class.getName(), String.valueOf(ji.getInstanceId()));
            it.remove();
        }
        it = this.jobExecutions.entrySet().iterator();
        while (it.hasNext()) {
            JobExecutionImpl je = (JobExecutionImpl)((SoftReference)it.next().getValue()).get();
            if (je == null || !je.getJobName().equals(jobId)) continue;
            if (je.getJobParameters() != null) {
                je.getJobParameters().clear();
            }
            BatchLogger.LOGGER.removing(JobExecution.class.getName(), String.valueOf(je.getExecutionId()));
            it.remove();
        }
    }

    @Override
    public void removeJobExecutions(JobExecutionSelector jobExecutionSelector) {
        Set<Long> allJobExecutionIds = this.jobExecutions.keySet();
        Iterator it = this.jobExecutions.entrySet().iterator();
        while (it.hasNext()) {
            JobExecutionImpl je = (JobExecutionImpl)((SoftReference)it.next().getValue()).get();
            if (je == null || jobExecutionSelector != null && !jobExecutionSelector.select(je, allJobExecutionIds)) continue;
            if (je.getJobParameters() != null) {
                je.getJobParameters().clear();
            }
            BatchLogger.LOGGER.removing(JobExecution.class.getName(), String.valueOf(je.getExecutionId()));
            it.remove();
        }
    }

    @Override
    public JobInstanceImpl createJobInstance(Job job, String applicationName, ClassLoader classLoader) {
        Reference<JobInstanceImpl> x;
        while ((x = this.jobInstanceReferenceQueue.poll()) != null) {
            SoftReference entry = (SoftReference)x;
            this.jobInstances.remove(entry.getKey());
        }
        JobInstanceImpl jobInstance = new JobInstanceImpl(job, applicationName, job.getId());
        this.insertJobInstance(jobInstance);
        Long instanceId = jobInstance.getInstanceId();
        this.jobInstances.put(instanceId, new SoftReference<JobInstanceImpl, Long>(jobInstance, this.jobInstanceReferenceQueue, instanceId));
        return jobInstance;
    }

    @Override
    public void removeJobInstance(long jobInstanceIdToRemove) {
        BatchLogger.LOGGER.removing(JobInstance.class.getName(), String.valueOf(jobInstanceIdToRemove));
        this.jobInstances.remove(jobInstanceIdToRemove);
    }

    @Override
    public JobInstanceImpl getJobInstance(long jobInstanceId) {
        SoftReference jobInstanceSoftReference = (SoftReference)this.jobInstances.get(jobInstanceId);
        return jobInstanceSoftReference != null ? (JobInstanceImpl)jobInstanceSoftReference.get() : null;
    }

    @Override
    public JobExecutionImpl createJobExecution(JobInstanceImpl jobInstance, Properties jobParameters) {
        Reference<JobExecutionImpl> x;
        while ((x = this.jobExecutionReferenceQueue.poll()) != null) {
            SoftReference entry = (SoftReference)x;
            this.jobExecutions.remove(entry.getKey());
        }
        JobExecutionImpl jobExecution = new JobExecutionImpl(jobInstance, jobParameters);
        this.insertJobExecution(jobExecution);
        Long executionId = jobExecution.getExecutionId();
        this.jobExecutions.put(executionId, new SoftReference<JobExecutionImpl, Long>(jobExecution, this.jobExecutionReferenceQueue, executionId));
        jobInstance.addJobExecution(jobExecution);
        return jobExecution;
    }

    @Override
    public JobExecutionImpl getJobExecution(long jobExecutionId) {
        SoftReference jobExecutionSoftReference = (SoftReference)this.jobExecutions.get(jobExecutionId);
        return jobExecutionSoftReference != null ? (JobExecutionImpl)jobExecutionSoftReference.get() : null;
    }

    @Override
    public List<StepExecution> getStepExecutions(long jobExecutionId, ClassLoader classLoader) {
        List<StepExecution> stepExecutions1;
        JobExecutionImpl jobExecution;
        SoftReference ref = (SoftReference)this.jobExecutions.get(jobExecutionId);
        JobExecutionImpl jobExecutionImpl = jobExecution = ref != null ? (JobExecutionImpl)ref.get() : null;
        List<StepExecution> stepExecutions = jobExecution == null ? this.selectStepExecutions(jobExecutionId, classLoader) : ((stepExecutions1 = jobExecution.getStepExecutions()).isEmpty() ? this.selectStepExecutions(jobExecutionId, classLoader) : stepExecutions1);
        return stepExecutions;
    }

    @Override
    public StepExecutionImpl findOriginalStepExecutionForRestart(String stepName, JobExecutionImpl jobExecutionToRestart, ClassLoader classLoader) {
        for (StepExecution stepExecution : jobExecutionToRestart.getStepExecutions()) {
            if (!stepName.equals(stepExecution.getStepName())) continue;
            return (StepExecutionImpl)stepExecution;
        }
        AbstractStepExecution result = null;
        long instanceId = jobExecutionToRestart.getJobInstance().getInstanceId();
        for (SoftReference e : this.jobExecutions.values()) {
            JobExecutionImpl jobExecutionImpl = (JobExecutionImpl)e.get();
            if (jobExecutionImpl == null || instanceId != jobExecutionImpl.getJobInstance().getInstanceId() || jobExecutionImpl.getExecutionId() == jobExecutionToRestart.getExecutionId()) continue;
            for (StepExecution stepExecution : jobExecutionImpl.getStepExecutions()) {
                if (!stepExecution.getStepName().equals(stepName) || result != null && result.getStepExecutionId() >= stepExecution.getStepExecutionId()) continue;
                result = (StepExecutionImpl)stepExecution;
            }
        }
        return result;
    }
}

